/*
 * Decompiled with CFR 0.152.
 */
package net.lostpatrol.tradetweaks.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.lostpatrol.tradetweaks.config.ClientConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tradetweaks", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ItemRenderer {
    public static float alphaValue = 1.0f;

    @OnlyIn(value=Dist.CLIENT)
    public static void renderItemForMessage(GuiGraphics guiGraphics, FormattedCharSequence sequence, float x, float y, int color) {
        if (!ClientConfig.tempRenderFlag) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        StringBuilder before = new StringBuilder();
        int halfSpace = mc.f_91062_.m_92895_(" ") / 2;
        final class OffsetContext {
            float offset;
            final /* synthetic */ int val$halfSpace;

            OffsetContext(int n) {
                this.val$halfSpace = n;
                this.offset = -this.val$halfSpace;
            }
        }
        OffsetContext context = new OffsetContext(halfSpace);
        sequence.m_13731_((counter_, style, character) -> {
            String sofar = before.toString();
            if (sofar.endsWith(":  ")) {
                int s_length = mc.f_91062_.m_92895_(sofar.substring(0, sofar.length() - 2));
                if (ModList.get().isLoaded("chat_heads")) {
                    ItemRenderer.render(guiGraphics, s_length + 5 * halfSpace, character == 32 ? 0.0f : (float)(-halfSpace), x, y, style, color);
                } else {
                    ItemRenderer.render(guiGraphics, s_length, character == 32 ? 0.0f : (float)(-halfSpace), x, y, style, color);
                }
                return false;
            }
            if (sofar.endsWith("  ")) {
                float shift = (float)mc.f_91062_.m_92895_(before.substring(0, before.length() - 2)) + context.offset;
                ItemRenderer.render(guiGraphics, shift, 0.0f, x, y, style, color);
                context.offset += (float)(mc.f_91062_.m_92895_(String.valueOf(before)) + 2 * halfSpace);
                before.setLength(0);
                return true;
            }
            before.append((char)character);
            return true;
        });
    }

    public static MutableComponent createStackComponent(ItemStack stack, MutableComponent component) {
        if (!ClientConfig.tempRenderFlag) {
            return component;
        }
        Style style = component.m_7383_();
        ItemStack copyStack = stack.m_41777_();
        if (stack.m_41613_() > 64) {
            copyStack.m_41764_(64);
        }
        style = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(copyStack)));
        component.m_130948_(style);
        MutableComponent out = Component.m_237113_((String)"   ");
        out.m_6270_(style);
        return out.m_7220_((Component)component);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void render(GuiGraphics guiGraphics, float shift, float extraShift, float x, float y, Style style, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        PoseStack pose = guiGraphics.m_280168_();
        HoverEvent hoverEvent = style.m_131186_();
        if (hoverEvent != null && hoverEvent.m_130820_() == HoverEvent.Action.f_130832_) {
            ItemStack stack;
            HoverEvent.ItemStackInfo contents = (HoverEvent.ItemStackInfo)hoverEvent.m_130823_(HoverEvent.Action.f_130832_);
            ItemStack itemStack = stack = contents != null ? contents.m_130898_() : ItemStack.f_41583_;
            if (stack.m_41619_()) {
                stack = new ItemStack((ItemLike)Blocks.f_50375_);
            }
            float x_shift = shift + extraShift;
            if (ModList.get().isLoaded("overflowingbars") && Minecraft.m_91087_().f_91074_ != null) {
                y += Minecraft.m_91087_().f_91074_.m_6103_() > 10.0f ? 10.0f : 0.0f;
                y += (float)Minecraft.m_91087_().f_91074_.m_21230_() > 0.5f ? 10.0f : 0.0f;
            }
            if (a > 0.0f) {
                alphaValue = a;
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252931_(pose.m_85850_().m_252922_());
                guiGraphics.m_280168_().m_252880_(x_shift + x, y, 0.0f);
                guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
                guiGraphics.m_280480_(stack, 0, 0);
                guiGraphics.m_280168_().m_85849_();
                RenderSystem.applyModelViewMatrix();
                alphaValue = 1.0f;
            }
        }
    }
}

