/*
 * Decompiled with CFR 0.152.
 */
package net.lostpatrol.tradetweaks.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.lostpatrol.tradetweaks.common.tradecast.VillagerTradeReporter;
import net.lostpatrol.tradetweaks.config.ClientConfig;
import net.lostpatrol.tradetweaks.config.ServerConfig;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;

public class TradeBroadcastCommand {
    public static void register() {
        MinecraftForge.EVENT_BUS.addListener(TradeBroadcastCommand::registerCommands);
    }

    private static void registerCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tradecast").executes(ctx -> TradeBroadcastCommand.showSettings((CommandSourceStack)ctx.getSource()))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"mode").then(Commands.m_82127_((String)"off").executes(ctx -> TradeBroadcastCommand.setPlayerMode((CommandSourceStack)ctx.getSource(), ClientConfig.ReportMode.OFF)))).then(Commands.m_82127_((String)"librarian").executes(ctx -> TradeBroadcastCommand.setPlayerMode((CommandSourceStack)ctx.getSource(), ClientConfig.ReportMode.LIBRARIAN_ONLY)))).then(Commands.m_82127_((String)"all").executes(ctx -> TradeBroadcastCommand.setPlayerMode((CommandSourceStack)ctx.getSource(), ClientConfig.ReportMode.ALL_VILLAGERS))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"time").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10)).executes(ctx -> TradeBroadcastCommand.setServerInterval((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"seconds")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"radius").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"blocks", (ArgumentType)IntegerArgumentType.integer((int)1, (int)32)).executes(ctx -> TradeBroadcastCommand.setServerRadius((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"blocks")))))).then(Commands.m_82127_((String)"refresh").executes(ctx -> TradeBroadcastCommand.refresh((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"render").then(Commands.m_82129_((String)"flag", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> TradeBroadcastCommand.setRenderMode((CommandSourceStack)ctx.getSource(), BoolArgumentType.getBool((CommandContext)ctx, (String)"flag"))))));
    }

    private static int showSettings(CommandSourceStack source) {
        MutableComponent message = Component.m_237115_((String)"tradetweaks.tradecast.settings.header").m_130946_("\n");
        if (source.m_230896_() != null) {
            String modeKey = "tradetweaks.tradecast.mode." + ClientConfig.getMode().toString().toLowerCase();
            message.m_7220_((Component)Component.m_237110_((String)"tradetweaks.tradecast.settings.mode", (Object[])new Object[]{Component.m_237115_((String)modeKey)}).m_130946_("\n"));
            message.m_7220_((Component)Component.m_237110_((String)"tradetweaks.tradecast.settings.render", (Object[])new Object[]{String.valueOf(ClientConfig.getRenderMode())}).m_130946_("\n"));
        }
        message.m_7220_((Component)Component.m_237110_((String)"tradetweaks.tradecast.settings.interval", (Object[])new Object[]{ServerConfig.getCheckInterval()})).m_130946_("\n");
        message.m_7220_((Component)Component.m_237110_((String)"tradetweaks.tradecast.settings.radius", (Object[])new Object[]{ServerConfig.getCheckRadius()}));
        source.m_288197_(() -> message, false);
        return 1;
    }

    private static int setServerInterval(CommandSourceStack source, int seconds) {
        ServerConfig.setCheckInterval(seconds);
        source.m_288197_(() -> Component.m_237110_((String)"tradetweaks.tradecast.interval.set", (Object[])new Object[]{seconds}), false);
        ServerConfig.tempIntervalTicks = seconds * 20;
        return 1;
    }

    private static int setServerRadius(CommandSourceStack source, int blocks) {
        ServerConfig.setCheckRadius(blocks);
        source.m_288197_(() -> Component.m_237110_((String)"tradetweaks.tradecast.radius.set", (Object[])new Object[]{blocks}), false);
        ServerConfig.tempRadiusBlocks = blocks;
        return 1;
    }

    private static int setPlayerMode(CommandSourceStack source, ClientConfig.ReportMode mode) {
        if (source.m_230896_() != null) {
            ClientConfig.setMode(mode);
            ClientConfig.tempMode = mode;
            String modeKey = "tradetweaks.tradecast.mode." + mode.toString().toLowerCase();
            source.m_288197_(() -> Component.m_237110_((String)"tradetweaks.tradecast.mode.set", (Object[])new Object[]{Component.m_237115_((String)modeKey)}), false);
        } else {
            source.m_81352_((Component)Component.m_237115_((String)"tradetweaks.tradecast.mode.error"));
        }
        return 1;
    }

    private static int refresh(CommandSourceStack source) {
        Entity entity = source.m_81373_();
        if (!(entity instanceof Player)) {
            source.m_81352_((Component)Component.m_237115_((String)"tradetweaks.tradecast.refresh.fail.not_player"));
            return 0;
        }
        Player player = (Player)entity;
        VillagerTradeReporter.PlayerTradeData playerData = VillagerTradeReporter.playerTradeDataMap.get(player.m_20148_());
        if (playerData == null) {
            source.m_81352_((Component)Component.m_237115_((String)"tradetweaks.tradecast.refresh.fail.no_data"));
            return 0;
        }
        playerData.reportedVillagers.clear();
        playerData.lastKnownOffers.clear();
        source.m_288197_(() -> Component.m_237115_((String)"tradetweaks.tradecast.refresh.success"), false);
        return 1;
    }

    private static int setRenderMode(CommandSourceStack source, boolean flag) {
        if (source.m_230896_() != null) {
            ClientConfig.setRenderMode(flag);
            ClientConfig.tempRenderFlag = flag;
            source.m_288197_(() -> Component.m_237110_((String)"tradetweaks.tradecast.render.set", (Object[])new Object[]{String.valueOf(flag)}), false);
        } else {
            source.m_81352_((Component)Component.m_237115_((String)"tradetweaks.tradecast.render.error"));
        }
        return 1;
    }
}

