/*
 * Decompiled with CFR 0.152.
 */
package net.lostpatrol.tradetweaks.common.select;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import net.lostpatrol.tradetweaks.TradeTweaks;
import net.lostpatrol.tradetweaks.util.CompareTrades;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TradeReplacer {
    @OnlyIn(value=Dist.CLIENT)
    public static List<MerchantOffer> getPossibleTrades(MerchantOffer selectedOffer, int professionLevel, VillagerProfession profession, Villager dummyVillager) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return null;
        }
        if (profession == null || profession == VillagerProfession.f_35585_) {
            return null;
        }
        ArrayList<MerchantOffer> possibleTrades = new ArrayList<MerchantOffer>();
        Int2ObjectMap tradesMap = (Int2ObjectMap)VillagerTrades.f_35627_.get(profession);
        if (tradesMap != null && !tradesMap.isEmpty()) {
            int levelOfTrade = TradeReplacer.getLevelOfTrade(selectedOffer, (Int2ObjectMap<VillagerTrades.ItemListing[]>)tradesMap, dummyVillager);
            if (levelOfTrade == -1 || levelOfTrade > professionLevel) {
                return null;
            }
            VillagerTrades.ItemListing[] listings = (VillagerTrades.ItemListing[])tradesMap.get(levelOfTrade);
            if (listings != null) {
                for (VillagerTrades.ItemListing listing : listings) {
                    try {
                        MerchantOffer offer = listing.m_213663_((Entity)dummyVillager, dummyVillager.m_217043_());
                        if (offer == null || !TradeReplacer.isValidReplacement(offer)) continue;
                        possibleTrades.add(offer);
                    }
                    catch (Exception e) {
                        TradeTweaks.LOGGER.error("Failed to generate trade offer", (Throwable)e);
                    }
                }
            }
        }
        return possibleTrades;
    }

    private static boolean isValidReplacement(MerchantOffer replacement) {
        return true;
    }

    private static int getLevelOfTrade(MerchantOffer selectedOffer, Int2ObjectMap<VillagerTrades.ItemListing[]> tradesMap, Villager dummyVillager) {
        for (int lvl = 1; lvl <= 5; ++lvl) {
            VillagerTrades.ItemListing[] listings = (VillagerTrades.ItemListing[])tradesMap.get(lvl);
            if (listings == null) continue;
            for (VillagerTrades.ItemListing listing : listings) {
                MerchantOffer offer = listing.m_213663_((Entity)dummyVillager, dummyVillager.m_217043_());
                if (offer == null || !CompareTrades.isCounterpartTrade(offer, selectedOffer)) continue;
                return lvl;
            }
        }
        return -1;
    }
}

