/*
 * Decompiled with CFR 0.152.
 */
package net.lostpatrol.tradetweaks.common.tradecast;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.lostpatrol.tradetweaks.config.ClientConfig;
import net.lostpatrol.tradetweaks.config.ServerConfig;
import net.lostpatrol.tradetweaks.util.DeepCopy;
import net.lostpatrol.tradetweaks.util.DisplayRoman;
import net.lostpatrol.tradetweaks.util.VillagerUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class VillagerTradeReporter {
    public static final int DURATION_TICKS = 300;
    public static final Map<UUID, PlayerTradeData> playerTradeDataMap = new HashMap<UUID, PlayerTradeData>();

    public static void register() {
        MinecraftForge.EVENT_BUS.addListener(VillagerTradeReporter::onPlayerTick);
        MinecraftForge.EVENT_BUS.addListener(VillagerTradeReporter::onVillagerDeath);
    }

    private static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (ClientConfig.tempMode == ClientConfig.ReportMode.OFF) {
            return;
        }
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().f_46443_) {
            return;
        }
        if (event.player.m_9236_().m_46467_() % (long)ServerConfig.tempIntervalTicks != 0L) {
            return;
        }
        List villagers = event.player.m_9236_().m_6443_(AbstractVillager.class, new AABB(event.player.m_20183_()).m_82400_((double)ServerConfig.tempRadiusBlocks), villager -> {
            if (!(villager instanceof Villager)) {
                return false;
            }
            if (!villager.m_6084_()) {
                return false;
            }
            if (ClientConfig.tempMode == ClientConfig.ReportMode.LIBRARIAN_ONLY) {
                return ((Villager)villager).m_7141_().m_35571_() == VillagerProfession.f_35594_;
            }
            return true;
        });
        PlayerTradeData playerData = VillagerTradeReporter.getPlayerData(event.player.m_20148_());
        for (AbstractVillager villager2 : villagers) {
            if (!(villager2 instanceof Villager)) continue;
            Villager v = (Villager)villager2;
            MerchantOffers currentOffers = v.m_6616_();
            UUID villagerId = v.m_20148_();
            if (!VillagerTradeReporter.hasOffersChanged(playerData, villagerId, currentOffers)) continue;
            VillagerTradeReporter.reportTrades(v, event.player, false);
            playerData.lastKnownOffers.put(villagerId, DeepCopy.deepCopyOffers(currentOffers));
        }
    }

    private static boolean hasOffersChanged(PlayerTradeData playerData, UUID villagerId, MerchantOffers currentOffers) {
        if (!playerData.lastKnownOffers.containsKey(villagerId)) {
            return true;
        }
        MerchantOffers lastOffers = playerData.lastKnownOffers.get(villagerId);
        if (lastOffers.size() != currentOffers.size()) {
            return true;
        }
        for (int i = 0; i < currentOffers.size(); ++i) {
            if (VillagerTradeReporter.compareOffers((MerchantOffer)lastOffers.get(i), (MerchantOffer)currentOffers.get(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean compareOffers(MerchantOffer a, MerchantOffer b) {
        if (!ItemStack.m_41728_((ItemStack)a.m_45352_(), (ItemStack)b.m_45352_())) {
            return false;
        }
        if (!ItemStack.m_41728_((ItemStack)a.m_45364_(), (ItemStack)b.m_45364_())) {
            return false;
        }
        return ItemStack.m_41728_((ItemStack)a.m_45368_(), (ItemStack)b.m_45368_());
    }

    public static void reportTrades(Villager villager, Player player, boolean usingWand) {
        MerchantOffers offers = villager.m_6616_();
        if (offers.isEmpty()) {
            return;
        }
        boolean hasMending = false;
        VillagerData data = villager.m_7141_();
        Component professionName = VillagerUtil.getProfessionComponent(data.m_35571_());
        Component levelName = VillagerUtil.getLevelComponent(data.m_35576_());
        MutableComponent header = Component.m_237110_((String)"tradetweaks.tradecast.report.header", (Object[])new Object[]{professionName, levelName}).m_130940_(ChatFormatting.BOLD);
        header.m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tradetweaks_internal highlight " + String.valueOf(villager.m_20148_()) + " 300")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"tradetweaks.tradecast.highlight.tip").m_130940_(ChatFormatting.YELLOW))));
        player.m_5661_((Component)header, false);
        MerchantOffers tempOffers = DeepCopy.deepCopyOffers(offers);
        VillagerTradeReporter.updateSpecialPrices(villager, tempOffers, player);
        for (MerchantOffer offer : tempOffers) {
            ItemStack buying1 = offer.m_45358_();
            ItemStack buying2 = offer.m_45364_();
            ItemStack selling = offer.m_45368_();
            if (selling.m_41720_() == Items.f_42690_ && EnchantmentHelper.m_44831_((ItemStack)selling).containsKey(Enchantments.f_44962_)) {
                hasMending = true;
            }
            MutableComponent message = VillagerTradeReporter.buildTradeMessage(buying1, buying2, selling);
            player.m_5661_((Component)message, false);
        }
        if (!usingWand && hasMending) {
            VillagerUtil.highlightVillagerWithEntity(villager, 600);
        }
    }

    private static MutableComponent buildTradeMessage(ItemStack buying1, ItemStack buying2, ItemStack selling) {
        Component item1 = VillagerTradeReporter.formatItemStack(buying1);
        MutableComponent item2 = buying2.m_41619_() ? Component.m_237119_() : VillagerTradeReporter.formatItemStack(buying2);
        Component result = VillagerTradeReporter.formatItemStack(selling);
        if (buying2.m_41619_()) {
            return Component.m_237110_((String)"tradetweaks.tradecast.trade.format_single", (Object[])new Object[]{item1, buying1.m_41613_(), result, selling.m_41613_()});
        }
        return Component.m_237110_((String)"tradetweaks.tradecast.trade.format", (Object[])new Object[]{item1, buying1.m_41613_(), item2, buying2.m_41613_(), result, selling.m_41613_()});
    }

    private static Component formatItemStack(ItemStack stack) {
        Map enchantments;
        if (stack.m_41720_() == Items.f_42616_) {
            return stack.m_41611_().m_6881_().m_130940_(ChatFormatting.GREEN);
        }
        if (stack.m_41720_() == Items.f_42690_ && !(enchantments = EnchantmentHelper.m_44831_((ItemStack)stack)).isEmpty()) {
            Map.Entry entry = enchantments.entrySet().iterator().next();
            return Component.m_237113_((String)"[").m_7220_((Component)Component.m_237115_((String)((Enchantment)entry.getKey()).m_44704_())).m_130946_(" " + DisplayRoman.toRoman((Integer)entry.getValue())).m_130946_("]").m_130940_(ChatFormatting.YELLOW);
        }
        return stack.m_41611_();
    }

    private static void onVillagerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Villager)) {
            return;
        }
        Villager villager = (Villager)livingEntity;
        UUID villagerId = villager.m_20148_();
        for (PlayerTradeData data : playerTradeDataMap.values()) {
            data.lastKnownOffers.remove(villagerId);
            data.reportedVillagers.remove(villagerId);
        }
    }

    private static PlayerTradeData getPlayerData(UUID playerId) {
        return playerTradeDataMap.computeIfAbsent(playerId, k -> new PlayerTradeData());
    }

    private static void updateSpecialPrices(Villager villager, MerchantOffers tempOffers, Player player) {
        int i = villager.m_35532_(player);
        if (i != 0) {
            for (MerchantOffer merchantoffer : tempOffers) {
                merchantoffer.m_45353_(-Mth.m_14143_((float)((float)i * merchantoffer.m_45378_())));
            }
        }
        if (player.m_21023_(MobEffects.f_19595_)) {
            MobEffectInstance mobeffectinstance = player.m_21124_(MobEffects.f_19595_);
            int k = 0;
            if (mobeffectinstance != null) {
                k = mobeffectinstance.m_19564_();
            }
            for (MerchantOffer merchantoffer1 : tempOffers) {
                double d0 = 0.3 + 0.0625 * (double)k;
                int j = (int)Math.floor(d0 * (double)merchantoffer1.m_45352_().m_41613_());
                merchantoffer1.m_45353_(-Math.max(j, 1));
            }
        }
    }

    public static class PlayerTradeData {
        public final Set<UUID> reportedVillagers = new HashSet<UUID>();
        public final Map<UUID, MerchantOffers> lastKnownOffers = new HashMap<UUID, MerchantOffers>();
    }
}

