/*
 * Decompiled with CFR 0.152.
 */
package net.lostpatrol.tradetweaks.common.wand;

import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.lostpatrol.tradetweaks.common.wand.handler.HandlerTrackBlock;
import net.lostpatrol.tradetweaks.common.wand.handler.HandlerTrackVillager;
import net.lostpatrol.tradetweaks.common.wand.handler.HandlerTradeSelector;
import net.lostpatrol.tradetweaks.common.wand.handler.HandlerUpgradeVillager;
import net.lostpatrol.tradetweaks.common.wand.handler.HandlerVillagerRefresh;
import net.lostpatrol.tradetweaks.common.wand.handler.HandlerVillagerReset;
import net.lostpatrol.tradetweaks.network.NetworkHandler;
import net.lostpatrol.tradetweaks.network.packet.PacketWandModeSwitch;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class EmeraldWand
extends Item {
    private static final String MODE_TAG = "wand_mode";
    private static final String UPGRADE_TAG = "upgrade";
    public static final int COOLDOWN_TICKS = 10;
    private static final Set<WandMode> ENTITY_MODES = Set.of(WandMode.RESET_MODE, WandMode.REFRESH_MODE, WandMode.TRACKING_BLOCK_MODE, WandMode.UPGRADE_MODE, WandMode.SELECT_MODE);
    private static final Set<WandMode> BLOCK_MODES = Set.of(WandMode.TRACKING_VILLAGER_MODE);

    public void switchMode(ItemStack stack, Player player, boolean forward) {
        if (player.m_9236_().f_46443_) {
            NetworkHandler.sendWandModeSwitchToServer(new PacketWandModeSwitch(forward));
        }
        WandMode current = EmeraldWand.getMode(stack);
        WandMode newMode = forward ? current.next() : current.previous();
        player.m_5661_((Component)Component.m_237115_((String)("tradetweaks.emerald_wand.mode." + newMode.getTranslateKey())), true);
    }

    public static WandMode getMode(ItemStack stack) {
        if (!stack.m_41782_() || stack.m_41783_() == null) {
            return WandMode.RESET_MODE;
        }
        if (!stack.m_41783_().m_128441_(MODE_TAG)) {
            return WandMode.RESET_MODE;
        }
        return WandMode.valueOf(stack.m_41783_().m_128461_(MODE_TAG));
    }

    public static void setMode(ItemStack stack, WandMode mode) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_(MODE_TAG, mode.name());
    }

    public static float isUpgradedTexture(ItemStack stack) {
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_(UPGRADE_TAG)) {
            return 0.0f;
        }
        return stack.m_41783_().m_128471_(UPGRADE_TAG) ? 1.0f : 0.0f;
    }

    public static boolean isUpgraded(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128471_(UPGRADE_TAG);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltipComponents, @Nonnull TooltipFlag isAdvanced) {
        if (EmeraldWand.isUpgraded(stack)) {
            tooltipComponents.add((Component)Component.m_237115_((String)"tradetweaks.tooltip.market_ruler").m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.BOLD));
        }
    }

    public EmeraldWand() {
        super(new Item.Properties().m_41487_(1));
    }

    @Nonnull
    public InteractionResult m_6880_(@Nonnull ItemStack stack, @Nonnull Player player, @Nonnull LivingEntity entity, @Nonnull InteractionHand hand) {
        if (player.m_9236_().f_46443_) {
            return InteractionResult.PASS;
        }
        if (player.m_36335_().m_41519_((Item)this)) {
            return InteractionResult.FAIL;
        }
        if (!(entity instanceof Villager)) {
            return InteractionResult.FAIL;
        }
        Villager villager = (Villager)entity;
        WandMode mode = EmeraldWand.getMode(stack);
        if (ENTITY_MODES.contains((Object)mode)) {
            player.m_36335_().m_41524_((Item)this, 10);
            player.m_6674_(InteractionHand.MAIN_HAND);
        }
        return switch (mode) {
            case WandMode.RESET_MODE -> HandlerVillagerReset.handle(player, villager);
            case WandMode.REFRESH_MODE -> HandlerVillagerRefresh.handle(player, villager);
            case WandMode.TRACKING_BLOCK_MODE -> HandlerTrackBlock.handle(player, villager);
            case WandMode.UPGRADE_MODE -> HandlerUpgradeVillager.handle(player, villager);
            case WandMode.SELECT_MODE -> HandlerTradeSelector.handle(stack, player, villager);
            default -> InteractionResult.FAIL;
        };
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        ItemStack stack = context.m_43722_();
        if (world.f_46443_ || player == null) {
            return InteractionResult.PASS;
        }
        WandMode mode = EmeraldWand.getMode(stack);
        if (mode == WandMode.TRACKING_VILLAGER_MODE) {
            player.m_36335_().m_41524_((Item)this, 10);
            player.m_6674_(InteractionHand.MAIN_HAND);
            return HandlerTrackVillager.handle(player, pos, (ServerLevel)world);
        }
        return InteractionResult.PASS;
    }

    public static enum WandMode {
        RESET_MODE("reset"),
        TRACKING_BLOCK_MODE("tracking_block"),
        TRACKING_VILLAGER_MODE("tracking_villager"),
        REFRESH_MODE("refresh"),
        UPGRADE_MODE("upgrade"),
        SELECT_MODE("select");

        private final String name;

        private WandMode(String name) {
            this.name = name;
        }

        public String getTranslateKey() {
            return this.name;
        }

        public WandMode next() {
            WandMode[] values = WandMode.values();
            return values[(this.ordinal() + 1) % values.length];
        }

        public WandMode previous() {
            WandMode[] values = WandMode.values();
            int index = this.ordinal() - 1;
            return index < 0 ? values[values.length - 1] : values[index];
        }
    }
}

