/*
 * Decompiled with CFR 0.152.
 */
package net.lostpatrol.tradetweaks.common.wand.handler;

import java.util.Optional;
import net.lostpatrol.tradetweaks.network.NetworkHandler;
import net.lostpatrol.tradetweaks.network.packet.PacketBlockHighlight;
import net.lostpatrol.tradetweaks.util.VillagerUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;

public class HandlerTrackBlock {
    public static final int DURATION_TICKS = 300;
    public static final float R = 1.0f;
    public static final float G = 0.0f;
    public static final float B = 0.0f;
    public static final Component TRACK_BLOCK_FAIL = Component.m_237115_((String)"tradetweaks.emerald_wand.fail.villager_not_occupied").m_130940_(ChatFormatting.RED);
    public static final Component TRACK_BLOCK_FAIL_ERR = Component.m_237115_((String)"tradetweaks.emerald_wand.fail.block_not_exist").m_130940_(ChatFormatting.RED);

    public static Component TRACK_BLOCK_SUCCESS(BlockPos pos) {
        return Component.m_237110_((String)"tradetweaks.emerald_wand.success.track_block", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"tradetweaks.emerald_wand.text.copy"))));
    }

    public static InteractionResult handle(Player player, Villager villager) {
        if (VillagerUtil.isUnemployed(villager) || VillagerUtil.isNitwit(villager)) {
            player.m_5661_(TRACK_BLOCK_FAIL, true);
            return InteractionResult.SUCCESS;
        }
        Optional jobSite = villager.m_6274_().m_21952_(MemoryModuleType.f_26360_);
        if (jobSite.isPresent()) {
            BlockPos pos = ((GlobalPos)jobSite.get()).m_122646_();
            player.m_213846_(HandlerTrackBlock.TRACK_BLOCK_SUCCESS(pos));
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHandler.sendBlockHighlightToPlayer(serverPlayer, new PacketBlockHighlight(pos, 300, 1.0f, 0.0f, 0.0f));
            }
        } else {
            player.m_5661_(TRACK_BLOCK_FAIL_ERR, true);
        }
        return InteractionResult.SUCCESS;
    }
}

