/*
 * Decompiled with CFR 0.152.
 */
package net.lostpatrol.tradetweaks.common.wand.handler;

import java.util.Optional;
import net.lostpatrol.tradetweaks.util.VillagerUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class HandlerTrackVillager {
    public static final int DURATION_TICKS = 300;
    public static final int TRACK_RADIUS = 64;
    public static final Component TRACK_VILLAGER_FAIL = Component.m_237115_((String)"tradetweaks.emerald_wand.fail.block_not_occupied").m_130940_(ChatFormatting.RED);

    public static Component TRACK_VILLAGER_SUCCESS(Villager v) {
        return Component.m_237110_((String)"tradetweaks.emerald_wand.success.track_villager", (Object[])new Object[]{v.m_146903_(), v.m_146904_(), v.m_146907_()}).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, v.m_146903_() + " " + v.m_146904_() + " " + v.m_146907_())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"tradetweaks.emerald_wand.text.copy"))));
    }

    public static InteractionResult handle(Player player, BlockPos pos, ServerLevel level) {
        Optional<Villager> optionalVillager = level.m_45976_(Villager.class, new AABB(pos).m_82400_(64.0)).stream().filter(villager -> HandlerTrackVillager.isWorkstationForVillager(villager, pos)).findFirst();
        if (optionalVillager.isEmpty()) {
            player.m_5661_(TRACK_VILLAGER_FAIL, true);
            return InteractionResult.SUCCESS;
        }
        Villager villager2 = optionalVillager.get();
        VillagerUtil.highlightVillagerWithEntity(villager2, 300);
        player.m_213846_(HandlerTrackVillager.TRACK_VILLAGER_SUCCESS(villager2));
        return InteractionResult.SUCCESS;
    }

    private static boolean isWorkstationForVillager(Villager villager, BlockPos pos) {
        return villager.m_6274_().m_21952_(MemoryModuleType.f_26360_).map(globalPos -> globalPos.m_122646_().equals((Object)pos)).orElse(false);
    }
}

