/*
 * Decompiled with CFR 0.152.
 */
package net.lostpatrol.tradetweaks.common.wand.handler;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import net.lostpatrol.tradetweaks.config.ServerConfig;
import net.lostpatrol.tradetweaks.util.VillagerUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;

public class HandlerUpgradeVillager {
    public static final Component UPGRADE_FAIL_NOT_OCCUPIED = Component.m_237115_((String)"tradetweaks.emerald_wand.fail.villager_not_occupied").m_130940_(ChatFormatting.RED);
    public static final Component UPGRADE_FAIL_MAX_LEVEL = Component.m_237115_((String)"tradetweaks.emerald_wand.fail.villager_max_level").m_130940_(ChatFormatting.WHITE);
    public static final Component UPGRADE_FAIL_INSUFFICIENT_FUNDS = Component.m_237115_((String)"tradetweaks.emerald_wand.fail.insufficient_funds").m_130940_(ChatFormatting.RED);
    private static List<ItemCost> upgradeCosts = List.of(new ItemCost(Items.f_42110_, 1), new ItemCost(Items.f_42616_, 9));

    public static void reloadCosts() {
        upgradeCosts = ServerConfig.loadCosts();
    }

    public static InteractionResult handle(Player player, Villager villager) {
        if (VillagerUtil.isUnemployed(villager) || VillagerUtil.isNitwit(villager)) {
            player.m_5661_(UPGRADE_FAIL_NOT_OCCUPIED, true);
            return InteractionResult.SUCCESS;
        }
        if (villager.m_7141_().m_35576_() >= 5) {
            player.m_5661_(UPGRADE_FAIL_MAX_LEVEL, true);
            return InteractionResult.SUCCESS;
        }
        if (!player.m_7500_() && !HandlerUpgradeVillager.consumeUpgradeCost(player)) {
            player.m_5661_(UPGRADE_FAIL_INSUFFICIENT_FUNDS, true);
            return InteractionResult.SUCCESS;
        }
        if (villager.f_35374_) {
            villager.f_35374_ = false;
        }
        villager.m_35528_();
        villager.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 0));
        HandlerUpgradeVillager.spawnHappyParticles(villager);
        return InteractionResult.SUCCESS;
    }

    private static boolean consumeUpgradeCost(Player player) {
        AtomicBoolean success = new AtomicBoolean(false);
        player.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            for (ItemCost cost : upgradeCosts) {
                int total = HandlerUpgradeVillager.findTotal(handler, cost.item());
                if (total < cost.amount()) continue;
                HandlerUpgradeVillager.removeExactly(handler, cost.item(), cost.amount());
                success.set(true);
                break;
            }
        });
        return success.get();
    }

    private static int findTotal(IItemHandler handler, Item item) {
        int total = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.m_41720_() != item) continue;
            total += stack.m_41613_();
        }
        return total;
    }

    private static void removeExactly(IItemHandler handler, Item item, int amount) {
        int remaining = amount;
        for (int i = 0; i < handler.getSlots() && remaining > 0; ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.m_41720_() != item) continue;
            int toExtract = Math.min(remaining, stack.m_41613_());
            handler.extractItem(i, toExtract, false);
            remaining -= toExtract;
        }
    }

    private static void spawnHappyParticles(Villager villager) {
        Level level = villager.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        RandomSource random = villager.m_217043_();
        for (int i = 0; i < 5; ++i) {
            double x = villager.m_20208_(1.0);
            double y = villager.m_20187_() + 1.0;
            double z = villager.m_20262_(1.0);
            level2.m_8767_((ParticleOptions)ParticleTypes.f_123748_, x, y, z, 1, random.m_188583_() * 0.02, random.m_188583_() * 0.02, random.m_188583_() * 0.02, 0.5);
        }
    }

    public record ItemCost(Item item, int amount) {
        public ItemCost {
            Objects.requireNonNull(item, "Item cannot be null");
            if (amount <= 0) {
                throw new IllegalArgumentException("Amount must be positive");
            }
        }
    }
}

