/*
 * Decompiled with CFR 0.152.
 */
package net.lostpatrol.tradetweaks.config;

import net.lostpatrol.tradetweaks.TradeTweaks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="tradetweaks", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.EnumValue<ReportMode> REPORT_MODE = BUILDER.comment("Player's local report mode setting").defineEnum("client.reportMode", (Enum)ReportMode.LIBRARIAN_ONLY);
    private static final ForgeConfigSpec.BooleanValue RENDER_ITEMS = BUILDER.comment("Render the item icon in chat bar").define("client.renderItems", true);
    public static final ForgeConfigSpec SPEC = BUILDER.build();
    public static ReportMode tempMode = ReportMode.LIBRARIAN_ONLY;
    public static boolean tempRenderFlag = true;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent event) {
        if (event.getConfig().getSpec() == SPEC) {
            tempMode = ClientConfig.getMode();
            TradeTweaks.LOGGER.debug("Loaded client config: mode={}", (Object)tempMode);
        }
    }

    public static void setMode(ReportMode mode) {
        REPORT_MODE.set((Object)mode);
    }

    public static ReportMode getMode() {
        return (ReportMode)((Object)REPORT_MODE.get());
    }

    public static void setRenderMode(boolean flag) {
        RENDER_ITEMS.set((Object)flag);
    }

    public static boolean getRenderMode() {
        return (Boolean)RENDER_ITEMS.get();
    }

    public static enum ReportMode {
        OFF("off"),
        LIBRARIAN_ONLY("librarian"),
        ALL_VILLAGERS("all");

        private final String key;

        private ReportMode(String key) {
            this.key = key;
        }

        public String getTranslationKey() {
            return "tradecast.mode." + this.key;
        }

        public String toString() {
            return this.key;
        }
    }
}

