/*
 * Decompiled with CFR 0.152.
 */
package net.lostpatrol.tradetweaks.network.handler;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.lostpatrol.tradetweaks.client.render.HighlightRender;
import net.lostpatrol.tradetweaks.network.packet.PacketBlockHighlight;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.NetworkEvent;

public class HandlerBlockHighlight {
    private static final Map<BlockPos, HighlightEntry> HIGHLIGHTED_BLOCKS = new HashMap<BlockPos, HighlightEntry>();

    public static void handle(PacketBlockHighlight packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> HIGHLIGHTED_BLOCKS.put(packet.getPos(), new HighlightEntry(packet.getDurationTicks(), new float[]{packet.getRed(), packet.getGreen(), packet.getBlue()})));
        ctx.get().setPacketHandled(true);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            HIGHLIGHTED_BLOCKS.entrySet().removeIf(entry -> {
                HighlightEntry highlight = (HighlightEntry)entry.getValue();
                highlight.decrement();
                return highlight.shouldRemove();
            });
        }
    }

    @SubscribeEvent
    public static void onRenderWorldLast(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        for (Map.Entry<BlockPos, HighlightEntry> entry : HIGHLIGHTED_BLOCKS.entrySet()) {
            HighlightRender.renderBlockOutline(poseStack, bufferSource, entry.getKey(), entry.getValue());
        }
        bufferSource.m_109911_();
    }

    public static class HighlightEntry {
        private int remainingTicks;
        private final float red;
        private final float green;
        private final float blue;

        public HighlightEntry(int duration, float[] color) {
            this.remainingTicks = duration;
            this.red = color[0];
            this.green = color[1];
            this.blue = color[2];
        }

        public void decrement() {
            --this.remainingTicks;
        }

        public boolean shouldRemove() {
            return this.remainingTicks <= 0;
        }

        public int getRemainingTicks() {
            return this.remainingTicks;
        }

        public float getRed() {
            return this.red;
        }

        public float getGreen() {
            return this.green;
        }

        public float getBlue() {
            return this.blue;
        }
    }
}

