/*
 * Decompiled with CFR 0.152.
 */
package net.lostpatrol.tradetweaks.network.handler;

import java.util.function.Supplier;
import net.lostpatrol.tradetweaks.client.gui.TradeSelectionScreen;
import net.lostpatrol.tradetweaks.common.dummy.DummyVillager;
import net.lostpatrol.tradetweaks.network.packet.PacketOpenTradeSelection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class HandlerOpenTradeSelection {
    public static void handle(PacketOpenTradeSelection packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            if (context.getDirection().getReceptionSide().isClient()) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> HandlerOpenTradeSelection.handleClient(packet));
            }
        });
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(PacketOpenTradeSelection packet) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        mc.m_91152_((Screen)new TradeSelectionScreen(new DummyVillager(packet.getVillagerType(), packet.getProfessionName(), packet.getProfessionLevel(), packet.getOffers(), packet.getVillagerId(), (Level)mc.f_91073_)));
    }
}

