/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.assemblyline.content.belt;

import com.builtbroken.assemblyline.AssemblyLine;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.core.network.packet.PacketTile;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.imp.transform.region.Cube;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import com.builtbroken.mc.prefab.tile.Tile;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileBelt
extends Tile
implements IPacketIDReceiver {
    protected ItemStack stackOnBelt;
    protected int beltPositionStep = 0;
    protected ForgeDirection facingDirection = ForgeDirection.NORTH;
    protected ForgeDirection placementSide;
    protected BeltType beltType = BeltType.NORMAL;

    public TileBelt() {
        this("conveyorBelt");
    }

    public TileBelt(String name) {
        super(name, Material.field_151573_f);
        this.bounds = new Cube(0.0, 0.0, 0.0, 1.0, (double)0.4f, 1.0);
    }

    public void update() {
        super.update();
        this.firstTick();
        if (this.ticks % 5L == 0L && this.stackOnBelt != null) {
            this.updateItemPosition();
        }
    }

    protected void updateItemPosition() {
        ++this.beltPositionStep;
        if (this.beltPositionStep >= this.beltType.maxPositions) {
            this.moveItemToNextBlock();
        }
    }

    protected void moveItemToNextBlock() {
        Pos pos = (Pos)this.toPos().add(this.facingDirection);
        TileEntity tile = pos.getTileEntity((IBlockAccess)this.oldWorld());
        if (tile instanceof TileBelt) {
            if (this.beltType != BeltType.ELEVATED && ((TileBelt)tile).getFacingDirection() != this.getFacingDirection().getOpposite() && ((TileBelt)tile).stackOnBelt == null) {
                ((TileBelt)tile).setItemOnBelt(this.stackOnBelt);
                this.setItemOnBelt(null);
            }
        } else if (pos.isAirBlock(this.oldWorld())) {
            InventoryUtility.dropItemStack((World)this.oldWorld(), (IPos3D)((IPos3D)pos.add(0.5)), (ItemStack)this.stackOnBelt);
            this.setItemOnBelt(null);
        }
    }

    public void setItemOnBelt(ItemStack stack) {
        if (this.stackOnBelt != null && stack == null) {
            this.stackOnBelt = null;
            this.beltPositionStep = 0;
        } else if (this.stackOnBelt == null && stack != null) {
            this.stackOnBelt = stack.func_77946_l();
        }
    }

    public void firstTick() {
        super.firstTick();
        this.placementSide = ForgeDirection.getOrientation((int)this.oldWorld().func_72805_g(this.xi(), this.yi(), this.zi()));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return Blocks.field_150339_S.func_149691_a(0, 0);
    }

    public Tile newTile() {
        return new TileBelt();
    }

    public ForgeDirection getPlacementSide() {
        return this.placementSide;
    }

    public void setPlacementSide(ForgeDirection side) {
        if (this.beltType != BeltType.UP && this.beltType != BeltType.DOWN) {
            if (side != this.placementSide) {
                this.oldWorld().func_72921_c(this.xi(), this.yi(), this.zi(), side.ordinal(), 3);
                this.placementSide = ForgeDirection.getOrientation((int)this.oldWorld().func_72805_g(this.xi(), this.yi(), this.zi()));
            }
        } else {
            AssemblyLine.INSTANCE.logger().error("Something attempted to set a belt to an invalid side, Belt: " + (Object)((Object)this), (Throwable)new RuntimeException());
        }
    }

    public ForgeDirection getFacingDirection() {
        return this.facingDirection;
    }

    public void setFacingDirection(ForgeDirection dir) {
        if (dir != ForgeDirection.UP && dir != ForgeDirection.DOWN) {
            if (dir != this.facingDirection) {
                this.facingDirection = dir;
                if (this.isServer()) {
                    // empty if block
                }
            }
        } else {
            AssemblyLine.INSTANCE.logger().error("Something attempted to set a belt to an invalid dir, Belt: " + (Object)((Object)this), (Throwable)new RuntimeException());
        }
    }

    public boolean read(ByteBuf buf, int id, EntityPlayer player, PacketType type) {
        if (this.isClient() && (id == 1 || id == 0)) {
            byte bt = buf.readByte();
            byte fd = buf.readByte();
            if (bt < 0 || bt < BeltType.values().length) {
                // empty if block
            }
            if (id == 1) {
                this.stackOnBelt = ByteBufUtils.readItemStack((ByteBuf)buf);
            }
        }
        return false;
    }

    public PacketTile getDescPacket() {
        if (this.stackOnBelt == null) {
            return new PacketTile((TileEntity)this, new Object[]{1, (byte)this.beltType.ordinal(), (byte)this.facingDirection.ordinal()});
        }
        return new PacketTile((TileEntity)this, new Object[]{0, (byte)this.beltType.ordinal(), (byte)this.facingDirection.ordinal(), this.stackOnBelt});
    }

    public static enum BeltType {
        NORMAL(16),
        ELEVATED(16),
        UP(27),
        DOWN(27);

        public final int maxPositions;

        private BeltType(int maxPositions) {
            this.maxPositions = maxPositions;
        }
    }
}

