/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.assemblyline.content.inserter;

import com.builtbroken.assemblyline.AssemblyLine;
import com.builtbroken.assemblyline.content.parts.ALParts;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.api.automation.IAutomatedCrafter;
import com.builtbroken.mc.api.automation.IAutomation;
import com.builtbroken.mc.api.tile.multiblock.IMultiTile;
import com.builtbroken.mc.api.tile.multiblock.IMultiTileHost;
import com.builtbroken.mc.api.tile.provider.IInventoryProvider;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.core.registry.implement.IRecipeContainer;
import com.builtbroken.mc.framework.multiblock.EnumMultiblock;
import com.builtbroken.mc.framework.multiblock.MultiBlockHelper;
import com.builtbroken.mc.imp.transform.region.Cube;
import com.builtbroken.mc.imp.transform.rotation.EulerAngle;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import com.builtbroken.mc.prefab.tile.Tile;
import com.builtbroken.mc.prefab.tile.TileModuleMachine;
import com.builtbroken.mc.prefab.tile.module.TileModuleInventory;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileInsertArm
extends TileModuleMachine
implements IAutomation,
IMultiTileHost,
IPacketIDReceiver,
IRecipeContainer {
    public static final int MAX_SPEED_UPGRADES = 18;
    public static final float DEFAULT_SPEED = 1.0f;
    public static final HashMap<IPos3D, String> tileMapCache = new HashMap();
    protected EulerAngle rotation = new EulerAngle(0.0, 0.0);
    protected int insertAmount = 1;
    private boolean _destroyingStructure = false;
    protected static final Cube blockBounds;

    public TileInsertArm() {
        super("tileInsertArm", Material.field_151573_f);
        this.hardness = 1.0f;
        this.resistance = 1.0f;
        this.renderTileEntity = true;
    }

    protected IInventory createInventory() {
        return new TileModuleInventory((IInventoryProvider)this, 2);
    }

    public void genRecipes(List<IRecipe> recipes) {
        recipes.add(this.newShapedRecipe(AssemblyLine.blockInserter, new Object[]{"HW", "AW", "CW", Character.valueOf('H'), ALParts.ROBOTIC_HAND.toStack(), Character.valueOf('A'), ALParts.ROBOTIC_ARM_ASSEMBLY.toStack(), Character.valueOf('C'), ALParts.ROBOTIC_BASE.toStack(), Character.valueOf('W'), "wireCopper"}));
    }

    public Tile newTile() {
        return new TileInsertArm();
    }

    public void firstTick() {
        super.firstTick();
        MultiBlockHelper.buildMultiBlock((World)this.oldWorld(), (IMultiTileHost)this, (boolean)true);
        this.facing = ForgeDirection.getOrientation((int)this.getMetadata());
        this.markRender();
    }

    public void update() {
        super.update();
        if (this.isServer()) {
            if (this.hasPower()) {
                boolean hasItem;
                boolean facingInput = this.isFacingInput();
                boolean facingOutput = this.isFacingOutput();
                boolean bl = hasItem = this.getHeldItem() != null;
                if (facingInput && !hasItem) {
                    this.takeItem();
                } else if (facingOutput && hasItem) {
                    this.insertItem();
                } else {
                    this.updateRotation();
                }
            } else {
                this.dropItem();
            }
        }
    }

    protected boolean onPlayerRightClickWrench(EntityPlayer player, int side, Pos hit) {
        if (this.isServer()) {
            if (this.getDirection() == ForgeDirection.NORTH) {
                this.setFacing(ForgeDirection.EAST);
            } else if (this.getDirection() == ForgeDirection.EAST) {
                this.setFacing(ForgeDirection.SOUTH);
            } else if (this.getDirection() == ForgeDirection.SOUTH) {
                this.setFacing(ForgeDirection.WEST);
            } else {
                this.setFacing(ForgeDirection.NORTH);
            }
            if (this.isServer()) {
                player.func_146105_b((IChatComponent)new ChatComponentText("Rotation set to " + this.getDirection().toString().toLowerCase()));
            }
            this.sendDescPacket();
        }
        return true;
    }

    protected boolean onPlayerRightClick(EntityPlayer player, int side, Pos hit) {
        if (player.func_70694_bm() != null) {
            if (Engine.runningAsDev && player.func_70694_bm().func_77973_b() == Items.field_151055_y) {
                if (this.isServer()) {
                    player.func_146105_b((IChatComponent)new ChatComponentText("Output: " + this.getDirection() + " R: " + this.rotation));
                }
                return true;
            }
            if (player.func_70694_bm().func_77973_b() == Items.field_151137_ax) {
                if (this.isServer()) {
                    ItemStack stack = this.func_70301_a(1);
                    if (stack == null) {
                        stack = new ItemStack(Items.field_151137_ax);
                        this.func_70299_a(1, stack);
                        player.func_146105_b((IChatComponent)new ChatComponentText("Upgrades: " + this.getSpeedUpdates()));
                        player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                        player.field_71069_bz.func_75142_b();
                    } else if (stack.field_77994_a < 18) {
                        ++stack.field_77994_a;
                        this.func_70299_a(1, stack);
                        player.func_146105_b((IChatComponent)new ChatComponentText("Upgrades: " + this.getSpeedUpdates()));
                        player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                        player.field_71069_bz.func_75142_b();
                    } else {
                        player.func_146105_b((IChatComponent)new ChatComponentText("Max updates of 18 has been reached"));
                    }
                }
                return true;
            }
        }
        return false;
    }

    protected void updateRotation() {
        int desiredRotation = this.getRotation(this.getHeldItem() == null ? this.getDirection().getOpposite() : this.getDirection());
        this.rotation.moveYaw((double)desiredRotation, (double)(1.0f + 1.0f * (float)this.getSpeedUpdates()), 1.0);
        this.rotation.clampTo360();
        this.sendDescPacket();
    }

    protected void takeItem() {
        if (this.getHeldItem() == null) {
            TileEntity input = this.findInput();
            if (input instanceof IAutomatedCrafter) {
                int[] slots = ((IAutomatedCrafter)input).getCraftingOutputSlots((IAutomation)this, this.getDirection());
                for (int index = 0; index < slots.length; ++index) {
                    ItemStack stack = ((IAutomatedCrafter)input).getInventory().func_70301_a(slots[index]);
                    if (stack == null || !((IAutomatedCrafter)input).canRemove(stack, slots[index], this.getDirection())) continue;
                    ItemStack take = stack.func_77946_l();
                    take.field_77994_a = 1;
                    this.setHeldItem(take);
                    --stack.field_77994_a;
                    if (stack.field_77994_a <= 0) {
                        ((IAutomatedCrafter)input).getInventory().func_70299_a(slots[index], null);
                        continue;
                    }
                    ((IAutomatedCrafter)input).getInventory().func_70299_a(slots[index], stack);
                }
            } else if (input instanceof IInventory) {
                this.setHeldItem(InventoryUtility.pullStack((TileEntity)input, (int)this.getDirection().ordinal(), (int)this.insertAmount));
            }
        }
    }

    protected void insertItem() {
        if (this.getHeldItem() != null) {
            TileEntity output = this.findOutput();
            if (output instanceof IAutomatedCrafter) {
                int[] slots = ((IAutomatedCrafter)output).getCraftingInputSlots((IAutomation)this, this.getDirection().getOpposite());
                ItemStack heldItem = this.getHeldItem();
                ForgeDirection side = this.getDirection();
                for (int index = 0; index < slots.length; ++index) {
                    int slot = slots[index];
                    if (!((IAutomatedCrafter)output).canStore(heldItem, slot, side)) continue;
                    if ((heldItem = ((IAutomatedCrafter)output).insertRequiredItem(heldItem, slot, (IAutomation)this, side)) == null || heldItem.field_77994_a <= 0) {
                        this.setHeldItem(null);
                        break;
                    }
                    this.setHeldItem(heldItem);
                }
            } else if (output instanceof IInventory) {
                this.setHeldItem(InventoryUtility.insertStack((TileEntity)output, (ItemStack)this.getHeldItem(), (int)this.getDirection().getOpposite().ordinal(), (boolean)false));
            }
        }
    }

    protected void dropItem() {
        Location location = (Location)this.toLocation().add((IPos3D)this.rotation.toPos());
        InventoryUtility.dropItemStack((IWorldPosition)location, (ItemStack)this.getHeldItem());
        this.setHeldItem(null);
    }

    protected boolean hasPower() {
        return true;
    }

    protected boolean isFacingInput() {
        return this.isFacing(this.getDirection().getOpposite());
    }

    protected boolean isFacingOutput() {
        return this.isFacing(this.getDirection());
    }

    protected boolean isFacing(ForgeDirection dir) {
        return this.rotation.isYawWithin((double)this.getRotation(dir), 3.0);
    }

    protected int getRotation(ForgeDirection dir) {
        switch (dir) {
            case SOUTH: {
                return 180;
            }
            case EAST: {
                return -90;
            }
            case WEST: {
                return 90;
            }
        }
        return 0;
    }

    protected ItemStack getHeldItem() {
        return this.func_70301_a(0);
    }

    protected void setHeldItem(ItemStack stack) {
        this.func_70299_a(0, stack);
    }

    protected int getSpeedUpdates() {
        ItemStack stack = this.func_70301_a(1);
        return stack != null ? stack.field_77994_a : 0;
    }

    protected TileEntity findInput() {
        TileEntity tile = ((Location)this.toLocation().add(this.getDirection().getOpposite())).getTileEntity();
        if (tile instanceof IMultiTile) {
            return (TileEntity)((IMultiTile)tile).getHost();
        }
        return tile;
    }

    protected TileEntity findOutput() {
        TileEntity tile = ((Location)this.toLocation().add(this.getDirection())).getTileEntity();
        if (tile instanceof IMultiTile) {
            return (TileEntity)((IMultiTile)tile).getHost();
        }
        return tile;
    }

    public void writeDescPacket(ByteBuf buf) {
        super.writeDescPacket(buf);
        this.rotation.writeBytes(buf);
        buf.writeBoolean(this.getHeldItem() != null);
        if (this.getHeldItem() != null) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.getHeldItem());
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.rotation.readFromNBT(nbt.func_74775_l("rotation"));
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74782_a("rotation", (NBTBase)this.rotation.writeNBT(new NBTTagCompound()));
    }

    public void onInventoryChanged(int slot, ItemStack prev, ItemStack item) {
        if (this.oldWorld() != null) {
            this.sendDescPacket();
        }
    }

    public void onMultiTileAdded(IMultiTile tileMulti) {
        if (tileMulti instanceof TileEntity && tileMapCache.containsKey(new Pos((TileEntity)this).sub((IPos3D)new Pos((TileEntity)tileMulti)))) {
            tileMulti.setHost((IMultiTileHost)this);
        }
    }

    public boolean onMultiTileBroken(IMultiTile tileMulti, Object source, boolean harvest) {
        Pos pos;
        if (!this._destroyingStructure && tileMulti instanceof TileEntity && tileMapCache.containsKey(pos = (Pos)new Pos((TileEntity)tileMulti).sub((IPos3D)new Pos((TileEntity)this)))) {
            MultiBlockHelper.destroyMultiBlockStructure((IMultiTileHost)this, (boolean)harvest, (boolean)false, (boolean)true);
            return true;
        }
        return false;
    }

    public boolean canPlaceBlockOnSide(ForgeDirection side) {
        return side == ForgeDirection.UP;
    }

    public boolean removeByPlayer(EntityPlayer player, boolean willHarvest) {
        MultiBlockHelper.destroyMultiBlockStructure((IMultiTileHost)this, (boolean)false, (boolean)false, (boolean)false);
        if (willHarvest && this.getHeldItem() != null) {
            InventoryUtility.dropItemStack((IWorldPosition)this.toLocation(), (ItemStack)this.getHeldItem());
            this.func_70299_a(0, null);
        }
        return super.removeByPlayer(player, willHarvest);
    }

    public void onTileInvalidate(IMultiTile tileMulti) {
    }

    public boolean onMultiTileActivated(IMultiTile tile, EntityPlayer player, int side, float xHit, float yHit, float zHit) {
        return this.onPlayerRightClick(player, side, new Pos((double)xHit, (double)yHit, (double)zHit));
    }

    public void onMultiTileClicked(IMultiTile tile, EntityPlayer player) {
    }

    public HashMap<IPos3D, String> getLayoutOfMultiBlock() {
        HashMap<IPos3D, String> map = new HashMap<IPos3D, String>();
        Pos center = new Pos((TileEntity)this);
        for (Map.Entry<IPos3D, String> entry : tileMapCache.entrySet()) {
            map.put((IPos3D)center.add(entry.getKey()), entry.getValue());
        }
        return map;
    }

    public Cube getBlockBounds() {
        return blockBounds;
    }

    public Cube getSelectBounds() {
        return blockBounds;
    }

    public boolean useMetaForFacing() {
        return true;
    }

    static {
        tileMapCache.put((IPos3D)new Pos(0.0, 1.0, 0.0), EnumMultiblock.TILE.getTileName());
        blockBounds = new Cube(0.0, 0.0, 0.0, 1.0, 0.3, 1.0);
    }
}

