/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.assemblyline.content.rail.carts;

import com.builtbroken.assemblyline.AssemblyLine;
import com.builtbroken.assemblyline.content.rail.carts.CartTypes;
import com.builtbroken.assemblyline.content.rail.carts.Gui.ContainerChestCart;
import com.builtbroken.assemblyline.content.rail.carts.Gui.GuiChestCart;
import com.builtbroken.mc.api.IInventoryFilter;
import com.builtbroken.mc.api.rails.ITransportCartHasCargo;
import com.builtbroken.mc.api.tile.access.IGuiTile;
import com.builtbroken.mc.api.tile.provider.IInventoryProvider;
import com.builtbroken.mc.prefab.entity.cart.EntityAbstractCart;
import com.builtbroken.mc.prefab.inventory.ExternalInventory;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityCart
extends EntityAbstractCart
implements ITransportCartHasCargo,
IGuiTile {
    private CartTypes _cartType = CartTypes.EMPTY;
    protected ExternalInventory inventory;
    protected IInventoryFilter filter;

    public EntityCart(World world) {
        super(world);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if ((double)Math.abs(this.getType().length - this.length - this.getType().width - this.field_70130_N) > 0.1) {
            this.length = this.getType().length;
            this.field_70130_N = this.getType().width;
            this.markBoundsInvalid();
        }
    }

    public void onInventoryChanged(int slot, ItemStack prev, ItemStack item) {
        if (this.getType() == CartTypes.STACK || this.getType() == CartTypes.JABBA_BARREL || this.getType() == CartTypes.CRATE) {
            // empty if block
        }
    }

    public ExternalInventory getInventory() {
        if (this.inventory == null) {
            this.inventory = new ExternalInventory((IInventoryProvider)this, this.getType().inventorySize);
        }
        return this.inventory;
    }

    public ItemStack toStack() {
        return new ItemStack(AssemblyLine.itemCart, 1, this.getType().ordinal());
    }

    public void setType(CartTypes cartType) {
        this._cartType = cartType;
        this.field_70130_N = this.getType().width;
        this.length = this.getType().length;
        this.markBoundsInvalid();
        this.markForClientSync();
    }

    public CartTypes getType() {
        return this._cartType;
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setType(CartTypes.values()[nbt.func_74762_e("cartType")]);
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("cartType", this.getType().ordinal());
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.getType().ordinal());
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.setType(CartTypes.values()[additionalData.readInt()]);
    }

    public IInventoryFilter getInventoryFilter() {
        return null;
    }

    public boolean canStore(ItemStack stack, ForgeDirection side) {
        return true;
    }

    public boolean func_130002_c(EntityPlayer player) {
        if (this.getInventory() != null) {
            if (!this.oldWorld().field_72995_K) {
                player.openGui((Object)AssemblyLine.INSTANCE, 10001, this.oldWorld(), this.func_145782_y(), 0, 0);
            }
            return true;
        }
        return false;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player) {
        if (this.getType() == CartTypes.CHEST) {
            return new ContainerChestCart(player, (IInventory)this.getInventory());
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player) {
        if (this.getType() == CartTypes.CHEST) {
            return new GuiChestCart(player, (IInventory)this.getInventory());
        }
        return null;
    }
}

