/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.assemblyline.content.rail.carts;

import com.builtbroken.assemblyline.content.rail.carts.CartTypes;
import com.builtbroken.assemblyline.content.rail.carts.EntityCart;
import com.builtbroken.mc.api.rails.ITransportRail;
import com.builtbroken.mc.api.rails.ITransportRailBlock;
import com.builtbroken.mc.core.content.parts.CraftingParts;
import com.builtbroken.mc.core.registry.implement.IRecipeContainer;
import com.builtbroken.mc.core.registry.implement.IRegistryInit;
import com.builtbroken.mc.lib.helper.recipe.UniversalRecipe;
import com.builtbroken.mc.prefab.entity.cart.EntityAbstractCart;
import com.builtbroken.mc.prefab.items.ItemAbstract;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class ItemCart
extends ItemAbstract
implements IRecipeContainer,
IRegistryInit {
    public ItemCart() {
        this.func_77625_d(5);
        this.func_77655_b("assemblyline:transportRailCart");
        this.func_111206_d("assemblyline:transportRailCart");
        this.func_77627_a(true);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && ItemCart.placeCart(world, x, y, z, stack.func_77960_j()) != null) {
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xf, float yf, float zf) {
        return world.func_147439_a(x, y, z) instanceof ITransportRailBlock || world.func_147438_o(x, y, z) instanceof ITransportRail;
    }

    public static EntityAbstractCart placeCart(World world, int x, int y, int z, int type) {
        Block block = world.func_147439_a(x, y, z);
        TileEntity tile = world.func_147438_o(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (block instanceof ITransportRailBlock) {
            EntityCart cart = ItemCart.getCart(world, type);
            cart.func_70107_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
            ItemCart.mountEntity(cart, ((ITransportRailBlock)block).getAttachedDirection(world, x, y, z, meta), ((ITransportRailBlock)block).getFacingDirection(world, x, y, z, meta), ((ITransportRailBlock)block).getRailHeight(world, x, y, z, meta));
            return cart;
        }
        if (tile instanceof ITransportRail) {
            EntityCart cart = ItemCart.getCart(world, type);
            cart.func_70107_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
            ItemCart.mountEntity(cart, ((ITransportRail)tile).getAttachedDirection(), ((ITransportRail)tile).getFacingDirection(), ((ITransportRail)tile).getRailHeight());
            return cart;
        }
        return null;
    }

    public static void mountEntity(EntityAbstractCart cart, ForgeDirection side, ForgeDirection facing, double railHeight) {
        cart.railSide = side;
        cart.recenterCartOnRail(side, facing, railHeight, true);
        cart.field_70170_p.func_72838_d((Entity)cart);
    }

    public static EntityCart getCart(World world, int meta) {
        CartTypes type = CartTypes.values()[meta];
        EntityCart cart = new EntityCart(world);
        cart.setType(type);
        return cart;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List items) {
        for (int i = 0; i < CartTypes.values().length; ++i) {
            items.add(new ItemStack(item, 1, i));
        }
    }

    public void genRecipes(List<IRecipe> recipes) {
        recipes.add(this.newShapedRecipe(new ItemStack((Item)this, 1, CartTypes.EMPTY.ordinal()), new Object[]{"COC", "RTR", "GSG", Character.valueOf('S'), "rodSteel", Character.valueOf('G'), "gearSteel", Character.valueOf('C'), UniversalRecipe.CIRCUIT_T1.get(), Character.valueOf('O'), UniversalRecipe.CIRCUIT_T2.get(), Character.valueOf('R'), CraftingParts.DC_MOTOR.oreName, Character.valueOf('T'), "plateSteel"}));
        recipes.add(this.newShapelessRecipe(new ItemStack((Item)this, 1, CartTypes.CHEST.ordinal()), new Object[]{Blocks.field_150486_ae, new ItemStack((Item)this, 1, CartTypes.EMPTY.ordinal())}));
        recipes.add(this.newShapelessRecipe(new ItemStack((Item)this, 1, CartTypes.STACK.ordinal()), new Object[]{Blocks.field_150452_aw, new ItemStack((Item)this, 1, CartTypes.EMPTY.ordinal())}));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        CartTypes type = CartTypes.get(meta);
        if (type.icon != null) {
            return type.icon;
        }
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        this.field_77791_bV = reg.func_94245_a(this.func_111208_A());
        for (CartTypes type : CartTypes.values()) {
            if (type.subName == null) continue;
            type.icon = reg.func_94245_a(this.func_111208_A() + "." + type.subName);
        }
    }

    public String func_77667_c(ItemStack stack) {
        CartTypes type = CartTypes.get(stack.func_77960_j());
        if (type.subName != null) {
            return super.func_77658_a() + "." + type.subName;
        }
        return super.func_77658_a();
    }

    public void onRegistered() {
        OreDictionary.registerOre((String)"alTransportCart", (ItemStack)new ItemStack((Item)this, 1, 0));
    }

    public void onClientRegistered() {
    }
}

