/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.assemblyline.content.rail.carts;

import com.builtbroken.assemblyline.AssemblyLine;
import com.builtbroken.assemblyline.content.rail.carts.CartTypes;
import com.builtbroken.assemblyline.content.rail.carts.EntityCart;
import com.builtbroken.jlib.helpers.MathHelper;
import com.builtbroken.mc.client.SharedAssets;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.lib.Holiday;
import com.builtbroken.mc.lib.helper.MathUtility;
import com.builtbroken.mc.lib.render.RenderItemOverlayUtility;
import com.builtbroken.mc.lib.render.RenderUtility;
import com.builtbroken.mc.prefab.entity.cart.EntityAbstractCart;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class RenderCart
extends Render {
    private static final ResourceLocation trappedChestTexture = new ResourceLocation("textures/entity/chest/trapped.png");
    private static final ResourceLocation xmasChestTexture = new ResourceLocation("textures/entity/chest/christmas.png");
    private static final ResourceLocation chestTexture = new ResourceLocation("textures/entity/chest/normal.png");
    private ModelChest chestModel;

    public RenderCart() {
        this.field_76989_e = 0.0f;
        this.chestModel = new ModelChest();
    }

    protected ResourceLocation func_110775_a(Entity p_110775_1_) {
        return SharedAssets.GREY_TEXTURE;
    }

    public void func_76986_a(Entity entity, double xx, double yy, double zz, float p_76986_8_, float delta) {
        EntityCart cart = (EntityCart)entity;
        float f5 = cart.field_70127_C + (cart.field_70125_A - cart.field_70127_C) * delta;
        double x2 = MathHelper.lerp((double)cart.lastRenderX, (double)xx, (double)delta);
        double y2 = MathHelper.lerp((double)cart.lastRenderY, (double)yy, (double)delta);
        double z2 = MathHelper.lerp((double)cart.lastRenderZ, (double)zz, (double)delta);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x2, (double)y2, (double)z2);
        GL11.glRotatef((float)(180.0f - delta), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-f5), (float)0.0f, (float)0.0f, (float)1.0f);
        cart.lastRenderX = x2;
        cart.lastRenderY = y2;
        cart.lastRenderZ = z2;
        float halfWidth = cart.field_70130_N / 2.0f;
        float halfLength = cart.length / 2.0f;
        float yaw = (float)Math.abs(MathUtility.clampAngleTo180((double)cart.field_70177_z));
        if (yaw >= 45.0f && yaw <= 135.0f) {
            halfWidth = cart.length / 2.0f;
            halfLength = cart.field_70130_N / 2.0f;
        }
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)(-((double)halfWidth)), (double)0.0, (double)(-((double)halfLength)), (double)halfWidth, (double)0.2, (double)halfLength);
        GL11.glPushMatrix();
        RenderUtility.renderCube((AxisAlignedBB)bounds, (Block)Blocks.field_150339_S);
        GL11.glPopMatrix();
        if (cart.getType() != CartTypes.EMPTY) {
            GL11.glPushMatrix();
            if (cart.getType() == CartTypes.CHEST) {
                if (Holiday.isXMAS()) {
                    this.func_110776_a(xmasChestTexture);
                } else {
                    this.func_110776_a(chestTexture);
                }
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glScalef((float)0.6f, (float)0.6f, (float)0.6f);
                GL11.glTranslated((double)-0.5, (double)-1.2, (double)-0.5);
                this.chestModel.func_78231_a();
            } else if (cart.getType() == CartTypes.STACK) {
                ItemStack stack = cart.getInventory().func_70301_a(0);
                try {
                    if (stack != null) {
                        IItemRenderer renderer = MinecraftForgeClient.getItemRenderer((ItemStack)stack, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.ENTITY);
                        if (renderer != null) {
                            EntityItem fakeItem = new EntityItem(cart.oldWorld());
                            fakeItem.func_70107_b(cart.x(), cart.y() + 0.5, cart.z());
                            renderer.renderItem(IItemRenderer.ItemRenderType.ENTITY, stack, new Object[]{RenderBlocks.getInstance(), fakeItem});
                        } else if (stack.func_77973_b() instanceof ItemBlock) {
                            RenderUtility.renderCube((AxisAlignedBB)AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.8, (double)0.8, (double)0.8), (Block)Blocks.field_150344_f);
                        } else {
                            RenderItemOverlayUtility.renderIcon3D((IIcon)stack.func_77973_b().func_77617_a(stack.func_77960_j()), (int)1);
                        }
                    }
                }
                catch (Exception e) {
                    AssemblyLine.INSTANCE.logger().error("Failed to render " + stack, (Throwable)e);
                    RenderUtility.renderCube((AxisAlignedBB)AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.2, (double)0.1, (double)0.2), (Block)Blocks.field_150325_L);
                }
                RenderUtility.renderCube((AxisAlignedBB)AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.9, (double)0.1, (double)0.9), (Block)Blocks.field_150344_f);
            } else {
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                GL11.glTranslated((double)-0.5, (double)0.3, (double)-0.5);
                RenderUtility.renderCube((AxisAlignedBB)AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (Block)Blocks.field_150344_f);
            }
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        if (Engine.runningAsDev) {
            this.drawBounds(cart, xx, yy, zz);
        }
    }

    protected void drawBounds(EntityAbstractCart cart, double xx, double yy, double zz) {
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3042);
        float halfWidth = cart.field_70130_N / 2.0f;
        float halfLength = cart.length / 2.0f;
        float yaw = (float)Math.abs(MathUtility.clampAngleTo180((double)cart.field_70177_z));
        if (yaw >= 45.0f && yaw <= 135.0f) {
            halfWidth = cart.length / 2.0f;
            halfLength = cart.field_70130_N / 2.0f;
        }
        AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)(xx - (double)halfWidth), (double)yy, (double)(zz - (double)halfLength), (double)(xx + (double)halfWidth), (double)(yy + (double)cart.field_70131_O), (double)(zz + (double)halfLength));
        RenderGlobal.func_147590_a((AxisAlignedBB)axisalignedbb, (int)0xFFFFFF);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
    }
}

