/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.assemblyline.content.rail.powered;

import com.builtbroken.assemblyline.AssemblyLine;
import com.builtbroken.assemblyline.content.parts.ALParts;
import com.builtbroken.assemblyline.content.rail.powered.ItemBlockPowerRail;
import com.builtbroken.assemblyline.content.rail.powered.PoweredRails;
import com.builtbroken.jlib.type.Pair;
import com.builtbroken.mc.api.IInventoryFilter;
import com.builtbroken.mc.api.rails.IRailInventoryTile;
import com.builtbroken.mc.api.rails.ITransportCart;
import com.builtbroken.mc.api.rails.ITransportCartCargo;
import com.builtbroken.mc.api.rails.ITransportCartHasCargo;
import com.builtbroken.mc.api.rails.ITransportCartHasItem;
import com.builtbroken.mc.api.rails.ITransportRail;
import com.builtbroken.mc.api.tile.node.IExternalInventory;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.content.parts.CraftingParts;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.core.registry.implement.IRecipeContainer;
import com.builtbroken.mc.imp.transform.region.Cube;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.helper.recipe.UniversalRecipe;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import com.builtbroken.mc.prefab.tile.Tile;
import com.builtbroken.mc.prefab.tile.TileModuleMachineBase;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;

public class TilePowerRail
extends TileModuleMachineBase
implements ITransportRail,
IPacketIDReceiver,
IRecipeContainer {
    protected PoweredRails railType = PoweredRails.POWERED;
    protected int rotateYaw = 90;
    protected boolean rotateToAngle = true;
    protected boolean rotateClockwise = true;
    protected boolean stopCarts = true;
    protected boolean useRedstoneToInvertStop = true;
    protected ForgeDirection loadDirection;
    protected boolean triggerStopRails = true;
    protected boolean doRedstoneOnLoad = true;
    private ForgeDirection attachedSide;
    private ForgeDirection facingDirection = ForgeDirection.NORTH;
    private static final Cube COLLISION_BOX_DOWN = new Cube(0.0, 0.6, 0.0, 1.0, 1.0, 1.0);
    private static final Cube COLLISION_BOX_NORTH = new Cube(0.0, 0.0, 0.6, 1.0, 1.0, 1.0);
    private static final Cube COLLISION_BOX_SOUTH = new Cube(0.0, 0.0, 0.0, 1.0, 1.0, 0.4);
    private static final Cube COLLISION_BOX_EAST = new Cube(0.0, 0.0, 0.0, 0.4, 1.0, 1.0);
    private static final Cube COLLISION_BOX_WEST = new Cube(0.6, 0.0, 0.0, 1.0, 1.0, 1.0);

    public TilePowerRail() {
        super("cartPowerRail", Material.field_151573_f);
        this.bounds = new Cube(0.0, 0.0, 0.0, 1.0, 0.4, 1.0);
        this.itemBlock = ItemBlockPowerRail.class;
    }

    public void genRecipes(List<IRecipe> recipes) {
        recipes.add(this.newShapedRecipe(new ItemStack(AssemblyLine.blockPowerRail, 1, PoweredRails.POWERED.ordinal()), new Object[]{"RPR", "MLM", "PCP", Character.valueOf('R'), "rodIron", Character.valueOf('M'), CraftingParts.MOTOR.toStack(), Character.valueOf('C'), UniversalRecipe.CIRCUIT_T1.get(), Character.valueOf('L'), AssemblyLine.blockRail, Character.valueOf('P'), "plateIron"}));
        recipes.add(this.newShapedRecipe(new ItemStack(AssemblyLine.blockPowerRail, 1, PoweredRails.ROTATION.ordinal()), new Object[]{"RPR", "RMR", "WLW", Character.valueOf('R'), "rodIron", Character.valueOf('M'), CraftingParts.STEPPER_MOTOR.toStack(), Character.valueOf('L'), new ItemStack(AssemblyLine.blockPowerRail, 1, PoweredRails.POWERED.ordinal()), Character.valueOf('P'), "plateIron", Character.valueOf('W'), "wireCopper"}));
        recipes.add(this.newShapedRecipe(new ItemStack(AssemblyLine.blockPowerRail, 1, PoweredRails.STOP.ordinal()), new Object[]{"RPR", "QCQ", "WLW", Character.valueOf('R'), ALParts.ROBOTIC_HAND.toStack(), Character.valueOf('L'), new ItemStack(AssemblyLine.blockPowerRail, 1, PoweredRails.POWERED.ordinal()), Character.valueOf('Q'), "gemQuartz", Character.valueOf('C'), UniversalRecipe.CIRCUIT_T1.get(), Character.valueOf('P'), Blocks.field_150456_au, Character.valueOf('W'), "dustRedstone"}));
        recipes.add(this.newShapedRecipe(new ItemStack(AssemblyLine.blockPowerRail, 1, PoweredRails.LOADER.ordinal()), new Object[]{"RPR", "TCT", "WLW", Character.valueOf('R'), AssemblyLine.blockInserter, Character.valueOf('L'), new ItemStack(AssemblyLine.blockPowerRail, 1, PoweredRails.STOP.ordinal()), Character.valueOf('T'), UniversalRecipe.CIRCUIT_T2.get(), Character.valueOf('C'), UniversalRecipe.CIRCUIT_T3.get(), Character.valueOf('P'), "plateIron", Character.valueOf('W'), "dustRedstone"}));
        recipes.add(this.newShapelessRecipe(new ItemStack(AssemblyLine.blockPowerRail, 1, PoweredRails.UNLOADER.ordinal()), new Object[]{new ItemStack(AssemblyLine.blockPowerRail, 1, PoweredRails.LOADER.ordinal())}));
        recipes.add(this.newShapelessRecipe(new ItemStack(AssemblyLine.blockPowerRail, 1, PoweredRails.LOADER.ordinal()), new Object[]{new ItemStack(AssemblyLine.blockPowerRail, 1, PoweredRails.UNLOADER.ordinal())}));
    }

    public Tile newTile() {
        return new TilePowerRail();
    }

    public boolean canUpdate() {
        return false;
    }

    public void onNeighborChanged(Block block) {
        super.onNeighborChanged(block);
        if (this.useRedstoneToInvertStop) {
            boolean prevRed = this.stopCarts;
            boolean bl = this.stopCarts = !this.isIndirectlyPowered();
            if (prevRed != this.stopCarts) {
                this.sendDescPacket();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void tickRailFromCart(ITransportCart cart) {
        IExternalInventory inventory;
        if (this.isRotationRail()) {
            if (this.rotateToAngle) {
                cart.setCartRotation((float)this.rotateYaw, 0.0f);
            } else if (this.rotateClockwise) {
                cart.setCartRotation((float)(this.rotateYaw + this.rotateYaw), 0.0f);
            } else {
                cart.setCartRotation((float)(this.rotateYaw - this.rotateYaw), 0.0f);
            }
            this.handlePush(cart);
            return;
        }
        if (this.isPoweredRail()) {
            this.handlePush(cart);
            return;
        }
        if (this.isOrientationRail()) {
            return;
        }
        if (this.isStopRail()) {
            if (this.ticks % 5L != 0L) return;
            Pos delta = (Pos)((Pos)new Pos((TileEntity)this).add(0.5)).sub(cart.x(), cart.y(), cart.z());
            boolean stop = true;
            switch (this.getFacingDirection()) {
                case DOWN: {
                    stop = delta.y() > -0.05;
                    break;
                }
                case UP: {
                    stop = delta.y() < 0.05;
                    break;
                }
                case NORTH: {
                    stop = delta.z() > -0.05;
                    break;
                }
                case SOUTH: {
                    stop = delta.z() < 0.05;
                    break;
                }
                case EAST: {
                    stop = delta.x() < 0.05;
                    break;
                }
                case WEST: {
                    stop = delta.x() > -0.05;
                    break;
                }
            }
            if (this.stopCarts) {
                if (!stop) return;
                cart.setCartMotion(0.0, 0.0, 0.0);
                cart.recenterCartOnRail((ITransportRail)this, true);
                return;
            }
            this.handlePush(cart);
            cart.recenterCartOnRail((ITransportRail)this, false);
            return;
        }
        if (this.isLoaderRail()) {
            if (cart instanceof ITransportCartHasCargo) {
                IExternalInventory inventory2 = ((ITransportCartHasCargo)cart).getInventory();
                if (inventory2 != null && !inventory2.isFull()) {
                    cart.setCartMotion(0.0, 0.0, 0.0);
                    cart.recenterCartOnRail((ITransportRail)this, true);
                    if (this.field_145850_b.field_72995_K) return;
                    Pair<ItemStack, Integer> slotData = this.takeItemFromTile((ITransportCartCargo)cart);
                    if (slotData == null) return;
                    if (slotData.left() == null) return;
                    if (((ItemStack)slotData.left()).field_77994_a < 0) return;
                    TileEntity tile = this.getLoadTile();
                    if (!(tile instanceof IInventory)) return;
                    ItemStack left = InventoryUtility.putStackInInventory((IInventory)inventory2, (ItemStack)((ItemStack)slotData.left()), (boolean)false);
                    if (left != null && left.field_77994_a > 0) {
                        ((IInventory)tile).func_70299_a(((Integer)slotData.right()).intValue(), left);
                        return;
                    }
                    ((IInventory)tile).func_70299_a(((Integer)slotData.right()).intValue(), null);
                    return;
                }
                this.handlePush(cart);
                cart.recenterCartOnRail((ITransportRail)this, false);
                return;
            }
            if (!(cart instanceof ITransportCartHasItem)) return;
            if (((ITransportCartHasItem)cart).getTransportedItem() != null) {
                this.handlePush(cart);
                cart.recenterCartOnRail((ITransportRail)this, false);
                return;
            }
            cart.setCartMotion(0.0, 0.0, 0.0);
            cart.recenterCartOnRail((ITransportRail)this, true);
            if (this.field_145850_b.field_72995_K) return;
            Pair<ItemStack, Integer> slotData = this.takeItemFromTile((ITransportCartCargo)((ITransportCartHasItem)cart));
            if (slotData == null) return;
            if (slotData.left() == null) return;
            if (((ItemStack)slotData.left()).field_77994_a < 0) return;
            TileEntity tile = this.getLoadTile();
            if (!(tile instanceof IInventory)) return;
            ItemStack left = ((ITransportCartHasItem)cart).setTransportedItem((ItemStack)slotData.left());
            if (left != null && left.field_77994_a > 0) {
                ((IInventory)tile).func_70299_a(((Integer)slotData.right()).intValue(), left);
                return;
            }
            ((IInventory)tile).func_70299_a(((Integer)slotData.right()).intValue(), null);
            return;
        }
        if (!this.isUnloadRail()) return;
        if (cart instanceof ITransportCartHasCargo) {
            inventory = ((ITransportCartHasCargo)cart).getInventory();
            if (inventory == null || inventory.isEmpty()) {
                this.handlePush(cart);
                cart.recenterCartOnRail((ITransportRail)this, false);
                return;
            }
        } else {
            if (!(cart instanceof ITransportCartHasItem)) return;
            if (((ITransportCartHasItem)cart).getTransportedItem() == null) {
                this.handlePush(cart);
                cart.recenterCartOnRail((ITransportRail)this, false);
                return;
            }
            cart.setCartMotion(0.0, 0.0, 0.0);
            cart.recenterCartOnRail((ITransportRail)this, true);
            if (this.field_145850_b.field_72995_K) return;
            ItemStack prev = ((ITransportCartHasItem)cart).getTransportedItem().func_77946_l();
            ItemStack stack = this.storeItemInTile(((ITransportCartHasItem)cart).getTransportedItem().func_77946_l());
            if (stack != null && stack.field_77994_a > 0) {
                if (InventoryUtility.stacksMatchExact((ItemStack)prev, (ItemStack)stack)) return;
                ((ITransportCartHasItem)cart).setTransportedItem(stack);
                return;
            }
            ((ITransportCartHasItem)cart).setTransportedItem(null);
            return;
        }
        ArrayList slotsWithItems = inventory.getFilledSlots();
        if (slotsWithItems.isEmpty()) return;
        cart.setCartMotion(0.0, 0.0, 0.0);
        cart.recenterCartOnRail((ITransportRail)this, true);
        if (this.field_145850_b.field_72995_K) return;
        Iterator iterator = slotsWithItems.iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            ItemStack prev = inventory.func_70301_a(slot).func_77946_l();
            ItemStack stack = this.storeItemInTile(inventory.func_70301_a(slot).func_77946_l());
            if (stack == null || stack.field_77994_a <= 0) {
                inventory.func_70299_a(slot, null);
                continue;
            }
            if (InventoryUtility.stacksMatchExact((ItemStack)prev, (ItemStack)stack)) continue;
            inventory.func_70299_a(slot, stack);
        }
    }

    public ItemStack storeItemInTile(ItemStack stack) {
        TileEntity tile = this.getLoadTile();
        if (tile instanceof IRailInventoryTile) {
            if (((IRailInventoryTile)tile).canStore(stack, this.getLoadingDirection().getOpposite())) {
                int[] slots = ((IRailInventoryTile)tile).getSlotsToLoad(stack, this.getLoadingDirection().getOpposite());
                int stackLimit = ((IRailInventoryTile)tile).getInventory().func_70297_j_();
                IInventory inventory = ((IRailInventoryTile)tile).getInventory();
                for (int index = 0; index < slots.length; ++index) {
                    int roomLeft;
                    int slot = slots[index];
                    if (!((IRailInventoryTile)tile).canStore(stack, slot, this.getLoadingDirection().getOpposite())) continue;
                    ItemStack slotStack = inventory.func_70301_a(slot);
                    if (slotStack == null) {
                        if (stack.field_77994_a > stackLimit) {
                            ItemStack copyStack = stack.func_77946_l();
                            copyStack.field_77994_a = stackLimit;
                            inventory.func_70299_a(slot, copyStack);
                            stack.field_77994_a -= copyStack.field_77994_a;
                            continue;
                        }
                        inventory.func_70299_a(slot, stack);
                        return null;
                    }
                    if (!InventoryUtility.stacksMatch((ItemStack)slotStack, (ItemStack)stack) || (roomLeft = stackLimit - slotStack.field_77994_a) <= 0) continue;
                    slotStack.field_77994_a += roomLeft;
                    inventory.func_70299_a(slot, slotStack);
                    stack.field_77994_a -= roomLeft;
                }
            }
        } else if (tile instanceof IInventory) {
            return InventoryUtility.putStackInInventory((IInventory)((IInventory)tile), (ItemStack)stack, (int)this.getLoadingDirection().getOpposite().ordinal(), (boolean)false);
        }
        return stack;
    }

    public Pair<ItemStack, Integer> takeItemFromTile(ITransportCartCargo cart) {
        TileEntity tile = this.getLoadTile();
        if (tile instanceof IRailInventoryTile) {
            int[] slots = ((IRailInventoryTile)tile).getSlotsToUnload(this.getLoadingDirection().getOpposite());
            IInventory inventory = ((IRailInventoryTile)tile).getInventory();
            for (int index = 0; index < slots.length; ++index) {
                int slot = slots[index];
                ItemStack slotStack = inventory.func_70301_a(slot);
                if (slotStack == null || !((IRailInventoryTile)tile).canRemove(slotStack, this.getLoadingDirection().getOpposite()) || !cart.canAcceptItemForTransport(slotStack)) continue;
                return new Pair((Object)slotStack, (Object)slot);
            }
        } else if (tile instanceof IInventory) {
            return InventoryUtility.findFirstItemInInventory((IInventory)((IInventory)tile), (int)this.getLoadingDirection().getOpposite().ordinal(), (int)64, (IInventoryFilter)cart.getInventoryFilter());
        }
        return null;
    }

    public Pair<ItemStack, Integer> takeItemFromTile(IInventoryFilter filter) {
        TileEntity tile = this.getLoadTile();
        if (tile instanceof IRailInventoryTile) {
            int[] slots = ((IRailInventoryTile)tile).getSlotsToUnload(this.getLoadingDirection().getOpposite());
            IInventory inventory = ((IRailInventoryTile)tile).getInventory();
            for (int index = 0; index < slots.length; ++index) {
                int slot = slots[index];
                ItemStack slotStack = inventory.func_70301_a(slot);
                if (slotStack == null || !((IRailInventoryTile)tile).canRemove(slotStack, this.getLoadingDirection().getOpposite()) || !filter.isStackInFilter(slotStack)) continue;
                return new Pair((Object)slotStack, (Object)slot);
            }
        } else if (tile instanceof IInventory) {
            return InventoryUtility.findFirstItemInInventory((IInventory)((IInventory)tile), (int)this.getLoadingDirection().getOpposite().ordinal(), (int)64, (IInventoryFilter)filter);
        }
        return null;
    }

    public TileEntity getLoadTile() {
        return ((Location)this.toLocation().add(this.getLoadingDirection())).getTileEntity();
    }

    public boolean isUsableRail() {
        return !this.isLoaderExtendTrack();
    }

    public boolean isPoweredRail() {
        return this.railType == PoweredRails.POWERED;
    }

    public boolean isRotationRail() {
        return this.railType == PoweredRails.ROTATION;
    }

    public boolean isOrientationRail() {
        return this.railType == PoweredRails.ORIENTATION;
    }

    public boolean isStopRail() {
        return this.railType == PoweredRails.STOP;
    }

    public boolean isLoaderRail() {
        return this.railType == PoweredRails.LOADER;
    }

    public boolean isUnloadRail() {
        return this.railType == PoweredRails.UNLOADER;
    }

    public boolean isSplitterRail() {
        return this.railType == PoweredRails.SPLITTER;
    }

    public boolean isLoaderExtendTrack() {
        return this.railType == PoweredRails.EXTENDER;
    }

    protected void setupLoadingDirection() {
        block0 : switch (this.getFacingDirection()) {
            case UP: {
                switch (this.getAttachedDirection()) {
                    case NORTH: {
                        this.loadDirection = ForgeDirection.WEST;
                        break;
                    }
                    case SOUTH: {
                        this.loadDirection = ForgeDirection.EAST;
                        break;
                    }
                    case EAST: {
                        this.loadDirection = ForgeDirection.NORTH;
                        break;
                    }
                    case WEST: {
                        this.loadDirection = ForgeDirection.SOUTH;
                    }
                }
                break;
            }
            case DOWN: {
                switch (this.getAttachedDirection()) {
                    case NORTH: {
                        this.loadDirection = ForgeDirection.EAST;
                        break;
                    }
                    case SOUTH: {
                        this.loadDirection = ForgeDirection.WEST;
                        break;
                    }
                    case EAST: {
                        this.loadDirection = ForgeDirection.SOUTH;
                        break;
                    }
                    case WEST: {
                        this.loadDirection = ForgeDirection.NORTH;
                    }
                }
                break;
            }
            case NORTH: {
                switch (this.getAttachedDirection()) {
                    case EAST: {
                        this.loadDirection = ForgeDirection.DOWN;
                        break block0;
                    }
                    case WEST: {
                        this.loadDirection = ForgeDirection.UP;
                        break block0;
                    }
                }
                this.loadDirection = ForgeDirection.EAST;
                break;
            }
            case SOUTH: {
                switch (this.getAttachedDirection()) {
                    case EAST: {
                        this.loadDirection = ForgeDirection.UP;
                        break block0;
                    }
                    case WEST: {
                        this.loadDirection = ForgeDirection.DOWN;
                        break block0;
                    }
                }
                this.loadDirection = ForgeDirection.WEST;
                break;
            }
            case WEST: {
                switch (this.getAttachedDirection()) {
                    case NORTH: {
                        this.loadDirection = ForgeDirection.DOWN;
                        break block0;
                    }
                    case SOUTH: {
                        this.loadDirection = ForgeDirection.UP;
                        break block0;
                    }
                }
                this.loadDirection = ForgeDirection.NORTH;
                break;
            }
            case EAST: {
                switch (this.getAttachedDirection()) {
                    case NORTH: {
                        this.loadDirection = ForgeDirection.UP;
                        break block0;
                    }
                    case SOUTH: {
                        this.loadDirection = ForgeDirection.DOWN;
                        break block0;
                    }
                }
                this.loadDirection = ForgeDirection.SOUTH;
            }
        }
        if (!this.rotateClockwise) {
            this.loadDirection = this.loadDirection.getOpposite();
        }
    }

    public void setLoadingDirection(ForgeDirection direction) {
        this.loadDirection = direction;
    }

    public ForgeDirection getLoadingDirection() {
        if (this.loadDirection == null) {
            this.setupLoadingDirection();
        }
        return this.loadDirection;
    }

    public ForgeDirection getAttachedDirection() {
        if (this.attachedSide == null) {
            this.attachedSide = ForgeDirection.getOrientation((int)this.getMetadata());
        }
        return this.attachedSide;
    }

    public void setFacingDirection(ForgeDirection facingDirection) {
        this.facingDirection = facingDirection;
        if (this.oldWorld() != null && this.isServer()) {
            this.sendDescPacket();
        }
    }

    public ForgeDirection getFacingDirection() {
        return this.facingDirection;
    }

    public float getRailHeight() {
        return 0.4f;
    }

    protected void handlePush(ITransportCart cart) {
        if (this.isServer()) {
            cart.recenterCartOnRail((ITransportRail)this, false);
            Pos pos = (Pos)new Pos(this.facingDirection).multiply((double)cart.getDesiredPushVelocity());
            cart.setCartMotion(pos.x(), pos.y(), pos.z());
        }
    }

    protected boolean onPlayerRightClick(EntityPlayer player, int side, Pos hit) {
        if (Engine.runningAsDev && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == Items.field_151055_y) {
            if (this.isServer()) {
                player.func_145747_a((IChatComponent)new ChatComponentText("A: " + this.getAttachedDirection() + " F:" + this.getFacingDirection() + " T:" + (Object)((Object)this.railType)));
                if (this.isUnloadRail() || this.isLoaderRail()) {
                    this.setupLoadingDirection();
                    player.func_145747_a((IChatComponent)new ChatComponentText("L: " + this.loadDirection + " C: " + this.rotateClockwise));
                }
            }
            return true;
        }
        return false;
    }

    protected boolean onPlayerRightClickWrench(EntityPlayer player, int side, Pos hit) {
        if (player.func_70093_af()) {
            if (this.isRotationRail() || this.isUnloadRail() || this.isLoaderRail()) {
                this.rotateClockwise = !this.rotateClockwise;
                this.setupLoadingDirection();
                if (this.isServer()) {
                    this.sendDescPacket();
                } else {
                    this.oldWorld().func_147458_c(this.xi(), this.yi(), this.zi(), this.xi(), this.yi(), this.zi());
                }
            }
        } else {
            if (side == 0 || side == 1) {
                boolean right;
                boolean high = hit.z() >= 0.7;
                boolean low = hit.z() <= 0.3;
                boolean left = hit.x() <= 0.3;
                boolean bl = right = hit.x() >= 0.7;
                if (!left && !right) {
                    if (high) {
                        this.setFacingDirection(ForgeDirection.SOUTH);
                    } else if (low) {
                        this.setFacingDirection(ForgeDirection.NORTH);
                    }
                } else if (left) {
                    this.setFacingDirection(side == 0 ? ForgeDirection.EAST : ForgeDirection.WEST);
                } else if (right) {
                    this.setFacingDirection(side == 0 ? ForgeDirection.WEST : ForgeDirection.EAST);
                }
            } else if (side == 2 || side == 3) {
                boolean right;
                boolean high = hit.y() >= 0.7;
                boolean low = hit.y() <= 0.3;
                boolean left = hit.x() <= 0.3;
                boolean bl = right = hit.x() >= 0.7;
                if (!left && !right) {
                    if (high) {
                        this.setFacingDirection(ForgeDirection.UP);
                    } else if (low) {
                        this.setFacingDirection(ForgeDirection.DOWN);
                    }
                } else if (left) {
                    this.setFacingDirection(ForgeDirection.WEST);
                } else if (right) {
                    this.setFacingDirection(ForgeDirection.EAST);
                }
            } else if (side == 4 || side == 5) {
                boolean right;
                boolean high = hit.y() >= 0.7;
                boolean low = hit.y() <= 0.3;
                boolean left = hit.z() <= 0.3;
                boolean bl = right = hit.z() >= 0.7;
                if (!left && !right) {
                    if (high) {
                        this.setFacingDirection(ForgeDirection.UP);
                    } else if (low) {
                        this.setFacingDirection(ForgeDirection.DOWN);
                    }
                } else if (left) {
                    this.setFacingDirection(ForgeDirection.NORTH);
                } else if (right) {
                    this.setFacingDirection(ForgeDirection.SOUTH);
                }
            }
            this.oldWorld().func_147458_c(this.xi(), this.yi(), this.zi(), this.xi(), this.yi(), this.zi());
        }
        return true;
    }

    public void writeDescPacket(ByteBuf buf) {
        buf.writeInt(this.railType.ordinal());
        buf.writeInt(this.getFacingDirection().ordinal());
        if (this.isRotationRail()) {
            buf.writeBoolean(this.rotateToAngle);
            buf.writeBoolean(this.rotateClockwise);
            buf.writeInt(this.rotateYaw);
        } else if (this.isStopRail()) {
            buf.writeBoolean(this.stopCarts);
        } else if (this.isLoaderRail() || this.isUnloadRail()) {
            buf.writeBoolean(this.rotateClockwise);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("facingDirection")) {
            this.setFacingDirection(ForgeDirection.getOrientation((int)nbt.func_74762_e("facingDirection")));
        }
        this.railType = PoweredRails.get(nbt.func_74762_e("railType"));
        this.rotateClockwise = nbt.func_74767_n("rotateClockwise");
        if (this.isRotationRail()) {
            if (nbt.func_74764_b("rotateToAngle")) {
                this.rotateToAngle = nbt.func_74767_n("rotateToAngle");
            }
            if (nbt.func_74764_b("rotationYaw")) {
                this.rotateYaw = nbt.func_74762_e("rotationYaw");
            }
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("facingDirection", this.getFacingDirection().ordinal());
        nbt.func_74768_a("railType", this.railType.ordinal());
        nbt.func_74757_a("rotateClockwise", this.rotateClockwise);
        if (this.isRotationRail()) {
            nbt.func_74757_a("rotateToAngle", this.rotateToAngle);
            nbt.func_74768_a("rotationYaw", this.rotateYaw);
        }
    }

    public Cube getCollisionBounds() {
        if (this.oldWorld() != null) {
            int meta = this.oldWorld().func_72805_g(this.xi(), this.yi(), this.zi());
            ForgeDirection dir = ForgeDirection.getOrientation((int)meta);
            switch (dir) {
                case DOWN: {
                    return COLLISION_BOX_DOWN;
                }
                case NORTH: {
                    return COLLISION_BOX_NORTH;
                }
                case SOUTH: {
                    return COLLISION_BOX_SOUTH;
                }
                case EAST: {
                    return COLLISION_BOX_EAST;
                }
                case WEST: {
                    return COLLISION_BOX_WEST;
                }
            }
        }
        return this.bounds;
    }

    public void getSubBlocks(Item item, CreativeTabs creativeTabs, List list) {
        for (PoweredRails rails : PoweredRails.values()) {
            list.add(new ItemStack(item, 1, rails.ordinal()));
        }
    }
}

