/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.assemblyline.content.rail.powered;

import com.builtbroken.assemblyline.AssemblyLine;
import com.builtbroken.assemblyline.content.rail.powered.PoweredRails;
import com.builtbroken.assemblyline.content.rail.powered.TilePowerRail;
import com.builtbroken.mc.prefab.tile.Tile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.util.ForgeDirection;

public class TilePowerRailClient
extends TilePowerRail {
    public static IIcon main;
    public static IIcon[][] arrow;

    @Override
    public Tile newTile() {
        return new TilePowerRailClient();
    }

    public void firstTick() {
        super.firstTick();
        this.markRender();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        main = iconRegister.func_94245_a("assemblyline:PowerRailBody");
        String[] sideName = new String[]{"Up", "Down", "Left", "Right"};
        String[] textureNames = new String[]{"", "Clockwise", "AClockwise", "Stop", "Go", "LoaderL", "LoaderR", "UnloaderL", "UnloaderR"};
        arrow = new IIcon[4][];
        for (int i = 0; i < sideName.length; ++i) {
            TilePowerRailClient.arrow[i] = new IIcon[textureNames.length];
            for (int y = 0; y < textureNames.length; ++y) {
                TilePowerRailClient.arrow[i][y] = iconRegister.func_94245_a("assemblyline:PowerRailArrow" + sideName[i] + textureNames[y]);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        if (this != this.block.staticTile) {
            if (side == this.getAttachedDirection().ordinal()) {
                int arrowIndex = this.getArrowIndex();
                if (this.isUnloadRail()) {
                    return arrow[arrowIndex][!this.rotateClockwise ? 5 : 6];
                }
                if (this.isLoaderRail()) {
                    return arrow[arrowIndex][!this.rotateClockwise ? 7 : 8];
                }
                if (this.isStopRail()) {
                    return this.stopCarts ? arrow[arrowIndex][3] : arrow[arrowIndex][4];
                }
                if (this.isRotationRail()) {
                    return this.rotateClockwise ? arrow[arrowIndex][1] : arrow[arrowIndex][2];
                }
                return arrow[arrowIndex][0];
            }
        } else if (side == 1) {
            PoweredRails type = PoweredRails.get(meta);
            return type == PoweredRails.UNLOADER ? arrow[3][7] : (type == PoweredRails.LOADER ? arrow[3][5] : (type == PoweredRails.STOP ? arrow[3][3] : (type == PoweredRails.ROTATION ? arrow[3][1] : arrow[3][0])));
        }
        return main;
    }

    public final int getArrowIndex() {
        if (this.getAttachedDirection() == ForgeDirection.UP || this.getAttachedDirection() == ForgeDirection.DOWN) {
            if (this.getFacingDirection() == ForgeDirection.NORTH) {
                return 0;
            }
            if (this.getFacingDirection() == ForgeDirection.EAST) {
                return 3;
            }
            if (this.getFacingDirection() == ForgeDirection.SOUTH) {
                return 1;
            }
            if (this.getFacingDirection() == ForgeDirection.WEST) {
                return 2;
            }
        } else if (this.getAttachedDirection() == ForgeDirection.EAST) {
            if (this.getFacingDirection() == ForgeDirection.NORTH) {
                return 3;
            }
            if (this.getFacingDirection() == ForgeDirection.UP) {
                return 0;
            }
            if (this.getFacingDirection() == ForgeDirection.SOUTH) {
                return 2;
            }
            if (this.getFacingDirection() == ForgeDirection.DOWN) {
                return 1;
            }
        } else if (this.getAttachedDirection() == ForgeDirection.WEST) {
            if (this.getFacingDirection() == ForgeDirection.NORTH) {
                return 2;
            }
            if (this.getFacingDirection() == ForgeDirection.UP) {
                return 0;
            }
            if (this.getFacingDirection() == ForgeDirection.SOUTH) {
                return 3;
            }
            if (this.getFacingDirection() == ForgeDirection.DOWN) {
                return 1;
            }
        } else if (this.getAttachedDirection() == ForgeDirection.NORTH) {
            if (this.getFacingDirection() == ForgeDirection.EAST) {
                return 2;
            }
            if (this.getFacingDirection() == ForgeDirection.UP) {
                return 0;
            }
            if (this.getFacingDirection() == ForgeDirection.WEST) {
                return 3;
            }
            if (this.getFacingDirection() == ForgeDirection.DOWN) {
                return 1;
            }
        } else if (this.getAttachedDirection() == ForgeDirection.SOUTH) {
            if (this.getFacingDirection() == ForgeDirection.EAST) {
                return 3;
            }
            if (this.getFacingDirection() == ForgeDirection.UP) {
                return 0;
            }
            if (this.getFacingDirection() == ForgeDirection.WEST) {
                return 2;
            }
            if (this.getFacingDirection() == ForgeDirection.DOWN) {
                return 1;
            }
        }
        return 0;
    }

    public ItemStack getPickBlock(MovingObjectPosition target) {
        return new ItemStack(AssemblyLine.blockPowerRail, 1, this.railType.ordinal());
    }

    public void readDescPacket(ByteBuf buf) {
        this.railType = PoweredRails.get(buf.readInt());
        this.setFacingDirection(ForgeDirection.getOrientation((int)buf.readInt()));
        if (this.isRotationRail()) {
            this.rotateToAngle = buf.readBoolean();
            this.rotateClockwise = buf.readBoolean();
            this.rotateYaw = buf.readInt();
        } else if (this.isStopRail()) {
            this.stopCarts = buf.readBoolean();
        } else if (this.isLoaderRail() || this.isLoaderRail()) {
            this.rotateClockwise = buf.readBoolean();
        }
        this.oldWorld().func_147458_c(this.xi(), this.yi(), this.zi(), this.xi(), this.yi(), this.zi());
    }
}

