/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.batmanmod.entity;

import net.mcreator.batmanmod.init.BatmanModModEntities;
import net.mcreator.batmanmod.init.BatmanModModItems;
import net.mcreator.batmanmod.init.BatmanModModMobEffects;
import net.mcreator.batmanmod.procedures.GHookFlyingTickProcedure;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class GHookEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)BatmanModModItems.BATERANG.get());
    private long timeGrounded = -1L;
    private static final int DURATION_TICKS = 200;

    public GHookEntity(PlayMessages.SpawnEntity packet, Level world) {
        super((EntityType)BatmanModModEntities.G_HOOK.get(), world);
    }

    public GHookEntity(EntityType<? extends GHookEntity> type, Level world) {
        super(type, world);
    }

    public GHookEntity(EntityType<? extends GHookEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
    }

    public GHookEntity(EntityType<? extends GHookEntity> type, LivingEntity entity, Level world) {
        super(type, entity, world);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7846_() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack m_7941_() {
        return PROJECTILE_ITEM;
    }

    protected void m_7761_(LivingEntity entity) {
        super.m_7761_(entity);
        entity.m_21317_(entity.m_21234_() - 1);
    }

    public void m_8119_() {
        super.m_8119_();
        GHookFlyingTickProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_19749_(), (Entity)this);
        if (this.f_36703_) {
            if (this.timeGrounded == -1L) {
                this.timeGrounded = this.m_9236_().m_46467_();
            }
            if (this.m_19749_() instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)this.m_19749_();
                if (!owner.m_21023_((MobEffect)BatmanModModMobEffects.GRAPPLING.get())) {
                    MobEffectInstance grapplingEffect = new MobEffectInstance((MobEffect)BatmanModModMobEffects.GRAPPLING.get(), 200, 0, false, false);
                    owner.m_7292_(grapplingEffect);
                }
                if (owner.m_21205_().m_41720_() != BatmanModModItems.GRAPPLING_GUN.get()) {
                    owner.m_21195_((MobEffect)BatmanModModMobEffects.GRAPPLING.get());
                    this.m_146870_();
                }
            }
            if (this.m_9236_().m_46467_() - this.timeGrounded >= 200L) {
                this.m_146870_();
            }
        }
    }

    public static GHookEntity shoot(Level world, LivingEntity entity, RandomSource source) {
        return GHookEntity.shoot(world, entity, source, 2.5f, 5.0, 5);
    }

    public static GHookEntity shoot(Level world, LivingEntity entity, RandomSource source, float pullingPower) {
        return GHookEntity.shoot(world, entity, source, pullingPower * 2.5f, 5.0, 5);
    }

    public static GHookEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        GHookEntity entityarrow = new GHookEntity((EntityType<? extends GHookEntity>)((EntityType)BatmanModModEntities.G_HOOK.get()), entity, world);
        entityarrow.m_6686_(entity.m_20252_((float)1.0f).f_82479_, entity.m_20252_((float)1.0f).f_82480_, entity.m_20252_((float)1.0f).f_82481_, power * 2.0f, 0.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36762_(false);
        entityarrow.m_36781_(damage);
        entityarrow.m_36735_(knockback);
        world.m_7967_((Entity)entityarrow);
        world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("batman_mod:grapple_shot")), SoundSource.PLAYERS, 1.0f, 1.0f / (random.m_188501_() * 0.5f + 1.0f) + power / 2.0f);
        return entityarrow;
    }

    public static GHookEntity shoot(LivingEntity entity, LivingEntity target) {
        GHookEntity entityarrow = new GHookEntity((EntityType<? extends GHookEntity>)((EntityType)BatmanModModEntities.G_HOOK.get()), entity, entity.m_9236_());
        double dx = target.m_20185_() - entity.m_20185_();
        double dy = target.m_20186_() + (double)target.m_20192_() - 1.1;
        double dz = target.m_20189_() - entity.m_20189_();
        entityarrow.m_6686_(dx, dy - entityarrow.m_20186_() + Math.hypot(dx, dz) * (double)0.2f, dz, 5.0f, 12.0f);
        entityarrow.m_20225_(true);
        entityarrow.m_36781_(5.0);
        entityarrow.m_36735_(5);
        entityarrow.m_36762_(false);
        entity.m_9236_().m_7967_((Entity)entityarrow);
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("batman_mod:grapple_shot")), SoundSource.PLAYERS, 1.0f, 1.0f / (RandomSource.m_216327_().m_188501_() * 0.5f + 1.0f));
        return entityarrow;
    }
}

