/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.batmanmod.procedures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BloodSpawnProcedure {
    private static final List<String> BLACKLISTED_EFFECTS = Arrays.asList("Suit OS", "Batsuit OS", "Crime Magnet", "Stagger", "Ninja Escape", "Pod Eject", "Dog Run", "Lunge", "Stealth Attacked", "Grappling", "Grapnel Boost", "Slide", "Hooked", "Grapple Jump", "Dive", "Beyond Boost", "Flip Kick Fall Damage", "Detective Mode", "Pill Used", "Ejected", "BatCall", "Brain Damage", "Block", "Shockwave", "Training", "Bleeding", "Vehichle Breaks", "Skill Set", "Reinforcements");

    public static void execute(LevelAccessor world, double x, double y, double z) {
        List nearbyEntities = world.m_6443_(LivingEntity.class, AABB.m_165882_((Vec3)new Vec3(x, y, z), (double)2.0, (double)2.0, (double)2.0), e -> true);
        if (nearbyEntities.isEmpty()) {
            return;
        }
        LivingEntity subjectDNA = nearbyEntities.stream().min(Comparator.comparingDouble(e -> e.m_20275_(x, y, z))).orElse(null);
        if (subjectDNA == null) {
            return;
        }
        if (subjectDNA.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("battag:noblood")))) {
            return;
        }
        if (!world.m_5776_()) {
            BlockPos bp = BlockPos.m_274561_((double)x, (double)y, (double)z);
            BlockEntity blockEntity = world.m_7702_(bp);
            BlockState bs = world.m_8055_(bp);
            if (blockEntity != null) {
                blockEntity.getPersistentData().m_128359_("Name", "Name: " + subjectDNA.m_5446_().getString());
                blockEntity.getPersistentData().m_128359_("Height", "Height: " + subjectDNA.m_20206_());
                blockEntity.getPersistentData().m_128359_("Health", "Max Health: " + subjectDNA.m_21233_());
                ArrayList<String> effectList = new ArrayList<String>();
                for (MobEffectInstance effect : subjectDNA.m_21220_()) {
                    String id = effect.m_19576_();
                    if (id.startsWith("effect.batman_mod.")) {
                        String clean = id.substring("effect.batman_mod.".length()).replace("_", " ");
                        effectList.add(BloodSpawnProcedure.capitalizeWords(clean));
                        continue;
                    }
                    String filtered = BloodSpawnProcedure.filterEffect(id);
                    if (filtered.isEmpty()) continue;
                    effectList.add(filtered);
                }
                String effects = String.join((CharSequence)", ", effectList);
                blockEntity.getPersistentData().m_128359_("Potions", effects);
                blockEntity.getPersistentData().m_128359_("Age", subjectDNA.m_6162_() ? "Child" : "Adult");
                if (world instanceof Level) {
                    Level level = (Level)world;
                    level.m_7260_(bp, bs, bs, 3);
                }
            }
        }
    }

    private static String filterEffect(String effect) {
        if (effect.startsWith("effect.minecraft.")) {
            effect = effect.substring("effect.minecraft.".length());
        }
        for (String blacklisted : BLACKLISTED_EFFECTS) {
            if (!effect.toLowerCase().contains(blacklisted.toLowerCase().replace(" ", "_"))) continue;
            return "";
        }
        return effect.replaceAll("\\d*$", "").replaceAll(",$", "").trim();
    }

    private static String capitalizeWords(String input) {
        String[] words = input.split(" ");
        StringBuilder result = new StringBuilder();
        for (String w : words) {
            if (w.isEmpty()) continue;
            result.append(Character.toUpperCase(w.charAt(0))).append(w.substring(1).toLowerCase()).append(" ");
        }
        return result.toString().trim();
    }
}

