/*
 * Decompiled with CFR 0.152.
 */
package com.jlgm.pgen.client.gui;

import com.google.common.collect.Lists;
import com.jlgm.pgen.lib.PGenMath;
import com.jlgm.pgen.network.PGenPacketHandler;
import com.jlgm.pgen.network.ParticleGeneratorMessage;
import com.jlgm.pgen.tileentity.TileEntityParticleGenerator;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiParticleGenerator
extends GuiScreen {
    private GuiTextField positionX;
    private GuiTextField positionY;
    private GuiTextField positionZ;
    private GuiTextField argument1;
    private GuiTextField argument2;
    private GuiTextField movementX;
    private GuiTextField movementY;
    private GuiTextField movementZ;
    private GuiButton doneButton;
    private GuiButton cancelButton;
    private static ResourceLocation texture;
    private final TileEntityParticleGenerator tile;
    private final int numberOfParticles = 47;
    private int currentShownParticles = 0;
    private int textureWidth = 176;
    private int textureHeight = 176;
    private int chosedParticle = 0;
    private boolean relativeCoords = false;

    public GuiParticleGenerator(TileEntityParticleGenerator chatBox) {
        texture = new ResourceLocation("jlgm_pgen:textures/gui/particleGenerator.png");
        this.tile = chatBox;
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        int basePointX = this.field_146294_l / 2 - this.textureWidth / 2;
        int basePointY = this.field_146295_m / 2 - this.textureHeight / 2;
        this.doneButton = new GuiButton(0, basePointX + 113, basePointY + 118, 50, 20, new TextComponentString(I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])).func_150260_c());
        this.field_146292_n.add(this.doneButton);
        this.cancelButton = new GuiButton(1, basePointX + 113, basePointY + 144, 50, 20, new TextComponentString(I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])).func_150260_c());
        this.field_146292_n.add(this.cancelButton);
        this.chosedParticle = this.tile.particleID;
        this.currentShownParticles = Math.min(this.chosedParticle, 42);
        this.positionX = new GuiTextField(0, this.field_146289_q, basePointX + 1 + 22, basePointY + 1 + 70, 41, 12);
        this.positionX.func_146180_a(String.valueOf(this.tile.x));
        this.positionX.func_146203_f(9);
        this.positionX.func_146185_a(true);
        this.positionX.func_146195_b(false);
        this.positionX.func_146205_d(true);
        this.positionY = new GuiTextField(1, this.field_146289_q, basePointX + 1 + 22, basePointY + 1 + 86, 41, 12);
        this.positionY.func_146180_a(String.valueOf(this.tile.y));
        this.positionY.func_146203_f(9);
        this.positionY.func_146185_a(true);
        this.positionY.func_146195_b(false);
        this.positionY.func_146205_d(true);
        this.positionZ = new GuiTextField(2, this.field_146289_q, basePointX + 1 + 22, basePointY + 1 + 102, 41, 12);
        this.positionZ.func_146180_a(String.valueOf(this.tile.z));
        this.positionZ.func_146203_f(9);
        this.positionZ.func_146185_a(true);
        this.positionZ.func_146195_b(false);
        this.positionZ.func_146205_d(true);
        this.argument1 = new GuiTextField(3, this.field_146289_q, basePointX + 1 + 84, basePointY + 1 + 86, 77, 12);
        if (this.chosedParticle == EnumParticleTypes.ITEM_CRACK.func_179348_c()) {
            this.argument1.func_146180_a(((ResourceLocation)Item.field_150901_e.func_177774_c((Object)Item.func_150899_d((int)this.tile.arg1ID))).toString());
        } else {
            this.argument1.func_146180_a(((ResourceLocation)Block.field_149771_c.func_177774_c((Object)Block.func_149729_e((int)this.tile.arg1ID))).toString());
        }
        this.argument1.func_146203_f(255);
        this.argument1.func_146185_a(true);
        this.argument1.func_146195_b(false);
        this.argument1.func_146205_d(true);
        this.argument2 = new GuiTextField(4, this.field_146289_q, basePointX + 1 + 84, basePointY + 1 + 102, 77, 12);
        this.argument2.func_146180_a(String.valueOf(this.tile.arg2Metadata));
        this.argument2.func_146203_f(255);
        this.argument2.func_146185_a(true);
        this.argument2.func_146195_b(false);
        this.argument2.func_146205_d(true);
        this.movementX = new GuiTextField(5, this.field_146289_q, basePointX + 1 + 22, basePointY + 1 + 118, 41, 12);
        this.movementX.func_146180_a(String.valueOf(this.tile.vX));
        this.movementX.func_146203_f(9);
        this.movementX.func_146185_a(true);
        this.movementX.func_146195_b(false);
        this.movementX.func_146205_d(true);
        this.movementY = new GuiTextField(6, this.field_146289_q, basePointX + 1 + 22, basePointY + 1 + 134, 41, 12);
        this.movementY.func_146180_a(String.valueOf(this.tile.vY));
        this.movementY.func_146203_f(9);
        this.movementY.func_146185_a(true);
        this.movementY.func_146195_b(false);
        this.movementY.func_146205_d(true);
        this.movementZ = new GuiTextField(7, this.field_146289_q, basePointX + 1 + 22, basePointY + 1 + 150, 41, 12);
        this.movementZ.func_146180_a(String.valueOf(this.tile.vZ));
        this.movementZ.func_146203_f(9);
        this.movementZ.func_146185_a(true);
        this.movementZ.func_146195_b(false);
        this.movementZ.func_146205_d(true);
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.positionX.func_146206_l()) {
            this.positionX.func_146178_a();
        }
        if (this.positionY.func_146206_l()) {
            this.positionY.func_146178_a();
        }
        if (this.positionZ.func_146206_l()) {
            this.positionZ.func_146178_a();
        }
        if (this.argument1.func_146206_l()) {
            this.argument1.func_146178_a();
        }
        if (this.argument2.func_146206_l()) {
            this.argument2.func_146178_a();
        }
        if (this.movementX.func_146206_l()) {
            this.argument1.func_146178_a();
        }
        if (this.movementY.func_146206_l()) {
            this.argument2.func_146178_a();
        }
        if (this.movementZ.func_146206_l()) {
            this.argument2.func_146178_a();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        ArrayList list;
        this.func_146276_q_();
        this.field_146297_k.func_110434_K().func_110577_a(texture);
        int basePointX = this.field_146294_l / 2 - this.textureWidth / 2;
        int basePointY = this.field_146295_m / 2 - this.textureHeight / 2;
        this.func_73729_b(basePointX, basePointY, 0, 0, this.textureWidth, this.textureHeight);
        float percentaje = (float)this.currentShownParticles / 42.0f;
        int positionY = Math.round(26.0f + 30.0f * percentaje);
        this.field_146297_k.func_110434_K().func_110577_a(texture);
        this.func_73729_b(basePointX + 158, basePointY + positionY, 176, 0, 9, 3);
        for (int i = 0; i < 5; ++i) {
            if (EnumParticleTypes.func_179342_a((int)(this.currentShownParticles + i)).func_179348_c() == this.chosedParticle) {
                GuiParticleGenerator.func_73734_a((int)(basePointX + 8), (int)(basePointY + 18 + i * 10), (int)(basePointX + 19 + 137), (int)(basePointY + 19 + 8 + i * 10), (int)-16766888);
            }
            if (EnumParticleTypes.func_179342_a((int)(this.currentShownParticles + i)).func_179345_d() <= 0) continue;
            this.field_146289_q.func_78276_b("!", basePointX + 154, basePointY + 19 + i * 10, 0xFF0000);
        }
        this.field_146289_q.func_78276_b(new TextComponentString(I18n.func_135052_a((String)this.tile.func_70005_c_(), (Object[])new Object[0])).func_150260_c(), basePointX + 8, basePointY + 8, 0x404040);
        this.field_146289_q.func_78276_b(EnumParticleTypes.func_179342_a((int)(this.currentShownParticles + 0)).name(), basePointX + 9, basePointY + 19 + 0, 0xFFFFFF);
        this.field_146289_q.func_78276_b(EnumParticleTypes.func_179342_a((int)(this.currentShownParticles + 1)).name(), basePointX + 9, basePointY + 19 + 10, 0xFFFFFF);
        this.field_146289_q.func_78276_b(EnumParticleTypes.func_179342_a((int)(this.currentShownParticles + 2)).name(), basePointX + 9, basePointY + 19 + 20, 0xFFFFFF);
        this.field_146289_q.func_78276_b(EnumParticleTypes.func_179342_a((int)(this.currentShownParticles + 3)).name(), basePointX + 9, basePointY + 19 + 30, 0xFFFFFF);
        this.field_146289_q.func_78276_b(EnumParticleTypes.func_179342_a((int)(this.currentShownParticles + 4)).name(), basePointX + 9, basePointY + 19 + 40, 0xFFFFFF);
        this.positionX.func_146194_f();
        this.positionY.func_146194_f();
        this.positionZ.func_146194_f();
        this.field_146289_q.func_78276_b("X:", basePointX + 13, basePointY + 73, 0x404040);
        this.field_146289_q.func_78276_b("Y:", basePointX + 13, basePointY + 89, 0x404040);
        this.field_146289_q.func_78276_b("Z:", basePointX + 13, basePointY + 105, 0x404040);
        this.argument1.func_146184_c(EnumParticleTypes.func_179342_a((int)this.chosedParticle).func_179345_d() > 0);
        this.argument2.func_146184_c(EnumParticleTypes.func_179342_a((int)this.chosedParticle).func_179345_d() > 0);
        this.argument1.func_146194_f();
        this.argument2.func_146194_f();
        this.field_146289_q.func_78276_b(new TextComponentString(I18n.func_135052_a((String)"container.particlegenerator.arguments", (Object[])new Object[0])).func_150260_c() + ":", basePointX + 69, basePointY + 73, 0x404040);
        this.field_146289_q.func_78276_b("\u00ef\u00bf\u00bd1:", basePointX + 69, basePointY + 89, 0x404040);
        this.field_146289_q.func_78276_b("\u00ef\u00bf\u00bd2:", basePointX + 69, basePointY + 105, 0x404040);
        this.movementX.func_146194_f();
        this.movementY.func_146194_f();
        this.movementZ.func_146194_f();
        this.field_146289_q.func_78276_b("vX:", basePointX + 7, basePointY + 121, 0x404040);
        this.field_146289_q.func_78276_b("vY:", basePointX + 7, basePointY + 137, 0x404040);
        this.field_146289_q.func_78276_b("vZ:", basePointX + 7, basePointY + 153, 0x404040);
        float r = Float.valueOf(this.movementX.func_146179_b().isEmpty() ? "0" : this.movementX.func_146179_b()).floatValue();
        float g = Float.valueOf(this.movementY.func_146179_b().isEmpty() ? "0" : this.movementY.func_146179_b()).floatValue();
        float b = Float.valueOf(this.movementZ.func_146179_b().isEmpty() ? "0" : this.movementZ.func_146179_b()).floatValue();
        Color col = new Color(Math.max(0.0f, Math.min(1.0f, r)), Math.max(0.0f, Math.min(1.0f, g)), Math.max(0.0f, Math.min(1.0f, b)));
        GuiParticleGenerator.func_73734_a((int)(basePointX + 68), (int)(basePointY + 119), (int)(basePointX + 73), (int)(basePointY + 163), (int)col.getRGB());
        boolean isIDValid = true;
        if (!this.argument1.func_146179_b().isEmpty()) {
            isIDValid = this.chosedParticle == EnumParticleTypes.ITEM_CRACK.func_179348_c() ? Item.func_111206_d((String)this.argument1.func_146179_b()) != null : Block.func_149684_b((String)this.argument1.func_146179_b()) != null;
        }
        boolean bl = isIDValid = EnumParticleTypes.func_179342_a((int)this.chosedParticle).func_179345_d() > 0 ? isIDValid : true;
        if (!isIDValid) {
            this.field_146289_q.func_78276_b("!", basePointX + 167, basePointY + 89, 0xFF0000);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (PGenMath.isInRange(mouseX, mouseY, basePointX + 162, basePointX + 173, basePointY + 86, basePointY + 101)) {
            list = Lists.newArrayList();
            if (this.argument1.func_146179_b().isEmpty() && EnumParticleTypes.func_179342_a((int)this.chosedParticle).func_179345_d() > 0) {
                list.add(TextFormatting.GOLD + new TextComponentString(I18n.func_135052_a((String)"container.particlegenerator.tip1_1.line1", (Object[])new Object[0])).func_150260_c());
                list.add(TextFormatting.GOLD + new TextComponentString(I18n.func_135052_a((String)"container.particlegenerator.tip1_1.line2", (Object[])new Object[0])).func_150260_c());
            } else if (!isIDValid) {
                list.add(TextFormatting.RED + this.argument1.func_146179_b());
                list.add(TextFormatting.GOLD + new TextComponentString(I18n.func_135052_a((String)"container.particlegenerator.tip1_2.line1", (Object[])new Object[0])).func_150260_c());
            }
            this.func_146283_a(list, mouseX, mouseY);
        }
        if (PGenMath.isInRange(mouseX, mouseY, basePointX + 66, basePointX + 74, basePointY + 117, basePointY + 165)) {
            list = Lists.newArrayList();
            list.add(TextFormatting.WHITE + new TextComponentString(I18n.func_135052_a((String)"container.particlegenerator.tip2.line1", (Object[])new Object[0])).func_150260_c());
            list.add(TextFormatting.GRAY + new TextComponentString(I18n.func_135052_a((String)"container.particlegenerator.tip2.line2", (Object[])new Object[0])).func_150260_c());
            list.add(TextFormatting.GRAY + new TextComponentString(I18n.func_135052_a((String)"container.particlegenerator.tip2.line3", (Object[])new Object[0])).func_150260_c());
            list.add(TextFormatting.GRAY + new TextComponentString(I18n.func_135052_a((String)"container.particlegenerator.tip2.line4", (Object[])new Object[0])).func_150260_c());
            list.add(TextFormatting.GRAY + new TextComponentString(I18n.func_135052_a((String)"container.particlegenerator.tip2.line5", (Object[])new Object[0])).func_150260_c());
            this.func_146283_a(list, mouseX, mouseY);
        }
        if (PGenMath.isInRange(mouseX, mouseY, basePointX + 69, basePointX + 163, basePointY + 86, basePointY + 101) && EnumParticleTypes.func_179342_a((int)this.chosedParticle).func_179345_d() > 0) {
            list = Lists.newArrayList();
            if (this.chosedParticle == EnumParticleTypes.ITEM_CRACK.func_179348_c()) {
                list.add(TextFormatting.WHITE + new TextComponentString(I18n.func_135052_a((String)"container.particlegenerator.tip3_1.line1", (Object[])new Object[0])).func_150260_c());
                list.add(TextFormatting.GRAY + new TextComponentString(I18n.func_135052_a((String)"container.particlegenerator.example", (Object[])new Object[0])).func_150260_c());
                list.add(TextFormatting.DARK_GRAY + "minecraft:iron_axe");
            } else {
                list.add(TextFormatting.WHITE + new TextComponentString(I18n.func_135052_a((String)"container.particlegenerator.tip3_2.line1", (Object[])new Object[0])).func_150260_c());
                list.add(TextFormatting.GRAY + new TextComponentString(I18n.func_135052_a((String)"container.particlegenerator.example", (Object[])new Object[0])).func_150260_c());
                list.add(TextFormatting.DARK_GRAY + "minecraft:planks");
            }
            this.func_146283_a(list, mouseX, mouseY);
        }
        if (PGenMath.isInRange(mouseX, mouseY, basePointX + 69, basePointX + 163, basePointY + 102, basePointY + 117) && EnumParticleTypes.func_179342_a((int)this.chosedParticle).func_179345_d() > 0) {
            list = Lists.newArrayList();
            if (this.chosedParticle == EnumParticleTypes.ITEM_CRACK.func_179348_c()) {
                list.add(TextFormatting.WHITE + new TextComponentString(I18n.func_135052_a((String)"container.particlegenerator.tip4_1.line1", (Object[])new Object[0])).func_150260_c());
                list.add(TextFormatting.GRAY + new TextComponentString(I18n.func_135052_a((String)"container.particlegenerator.example", (Object[])new Object[0])).func_150260_c());
                list.add(TextFormatting.DARK_GRAY + "4");
            } else {
                list.add(TextFormatting.WHITE + new TextComponentString(I18n.func_135052_a((String)"container.particlegenerator.tip4_2.line1", (Object[])new Object[0])).func_150260_c());
                list.add(TextFormatting.GRAY + new TextComponentString(I18n.func_135052_a((String)"container.particlegenerator.example", (Object[])new Object[0])).func_150260_c());
                list.add(TextFormatting.DARK_GRAY + "4");
            }
            this.func_146283_a(list, mouseX, mouseY);
        }
        for (int i = 0; i < 5; ++i) {
            if (!PGenMath.isInRange(mouseX, mouseY, basePointX + 7, basePointX + 156, basePointY + 16 + i * 10, basePointY + 27 + i * 10) || EnumParticleTypes.func_179342_a((int)(this.currentShownParticles + i)).func_179345_d() <= 0) continue;
            ArrayList list2 = Lists.newArrayList();
            list2.add(TextFormatting.WHITE + EnumParticleTypes.func_179342_a((int)(this.currentShownParticles + i)).name());
            list2.add(TextFormatting.GOLD + new TextComponentString(I18n.func_135052_a((String)"container.particlegenerator.tip5.line1", (Object[])new Object[0])).func_150260_c());
            list2.add(TextFormatting.GRAY + new TextComponentString(I18n.func_135052_a((String)"container.particlegenerator.tip5.line2", (Object[])new Object[0])).func_150260_c());
            this.func_146283_a(list2, mouseX, mouseY);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        int basePointX = this.field_146294_l / 2 - this.textureWidth / 2;
        int basePointY = this.field_146295_m / 2 - this.textureHeight / 2;
        this.positionX.func_146192_a(mouseX, mouseY, mouseButton);
        this.positionY.func_146192_a(mouseX, mouseY, mouseButton);
        this.positionZ.func_146192_a(mouseX, mouseY, mouseButton);
        this.argument1.func_146192_a(mouseX, mouseY, mouseButton);
        this.argument2.func_146192_a(mouseX, mouseY, mouseButton);
        this.movementX.func_146192_a(mouseX, mouseY, mouseButton);
        this.movementY.func_146192_a(mouseX, mouseY, mouseButton);
        this.movementZ.func_146192_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            if (mouseX > basePointX + 156 && mouseX < basePointX + 168 && mouseY > basePointY + 18 && mouseY < basePointY + 25 && this.currentShownParticles > 0) {
                --this.currentShownParticles;
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            }
            if (mouseX > basePointX + 156 && mouseX < basePointX + 168 && mouseY > basePointY + 58 && mouseY < basePointY + 66 && this.currentShownParticles < 42) {
                ++this.currentShownParticles;
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            }
            if (mouseX > basePointX + 156 && mouseX < basePointX + 168 && mouseY > basePointY + 26 && mouseY < basePointY + 57) {
                int position = mouseY - (basePointY + 27);
                float percentaje = (float)position / 29.0f;
                this.currentShownParticles = (int)Math.floor(42.0f * percentaje);
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            }
            for (int i = 0; i < 5; ++i) {
                if (!PGenMath.isInRange(mouseX, mouseY, basePointX + 7, basePointX + 156, basePointY + 17 + i * 10, basePointY + 27 + i * 10)) continue;
                this.chosedParticle = this.currentShownParticles + i;
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            }
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        int basePointX = this.field_146294_l / 2 - this.textureWidth / 2;
        int basePointY = this.field_146295_m / 2 - this.textureHeight / 2;
        if (clickedMouseButton == 0 && mouseX > basePointX + 156 && mouseX < basePointX + 168 && mouseY > basePointY + 26 && mouseY < basePointY + 57) {
            int position = mouseY - (basePointY + 27);
            float percentaje = (float)position / 29.0f;
            this.currentShownParticles = (int)Math.floor(42.0f * percentaje);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int rotation = Mouse.getEventDWheel();
        int mouseX = this.field_146294_l - Mouse.getX();
        int mouseY = this.field_146295_m - Mouse.getY();
        int basePointX = this.field_146294_l / 2 - this.textureWidth / 2;
        int basePointY = this.field_146295_m / 2 - this.textureHeight / 2;
        int movement = rotation / 120;
        this.currentShownParticles = movement > 0 ? Math.max(0, this.currentShownParticles - movement) : Math.min(42, this.currentShownParticles - movement);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.argument1.func_146201_a(typedChar, keyCode);
        this.argument2.func_146201_a(typedChar, keyCode);
        if (Character.isDigit(typedChar) || Character.isISOControl(typedChar) || typedChar == '.' || typedChar == '-' || typedChar == '+' || typedChar == '~') {
            this.positionX.func_146201_a(typedChar, keyCode);
            this.positionY.func_146201_a(typedChar, keyCode);
            this.positionZ.func_146201_a(typedChar, keyCode);
            this.movementX.func_146201_a(typedChar, keyCode);
            this.movementY.func_146201_a(typedChar, keyCode);
            this.movementZ.func_146201_a(typedChar, keyCode);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button == this.doneButton) {
            int particleID = this.chosedParticle;
            float x = Float.valueOf(this.positionX.func_146179_b().isEmpty() ? "0" : this.positionX.func_146179_b()).floatValue();
            float y = Float.valueOf(this.positionY.func_146179_b().isEmpty() ? "0" : this.positionY.func_146179_b()).floatValue();
            float z = Float.valueOf(this.positionZ.func_146179_b().isEmpty() ? "0" : this.positionZ.func_146179_b()).floatValue();
            float vX = Float.valueOf(this.movementX.func_146179_b().isEmpty() ? "0" : this.movementX.func_146179_b()).floatValue();
            float vY = Float.valueOf(this.movementY.func_146179_b().isEmpty() ? "0" : this.movementY.func_146179_b()).floatValue();
            float vZ = Float.valueOf(this.movementZ.func_146179_b().isEmpty() ? "0" : this.movementZ.func_146179_b()).floatValue();
            int arg1ID = 0;
            boolean isIDValid = true;
            if (!this.argument1.func_146179_b().isEmpty()) {
                if (this.chosedParticle == EnumParticleTypes.ITEM_CRACK.func_179348_c()) {
                    isIDValid = Item.func_111206_d((String)this.argument1.func_146179_b()) != null;
                } else {
                    boolean bl = isIDValid = Block.func_149684_b((String)this.argument1.func_146179_b()) != null;
                }
            }
            if (!this.argument1.func_146179_b().isEmpty() && isIDValid) {
                arg1ID = this.chosedParticle == EnumParticleTypes.ITEM_CRACK.func_179348_c() ? Item.func_150891_b((Item)Item.func_111206_d((String)this.argument1.func_146179_b())) : Block.func_149682_b((Block)Block.func_149684_b((String)this.argument1.func_146179_b()));
            }
            int arg2Metadata = Integer.valueOf(this.argument2.func_146179_b().isEmpty() ? "0" : this.argument2.func_146179_b());
            PGenPacketHandler.INSTANCE.sendToServer((IMessage)new ParticleGeneratorMessage(this.tile.func_174877_v(), particleID, x, y, z, vX, vY, vZ, arg1ID, arg2Metadata));
            this.tile.particleID = particleID;
            this.tile.x = x;
            this.tile.y = y;
            this.tile.z = z;
            this.tile.vX = vX;
            this.tile.vY = vY;
            this.tile.vZ = vZ;
            this.tile.arg1ID = arg1ID;
            this.tile.arg2Metadata = arg2Metadata;
            this.field_146297_k.func_147108_a(null);
            if (this.field_146297_k.field_71462_r == null) {
                this.field_146297_k.func_71381_h();
            }
        } else if (button == this.cancelButton) {
            this.field_146297_k.func_147108_a(null);
            if (this.field_146297_k.field_71462_r == null) {
                this.field_146297_k.func_71381_h();
            }
        }
    }
}

