/*
 * Decompiled with CFR 0.152.
 */
package com.criticalpickle.criticalcrates.block;

import com.criticalpickle.criticalcrates.Config;
import com.criticalpickle.criticalcrates.block.entity.CrateBlockEntity;
import com.criticalpickle.criticalcrates.registration.ModBlocks;
import com.criticalpickle.criticalcrates.registration.ModItems;
import com.criticalpickle.criticalcrates.util.DataComponentUtils;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrateBlock
extends BaseEntityBlock {
    public static final MapCodec<CrateBlock> CODEC = CrateBlock.simpleCodec(CrateBlock::new);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    public static final BooleanProperty EXPLOSION_RESIST = BooleanProperty.create((String)"explosion_resistant");
    public static final BooleanProperty LAMP_UPGRADE = BooleanProperty.create((String)"lamp_upgrade");
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty FIREPROOF = BooleanProperty.create((String)"fireproof");

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public CrateBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)Direction.Axis.Y)).setValue((Property)EXPLOSION_RESIST, (Comparable)Boolean.valueOf(false))).setValue((Property)LAMP_UPGRADE, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)FIREPROOF, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS, EXPLOSION_RESIST, LAMP_UPGRADE, LIT, POWERED, FIREPROOF});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction.Axis axis = context.getClickedFace().getAxis();
        CustomData data = (CustomData)context.getItemInHand().get(DataComponents.CUSTOM_DATA);
        boolean resistant = false;
        boolean lamp = false;
        boolean fire = false;
        if (data != null) {
            if (data.contains("explosion_resistant")) {
                resistant = data.copyTag().getBoolean("explosion_resistant");
            }
            if (data.contains("lamp_upgrade")) {
                lamp = data.copyTag().getBoolean("lamp_upgrade");
            }
            if (data.contains("fireproof")) {
                fire = data.copyTag().getBoolean("fireproof");
            }
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)axis)).setValue((Property)EXPLOSION_RESIST, (Comparable)Boolean.valueOf(resistant))).setValue((Property)LAMP_UPGRADE, (Comparable)Boolean.valueOf(lamp))).setValue((Property)FIREPROOF, (Comparable)Boolean.valueOf(fire));
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.hasFireEffect(state);
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.hasFireEffect(state) ? 5 : 0;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.hasFireEffect(state) ? 20 : 0;
    }

    protected boolean hasFireEffect(BlockState state) {
        return !state.is((Block)ModBlocks.CRIMSON_CRATE.get()) && !state.is((Block)ModBlocks.WARPED_CRATE.get()) && (Boolean)state.getValue((Property)FIREPROOF) == false;
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return (Boolean)state.getValue((Property)EXPLOSION_RESIST) != false ? 1200.0f : 2.5f;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)LIT) != false ? 15 : 0;
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return (Boolean)state.getValue((Property)LAMP_UPGRADE);
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return (Boolean)level.getBlockState(pos).getValue((Property)LIT) != false ? 15 : 0;
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return CrateBlock.rotatePillar(state, rotation);
    }

    public static BlockState rotatePillar(BlockState state, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.getValue(AXIS)) {
                    case X: {
                        return (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
                    }
                    case Z: {
                        return (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new CrateBlockEntity(blockPos, blockState);
    }

    @NotNull
    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        if (((Boolean)state.getValue((Property)LAMP_UPGRADE)).booleanValue() && oldState.getBlock() != state.getBlock() && level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            this.checkAndFlip(state, serverlevel, pos);
        }
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (((Boolean)state.getValue((Property)LAMP_UPGRADE)).booleanValue() && level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            this.checkAndFlip(state, serverlevel, pos);
        }
    }

    public void checkAndFlip(BlockState state, ServerLevel level, BlockPos pos) {
        boolean isPowered = level.hasNeighborSignal(pos);
        if (isPowered != (Boolean)state.getValue((Property)POWERED)) {
            BlockState blockstate = state;
            if (!((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
                blockstate = (BlockState)state.cycle((Property)LIT);
            }
            level.setBlockAndUpdate(pos, (BlockState)blockstate.setValue((Property)POWERED, (Comparable)Boolean.valueOf(isPowered)));
        }
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof CrateBlockEntity) {
            CrateBlockEntity blockEntity2 = (CrateBlockEntity)blockEntity;
            blockEntity2.drop();
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack stack = new ItemStack((ItemLike)this);
        CompoundTag dataTag = new CompoundTag();
        dataTag.putBoolean("explosion_resistant", ((Boolean)state.getValue((Property)EXPLOSION_RESIST)).booleanValue());
        dataTag.putBoolean("lamp_upgrade", ((Boolean)state.getValue((Property)LAMP_UPGRADE)).booleanValue());
        dataTag.putBoolean("fireproof", ((Boolean)state.getValue((Property)FIREPROOF)).booleanValue());
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)dataTag));
        if (dataTag.getBoolean("fireproof")) {
            stack.set(DataComponents.FIRE_RESISTANT, (Object)Unit.INSTANCE);
        }
        return stack;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CrateBlockEntity) {
            CrateBlockEntity blockEntity2 = (CrateBlockEntity)blockEntity;
            player.openMenu((MenuProvider)new SimpleMenuProvider((MenuConstructor)blockEntity2, (Component)Component.literal((String)"Crate")), pos);
            level.playSound(null, pos, this.getInventoryOpenSound(), SoundSource.BLOCKS, 0.5f, 1.0f);
        }
        return InteractionResult.CONSUME;
    }

    protected SoundEvent getInventoryOpenSound() {
        return SoundEvents.BARREL_OPEN;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            Item itemInStack = stack.getItem();
            CompoundTag dataTag = new CompoundTag();
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (Config.ADDONS_REMOVABLE.getAsBoolean() && CrateBlock.hasUpgrades(state) && itemInStack == ModItems.PLIERS_ITEM.get()) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)EXPLOSION_RESIST, (Comparable)Boolean.valueOf(false))).setValue((Property)LAMP_UPGRADE, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)FIREPROOF, (Comparable)Boolean.valueOf(false)));
                CrateBlock.spawnRemovedUpgrades(state, level, pos);
                dataTag.putBoolean("explosion_resistant", false);
                dataTag.putBoolean("lamp_upgrade", false);
                dataTag.putBoolean("fireproof", false);
            } else if (!CrateBlock.hasUpgrades(state) && itemInStack == ModItems.OBSIDIAN_REINFORCEMENT_ITEM.get()) {
                stack.shrink(1);
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)EXPLOSION_RESIST, (Comparable)Boolean.valueOf(true)));
                dataTag.putBoolean("explosion_resistant", true);
                dataTag.putBoolean("lamp_upgrade", false);
                dataTag.putBoolean("fireproof", false);
            } else if (!CrateBlock.hasUpgrades(state) && itemInStack == ModItems.LAMP_SIMULATOR_ITEM.get()) {
                stack.shrink(1);
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LAMP_UPGRADE, (Comparable)Boolean.valueOf(true)));
                dataTag.putBoolean("explosion_resistant", false);
                dataTag.putBoolean("lamp_upgrade", true);
                dataTag.putBoolean("fireproof", false);
            } else if (!CrateBlock.hasUpgrades(state) && itemInStack == ModItems.FIREPROOFING_ITEM.get()) {
                stack.shrink(1);
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)FIREPROOF, (Comparable)Boolean.valueOf(true)));
                dataTag.putBoolean("explosion_resistant", false);
                dataTag.putBoolean("lamp_upgrade", false);
                dataTag.putBoolean("fireproof", true);
                if (blockEntity != null) {
                    DataComponentUtils.addBlockEntityDataComponents(blockEntity, dataTag, (DataComponentType<Unit>)DataComponents.FIRE_RESISTANT);
                }
            } else {
                return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
            }
            if (blockEntity != null && !dataTag.getBoolean("fireproof")) {
                DataComponentUtils.addBlockEntityDataTag(blockEntity, dataTag);
            }
            CrateBlock.playUpgradeSounds(level, pos, stack, player);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    private static void spawnRemovedUpgrades(BlockState state, Level level, BlockPos pos) {
        if (((Boolean)state.getValue((Property)EXPLOSION_RESIST)).booleanValue()) {
            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), new ItemStack((ItemLike)ModItems.OBSIDIAN_REINFORCEMENT_ITEM.get())));
        } else if (((Boolean)state.getValue((Property)LAMP_UPGRADE)).booleanValue()) {
            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), new ItemStack((ItemLike)ModItems.LAMP_SIMULATOR_ITEM.get())));
        } else if (((Boolean)state.getValue((Property)FIREPROOF)).booleanValue()) {
            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), new ItemStack((ItemLike)ModItems.FIREPROOFING_ITEM.get())));
        }
    }

    private static boolean hasUpgrades(BlockState state) {
        return (Boolean)state.getValue((Property)EXPLOSION_RESIST) != false || (Boolean)state.getValue((Property)LAMP_UPGRADE) != false || (Boolean)state.getValue((Property)FIREPROOF) != false;
    }

    private static void playUpgradeSounds(Level level, BlockPos pos, ItemStack stack, Player player) {
        if (stack.getItem() != ModItems.PLIERS_ITEM.get()) {
            level.playSound(null, pos, SoundEvents.ANVIL_USE, SoundSource.BLOCKS, 0.5f, 1.0f);
        } else {
            if (!player.isCreative()) {
                stack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(stack));
            }
            if (stack.getDamageValue() < stack.getMaxDamage()) {
                level.playSound(null, pos, SoundEvents.BEEHIVE_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }
}

