/*
 * Decompiled with CFR 0.152.
 */
package com.criticalpickle.criticalcrates.mixin;

import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CraftingMenu.class})
public class CraftingMenuMixin {
    @Shadow
    private Player player;

    @Inject(method={"removed"}, at={@At(value="HEAD")})
    private void onRemoved(Player player, CallbackInfo ci) {
        CompoundTag dataTag;
        ItemStack stack;
        int i;
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (!(abstractContainerMenu instanceof CraftingMenu)) {
            return;
        }
        CraftingMenu craftingMenu = (CraftingMenu)abstractContainerMenu;
        Inventory inventory = player.getInventory();
        for (i = 0; i < inventory.getContainerSize(); ++i) {
            stack = inventory.getItem(i);
            if (stack.get(DataComponents.CUSTOM_DATA) == null) continue;
            dataTag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag();
            if (((CustomData)stack.get(DataComponents.CUSTOM_DATA)).contains("crafting_item")) {
                dataTag.remove("crafting_item");
            }
            if (((CustomData)stack.get(DataComponents.CUSTOM_DATA)).contains("player_crafting")) {
                dataTag.remove("player_crafting");
            }
            if (!dataTag.isEmpty()) {
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)dataTag));
                continue;
            }
            stack.remove(DataComponents.CUSTOM_DATA);
        }
        for (i = 1; i <= 9; ++i) {
            stack = craftingMenu.getSlot(i).getItem();
            if (stack.get(DataComponents.CUSTOM_DATA) == null) continue;
            dataTag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag();
            if (((CustomData)stack.get(DataComponents.CUSTOM_DATA)).contains("crafting_item")) {
                dataTag.remove("crafting_item");
            }
            if (((CustomData)stack.get(DataComponents.CUSTOM_DATA)).contains("player_crafting")) {
                dataTag.remove("player_crafting");
            }
            if (!dataTag.isEmpty()) {
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)dataTag));
                continue;
            }
            stack.remove(DataComponents.CUSTOM_DATA);
        }
    }

    @Inject(method={"slotsChanged"}, at={@At(value="RETURN")})
    private void onSlotsChanged(CallbackInfo ci) {
        CustomData data;
        String stackItemID;
        ItemStack stack;
        int i;
        Inventory inventory = this.player.getInventory();
        CraftingMenu craftingMenu = (CraftingMenu)this.player.containerMenu;
        for (i = 1; i <= 9; ++i) {
            stack = craftingMenu.getSlot(i).getItem();
            stackItemID = stack.getItem().getDescriptionId();
            data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
            if (stack.isEmpty() || !stackItemID.contains("criticalcrates") || !stackItemID.contains("crate") || data == null || data.contains("crafting_item") || data.contains("player_crafting")) continue;
            CompoundTag dataTag = data.copyTag();
            dataTag.putBoolean("player_crafting", true);
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)dataTag));
            break;
        }
        for (i = 0; i < inventory.getContainerSize(); ++i) {
            stack = inventory.getItem(i);
            stackItemID = stack.getItem().getDescriptionId();
            data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
            if (this.player.level().isClientSide() || stack.isEmpty() || !stackItemID.contains("criticalcrates") || !stackItemID.contains("crate") || data == null || !data.contains("crafting_item") && !data.contains("player_crafting")) continue;
            inventory.setItem(i, ItemStack.EMPTY);
        }
    }
}

