/*
 * Decompiled with CFR 0.152.
 */
package com.criticalpickle.criticalcrates.util;

import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class PlayerInventoryUtils {
    public static ItemStack getStackWithItemID(String itemID, Inventory inventory) {
        ItemStack validStack = ItemStack.EMPTY;
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty() || !stack.getItem().getDescriptionId().equals(itemID) || stack.get(DataComponents.CUSTOM_DATA) == null || ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).contains("crafting_item") || ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).contains("player_crafting")) continue;
            validStack = stack;
            break;
        }
        return validStack;
    }

    public static ItemStack getStackWithIDAndTag(String itemID, CompoundTag dataTag, Inventory inventory) {
        ItemStack validStack = ItemStack.EMPTY;
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            CompoundTag foundTag;
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty() || stack.get(DataComponents.CUSTOM_DATA) == null || dataTag != (foundTag = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag()) || !stack.getItem().getDescriptionId().equals(itemID)) continue;
            validStack = stack;
            break;
        }
        return validStack;
    }

    public static ItemStack getStackWithIDListAndTag(List<String> list, Inventory inventory) {
        ItemStack validItem = ItemStack.EMPTY;
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty() || !list.contains(stack.getItem().getDescriptionId()) || stack.get(DataComponents.CUSTOM_DATA) == null || ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).contains("crafting_item") || ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).contains("player_crafting")) continue;
            validItem = stack;
            break;
        }
        return validItem;
    }

    public static int getFirstEmptySlot(Inventory inventory) {
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            if (!inventory.getItem(i).isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public static int getItemAmount(Item item, Inventory inventory) {
        int itemCount = 0;
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty() || stack.getItem() != item) continue;
            itemCount += stack.getCount();
        }
        return itemCount;
    }

    public static int removeStacksOfID(int countToRemove, String ID, Inventory inventory) {
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty() || !stack.getItem().getDescriptionId().equals(ID) || stack.get(DataComponents.CUSTOM_DATA) == null || ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).contains("crafting_item") || ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).contains("player_crafting")) continue;
            if (stack.getCount() <= countToRemove) {
                int removed = stack.getCount();
                stack.shrink(removed);
                countToRemove -= removed;
            } else {
                stack.shrink(countToRemove);
                countToRemove = 0;
            }
            if (countToRemove > 0) continue;
            return 0;
        }
        return countToRemove;
    }
}

