/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.sarosinteractiveblocks;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BlockActionListener {
    private static BlockPos lastBlockPos = null;

    @SubscribeEvent
    public static void onBlockLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        if (!event.getLevel().isClientSide()) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            BlockPos pos = event.getPos();
            ServerLevel world = (ServerLevel)event.getLevel();
            Commands commands = world.getServer().getCommands();
            File blockFile = new File(world.getServer().getWorldPath(LevelResource.ROOT).toFile(), "BlockActions/" + pos.getX() + "_" + pos.getY() + "_" + pos.getZ() + ".txt");
            if (blockFile.exists()) {
                try {
                    List<String> lines = Files.readAllLines(blockFile.toPath(), StandardCharsets.UTF_8);
                    for (String line : lines) {
                        if (!line.contains("Action: L") || player.isShiftKeyDown()) continue;
                        String command = line.substring(line.indexOf("Command: ") + 9).trim();
                        if (command.startsWith("/")) {
                            command = command.substring(1);
                            command = command.replace("<player>", player.getName().getString());
                        }
                        ParseResults parseResults = commands.getDispatcher().parse(new StringReader(command), (Object)player.createCommandSourceStack());
                        if (line.contains("Side: C")) {
                            commands.performCommand(parseResults, command);
                        } else if (line.contains("Side: S")) {
                            ParseResults serverParseResults = commands.getDispatcher().parse(new StringReader(command), (Object)world.getServer().createCommandSourceStack());
                            commands.performCommand(serverParseResults, command);
                        }
                        event.setCancellationResult((InteractionResult)InteractionResult.FAIL);
                        return;
                    }
                }
                catch (Exception e) {
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!event.getLevel().isClientSide()) {
            ServerPlayer player = (ServerPlayer)event.getPlayer();
            BlockPos pos = event.getPos();
            ServerLevel world = (ServerLevel)event.getLevel();
            File blockFile = new File(world.getServer().getWorldPath(LevelResource.ROOT).toFile(), "BlockActions/" + pos.getX() + "_" + pos.getY() + "_" + pos.getZ() + ".txt");
            if (blockFile.exists() && blockFile.delete()) {
                player.sendSystemMessage((Component)Component.literal((String)"File successfully deleted.").withStyle(ChatFormatting.RED));
            }
        }
    }

    @SubscribeEvent
    public static void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getLevel().isClientSide()) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            BlockPos pos = event.getPos();
            ServerLevel world = (ServerLevel)event.getLevel();
            Commands commands = world.getServer().getCommands();
            File blockFile = new File(world.getServer().getWorldPath(LevelResource.ROOT).toFile(), "BlockActions/" + pos.getX() + "_" + pos.getY() + "_" + pos.getZ() + ".txt");
            if (blockFile.exists()) {
                try {
                    List<String> lines = Files.readAllLines(blockFile.toPath(), StandardCharsets.UTF_8);
                    for (String line : lines) {
                        if (!line.contains("Action: R")) continue;
                        String command = line.substring(line.indexOf("Command: ") + 9).trim();
                        if (command.startsWith("/")) {
                            command = command.substring(1);
                            command = command.replace("<player>", player.getName().getString());
                        }
                        ParseResults parseResults = commands.getDispatcher().parse(new StringReader(command), (Object)player.createCommandSourceStack());
                        if (line.contains("Side: C")) {
                            commands.performCommand(parseResults, command);
                            continue;
                        }
                        if (!line.contains("Side: S")) continue;
                        ParseResults serverParseResults = commands.getDispatcher().parse(new StringReader(command), (Object)world.getServer().createCommandSourceStack());
                        commands.performCommand(serverParseResults, command);
                    }
                }
                catch (Exception e) {
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (!player.level().isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockPos currentBlockPos = new BlockPos((int)Math.floor(player.getX()), (int)Math.floor(player.getY() - 1.0), (int)Math.floor(player.getZ()));
            if (serverPlayer.onGround()) {
                if (lastBlockPos == null || !currentBlockPos.equals((Object)lastBlockPos)) {
                    BlockPos pos = currentBlockPos;
                    ServerLevel world = serverPlayer.level();
                    Commands commands = world.getServer().getCommands();
                    File blockFile = new File(world.getServer().getWorldPath(LevelResource.ROOT).toFile(), "BlockActions/" + pos.getX() + "_" + pos.getY() + "_" + pos.getZ() + ".txt");
                    if (blockFile.exists()) {
                        try {
                            List<String> lines = Files.readAllLines(blockFile.toPath(), StandardCharsets.UTF_8);
                            for (String line : lines) {
                                if (!line.contains("Action: T")) continue;
                                String command = line.substring(line.indexOf("Command: ") + 9).trim();
                                if (command.startsWith("/")) {
                                    command = command.substring(1);
                                    command = command.replace("<player>", player.getName().getString());
                                }
                                ParseResults parseResults = commands.getDispatcher().parse(new StringReader(command), (Object)((ServerPlayer)player).createCommandSourceStack());
                                if (line.contains("Side: C")) {
                                    commands.performCommand(parseResults, command);
                                    continue;
                                }
                                if (!line.contains("Side: S")) continue;
                                ParseResults serverParseResults = commands.getDispatcher().parse(new StringReader(command), (Object)world.getServer().createCommandSourceStack());
                                commands.performCommand(serverParseResults, command);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return;
                        }
                    }
                    lastBlockPos = currentBlockPos;
                }
            } else {
                lastBlockPos = null;
            }
        }
    }

    @SubscribeEvent
    public static void onNeighborNotify(BlockEvent.NeighborNotifyEvent event) {
        File blockFile;
        BlockPos pos;
        ServerLevel world;
        if (!event.getLevel().isClientSide() && (world = (ServerLevel)event.getLevel()).hasNeighborSignal(pos = event.getPos()) && (blockFile = new File(world.getServer().getWorldPath(LevelResource.ROOT).toFile(), "BlockActions/" + pos.getX() + "_" + pos.getY() + "_" + pos.getZ() + ".txt")).exists()) {
            try {
                List<String> lines = Files.readAllLines(blockFile.toPath(), StandardCharsets.UTF_8);
                for (String line : lines) {
                    if (!line.contains("Action: S")) continue;
                    String command = line.substring(line.indexOf("Command: ") + 9).trim();
                    if (command.startsWith("/")) {
                        command = command.substring(1);
                    }
                    CommandDispatcher dispatcher = world.getServer().getCommands().getDispatcher();
                    CommandSourceStack sourceStack = world.getServer().createCommandSourceStack();
                    ParseResults parsedCommand = dispatcher.parse(command, (Object)sourceStack);
                    dispatcher.execute(parsedCommand);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

