/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.compat.jei;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.packets.PacketGhostSlot;
import de.ellpeck.prettypipes.terminal.containers.CraftingTerminalContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class CraftingTerminalTransferHandler
implements IRecipeTransferHandler<CraftingTerminalContainer, RecipeHolder<CraftingRecipe>> {
    public Class<CraftingTerminalContainer> getContainerClass() {
        return CraftingTerminalContainer.class;
    }

    public Optional<MenuType<CraftingTerminalContainer>> getMenuType() {
        return Optional.of(Registry.craftingTerminalContainer);
    }

    public RecipeType<RecipeHolder<CraftingRecipe>> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(CraftingTerminalContainer container, RecipeHolder<CraftingRecipe> recipe, IRecipeSlotsView slots, Player player, boolean maxTransfer, boolean doTransfer) {
        if (!doTransfer) {
            return null;
        }
        ArrayList<PacketGhostSlot.Entry> stacks = new ArrayList<PacketGhostSlot.Entry>();
        List ingredients = slots.getSlotViews(RecipeIngredientRole.INPUT);
        for (IRecipeSlotView entry : ingredients) {
            stacks.add(PacketGhostSlot.Entry.fromStacks(player.level(), entry.getIngredients((IIngredientType)VanillaTypes.ITEM_STACK).collect(Collectors.toList())));
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new PacketGhostSlot(container.getTile().getBlockPos(), stacks), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return null;
    }
}

