/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.misc;

import com.mojang.blaze3d.systems.RenderSystem;
import de.ellpeck.prettypipes.terminal.containers.ItemTerminalGui;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class ItemTerminalWidget
extends AbstractWidget {
    private final ItemTerminalGui screen;
    public final int gridX;
    public final int gridY;
    public boolean selected;
    public ItemStack stack = ItemStack.EMPTY;
    public boolean craftable;

    public ItemTerminalWidget(int xIn, int yIn, int gridX, int gridY, ItemTerminalGui screen) {
        super(xIn, yIn, 16, 16, (Component)Component.literal((String)""));
        this.gridX = gridX;
        this.gridY = gridY;
        this.screen = screen;
        this.visible = false;
    }

    public void onClick(double x, double y) {
        this.screen.streamWidgets().forEach(w -> {
            w.selected = false;
        });
        this.selected = true;
    }

    protected void renderWidget(GuiGraphics graphics, int p_268034_, int p_268009_, float p_268085_) {
        Minecraft mc = this.screen.getMinecraft();
        graphics.pose().translate(0.0f, 0.0f, 100.0f);
        if (this.selected) {
            graphics.fill(this.getX(), this.getY(), this.getX() + 16, this.getY() + 16, -2130706433);
        }
        RenderSystem.enableDepthTest();
        graphics.renderItem(this.stack, this.getX(), this.getY());
        String amount = ItemTerminalWidget.displayAmount(!this.craftable ? this.stack.getCount() : 0);
        graphics.renderItemDecorations(mc.font, this.stack, this.getX(), this.getY(), amount);
        graphics.pose().translate(0.0f, 0.0f, -100.0f);
        if (this.isHoveredOrFocused()) {
            RenderSystem.disableDepthTest();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            graphics.fillGradient(this.getX(), this.getY(), this.getX() + 16, this.getY() + 16, -2130706433, -2130706433);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.enableDepthTest();
        }
    }

    public void renderToolTip(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.visible && this.isHovered()) {
            Component comp;
            List tooltip = Screen.getTooltipFromItem((Minecraft)this.screen.getMinecraft(), (ItemStack)this.stack);
            if (this.stack.getCount() >= 1000 && (comp = (Component)tooltip.get(0)) instanceof MutableComponent) {
                MutableComponent m = (MutableComponent)comp;
                tooltip.set(0, m.append((Component)Component.literal((String)(" (" + this.stack.getCount() + ")")).withStyle(ChatFormatting.BOLD)));
            }
            graphics.renderTooltip(this.screen.getMinecraft().font, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    public void updateWidgetNarration(NarrationElementOutput output) {
        this.defaultButtonNarrationText(output);
    }

    private static String displayAmount(int amount) {
        if (amount >= 1000000) {
            return I18n.get((String)"info.prettypipes.million", (Object[])new Object[]{amount / 1000000});
        }
        if (amount >= 1000) {
            return I18n.get((String)"info.prettypipes.thousand", (Object[])new Object[]{amount / 1000});
        }
        return String.valueOf(amount);
    }
}

