/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.misc;

import de.ellpeck.prettypipes.items.IModule;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ModuleClearingRecipe
extends CustomRecipe {
    public static final RecipeSerializer<ModuleClearingRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(ModuleClearingRecipe::new);

    public ModuleClearingRecipe(CraftingBookCategory cat) {
        super(cat);
    }

    public boolean matches(CraftingInput container, Level level) {
        boolean foundModule = false;
        for (int i = 0; i < container.size(); ++i) {
            ItemStack stack = container.getItem(i);
            if (!foundModule && stack.getItem() instanceof IModule) {
                foundModule = true;
                continue;
            }
            if (stack.isEmpty()) continue;
            return false;
        }
        return foundModule;
    }

    public ItemStack assemble(CraftingInput container, HolderLookup.Provider pRegistries) {
        for (int i = 0; i < container.size(); ++i) {
            ItemStack stack = container.getItem(i);
            if (!(stack.getItem() instanceof IModule)) continue;
            return new ItemStack((ItemLike)stack.getItem());
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int x, int y) {
        return x >= 1 && y >= 1;
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }
}

