/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.network;

import com.mojang.blaze3d.vertex.PoseStack;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.network.NetworkEdge;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.IPipeItem;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;

public class PipeItem
implements IPipeItem {
    public static final ResourceLocation TYPE = ResourceLocation.fromNamespaceAndPath((String)"prettypipes", (String)"pipe_item");
    public ItemStack stack;
    public float speed;
    public float x;
    public float y;
    public float z;
    public float lastX;
    public float lastY;
    public float lastZ;
    protected List<BlockPos> path;
    protected BlockPos startInventory;
    protected BlockPos destInventory;
    protected BlockPos currGoalPos;
    protected int currentTile;
    protected boolean retryOnObstruction;
    protected long lastWorldTick;
    protected ResourceLocation type;

    public PipeItem(ResourceLocation type, ItemStack stack, float speed) {
        this.type = type;
        this.stack = stack;
        this.speed = speed;
    }

    public PipeItem(ItemStack stack, float speed) {
        this(TYPE, stack, speed);
    }

    public PipeItem(HolderLookup.Provider provider, ResourceLocation type, CompoundTag nbt) {
        this.type = type;
        this.path = new ArrayList<BlockPos>();
        this.deserializeNBT(provider, nbt);
    }

    @Override
    public ItemStack getContent() {
        return this.stack;
    }

    @Override
    public void setDestination(BlockPos startInventory, BlockPos destInventory, GraphPath<BlockPos, NetworkEdge> path) {
        this.startInventory = startInventory;
        this.destInventory = destInventory;
        this.path = PipeItem.compilePath(path);
        this.currGoalPos = this.getStartPipe();
        this.currentTile = 0;
        if (this.x == 0.0f && this.y == 0.0f && this.z == 0.0f) {
            this.x = Mth.lerp((float)0.5f, (float)startInventory.getX(), (float)this.currGoalPos.getX()) + 0.5f;
            this.y = Mth.lerp((float)0.5f, (float)startInventory.getY(), (float)this.currGoalPos.getY()) + 0.5f;
            this.z = Mth.lerp((float)0.5f, (float)startInventory.getZ(), (float)this.currGoalPos.getZ()) + 0.5f;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void updateInPipe(PipeBlockEntity currPipe) {
        long worldTick = currPipe.getLevel().getGameTime();
        if (this.lastWorldTick == worldTick) {
            return;
        }
        this.lastWorldTick = worldTick;
        float motionLeft = this.speed;
        while (motionLeft > 0.0f) {
            float currSpeed = Math.min(0.25f, motionLeft);
            motionLeft -= currSpeed;
            BlockPos myPos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
            if (!(myPos.equals((Object)currPipe.getBlockPos()) || !currPipe.getBlockPos().equals((Object)this.getDestPipe()) && myPos.equals((Object)this.startInventory))) {
                currPipe.getItems().remove(this);
                PipeBlockEntity next = this.getNextTile(currPipe, true);
                if (next == null) {
                    if (currPipe.getLevel().isClientSide) return;
                    if (currPipe.getBlockPos().equals((Object)this.getDestPipe())) {
                        this.stack = this.store(currPipe);
                        if (this.stack.isEmpty()) return;
                        this.onPathObstructed(currPipe, true);
                        return;
                    }
                    this.onPathObstructed(currPipe, false);
                    return;
                }
                next.getItems().add(this);
                currPipe = next;
            } else {
                double dist = this.currGoalPos.distToLowCornerSqr((double)(this.x - 0.5f), (double)(this.y - 0.5f), (double)(this.z - 0.5f));
                if (dist < (double)(currSpeed * currSpeed)) {
                    BlockPos nextPos;
                    PipeBlockEntity next = this.getNextTile(currPipe, false);
                    if (next == null || next == currPipe) {
                        if (!currPipe.getBlockPos().equals((Object)this.getDestPipe())) {
                            currPipe.getItems().remove(this);
                            if (currPipe.getLevel().isClientSide) return;
                            this.onPathObstructed(currPipe, false);
                            return;
                        }
                        nextPos = this.destInventory;
                    } else {
                        nextPos = next.getBlockPos();
                    }
                    float tolerance = 0.001f;
                    if (dist >= (double)(tolerance * tolerance)) {
                        Vec3 motion = new Vec3((double)(this.x - this.lastX), (double)(this.y - this.lastY), (double)(this.z - this.lastZ));
                        Vec3 diff = new Vec3((double)((float)nextPos.getX() + 0.5f - this.x), (double)((float)nextPos.getY() + 0.5f - this.y), (double)((float)nextPos.getZ() + 0.5f - this.z));
                        if (motion.cross(diff).length() >= (double)tolerance) {
                            currSpeed = (float)Math.sqrt(dist);
                        } else {
                            this.currGoalPos = nextPos;
                        }
                    } else {
                        this.currGoalPos = nextPos;
                    }
                }
            }
            this.lastX = this.x;
            this.lastY = this.y;
            this.lastZ = this.z;
            Vec3 dist = new Vec3((double)((float)this.currGoalPos.getX() + 0.5f - this.x), (double)((float)this.currGoalPos.getY() + 0.5f - this.y), (double)((float)this.currGoalPos.getZ() + 0.5f - this.z));
            dist = dist.normalize();
            this.x = (float)((double)this.x + dist.x * (double)currSpeed);
            this.y = (float)((double)this.y + dist.y * (double)currSpeed);
            this.z = (float)((double)this.z + dist.z * (double)currSpeed);
        }
    }

    protected void onPathObstructed(PipeBlockEntity currPipe, boolean tryReturn) {
        if (currPipe.getLevel().isClientSide) {
            return;
        }
        PipeNetwork network = PipeNetwork.get(currPipe.getLevel());
        if (tryReturn) {
            if (!this.retryOnObstruction && network.routeItemToLocation(currPipe.getBlockPos(), this.destInventory, this.getStartPipe(), this.startInventory, this.stack, speed -> this)) {
                this.retryOnObstruction = true;
                return;
            }
            ItemStack remain = network.routeItem(currPipe.getBlockPos(), this.destInventory, this.stack, (stack, speed) -> this, false);
            if (!remain.isEmpty()) {
                this.drop(currPipe.getLevel(), remain.copy());
            }
        } else {
            this.drop(currPipe.getLevel(), this.stack);
        }
    }

    @Override
    public void drop(Level world, ItemStack stack) {
        ItemEntity item = new ItemEntity(world, (double)this.x, (double)this.y, (double)this.z, stack.copy());
        item.level().addFreshEntity((Entity)item);
    }

    protected ItemStack store(PipeBlockEntity currPipe) {
        Direction dir = Utility.getDirectionFromOffset(this.destInventory, this.getDestPipe());
        return currPipe.store(this.stack, dir);
    }

    protected PipeBlockEntity getNextTile(PipeBlockEntity currPipe, boolean progress) {
        if (this.path.size() <= this.currentTile + 1) {
            return null;
        }
        BlockPos pos = this.path.get(this.currentTile + 1);
        if (progress) {
            ++this.currentTile;
        }
        PipeNetwork network = PipeNetwork.get(currPipe.getLevel());
        return network.getPipe(pos);
    }

    protected BlockPos getStartPipe() {
        return this.path.getFirst();
    }

    @Override
    public BlockPos getDestPipe() {
        return this.path.getLast();
    }

    @Override
    public BlockPos getCurrentPipe() {
        return this.path.get(this.currentTile);
    }

    @Override
    public BlockPos getDestInventory() {
        return this.destInventory;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("type", this.type.toString());
        nbt.put("stack", this.stack.save(provider));
        nbt.putFloat("speed", this.speed);
        nbt.put("start_inv", NbtUtils.writeBlockPos((BlockPos)this.startInventory));
        nbt.put("dest_inv", NbtUtils.writeBlockPos((BlockPos)this.destInventory));
        nbt.put("curr_goal", NbtUtils.writeBlockPos((BlockPos)this.currGoalPos));
        nbt.putBoolean("drop_on_obstruction", this.retryOnObstruction);
        nbt.putInt("tile", this.currentTile);
        nbt.putFloat("x", this.x);
        nbt.putFloat("y", this.y);
        nbt.putFloat("z", this.z);
        ListTag list = new ListTag();
        for (BlockPos pos : this.path) {
            list.add((Object)NbtUtils.writeBlockPos((BlockPos)pos));
        }
        nbt.put("path", (Tag)list);
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbt.getCompound("stack"));
        this.speed = nbt.getFloat("speed");
        this.startInventory = NbtUtils.readBlockPos((CompoundTag)nbt, (String)"start_inv").orElse(null);
        this.destInventory = NbtUtils.readBlockPos((CompoundTag)nbt, (String)"dest_inv").orElse(null);
        this.currGoalPos = NbtUtils.readBlockPos((CompoundTag)nbt, (String)"curr_goal").orElse(null);
        this.retryOnObstruction = nbt.getBoolean("drop_on_obstruction");
        this.currentTile = nbt.getInt("tile");
        this.x = nbt.getFloat("x");
        this.y = nbt.getFloat("y");
        this.z = nbt.getFloat("z");
        this.path.clear();
        for (Tag tag : nbt.getList("path", 11)) {
            this.path.add(Utility.readBlockPos(tag));
        }
    }

    @Override
    public int getItemsOnTheWay(BlockPos goalInv) {
        return this.stack.getCount();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(PipeBlockEntity tile, PoseStack matrixStack, Random random, float partialTicks, int light, int overlay, MultiBufferSource source) {
        matrixStack.translate(Mth.lerp((float)partialTicks, (float)this.lastX, (float)this.x), Mth.lerp((float)partialTicks, (float)this.lastY, (float)this.y), Mth.lerp((float)partialTicks, (float)this.lastZ, (float)this.z));
        if (this.stack.getItem() instanceof BlockItem) {
            scale = 0.7f;
            matrixStack.scale(scale, scale, scale);
            matrixStack.translate(0.0f, -0.2f, 0.0f);
        } else {
            scale = 0.45f;
            matrixStack.scale(scale, scale, scale);
            matrixStack.translate(0.0f, -0.1f, 0.0f);
        }
        random.setSeed(Item.getId((Item)this.stack.getItem()) + this.stack.getDamageValue());
        int amount = this.getModelCount();
        for (int i = 0; i < amount; ++i) {
            matrixStack.pushPose();
            if (amount > 1) {
                matrixStack.translate((random.nextFloat() * 2.0f - 1.0f) * 0.25f * 0.5f, (random.nextFloat() * 2.0f - 1.0f) * 0.25f * 0.5f, (random.nextFloat() * 2.0f - 1.0f) * 0.25f * 0.5f);
            }
            Minecraft.getInstance().getItemRenderer().renderStatic(this.stack, ItemDisplayContext.GROUND, light, overlay, matrixStack, source, tile.getLevel(), 0);
            matrixStack.popPose();
        }
    }

    public String toString() {
        return "PipeItem{stack=" + String.valueOf(this.stack) + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", startInventory=" + String.valueOf(this.startInventory) + ", destInventory=" + String.valueOf(this.destInventory) + "}";
    }

    protected int getModelCount() {
        int i = 1;
        if (this.stack.getCount() > 48) {
            i = 5;
        } else if (this.stack.getCount() > 32) {
            i = 4;
        } else if (this.stack.getCount() > 16) {
            i = 3;
        } else if (this.stack.getCount() > 1) {
            i = 2;
        }
        return i;
    }

    protected static List<BlockPos> compilePath(GraphPath<BlockPos, NetworkEdge> path) {
        Graph graph = path.getGraph();
        ArrayList<BlockPos> ret = new ArrayList<BlockPos>();
        List nodes = path.getVertexList();
        if (nodes.size() == 1) {
            for (int i = 0; i < 2; ++i) {
                ret.add((BlockPos)nodes.getFirst());
            }
            return ret;
        }
        for (int i = 0; i < nodes.size() - 1; ++i) {
            int j2;
            BlockPos first = (BlockPos)nodes.get(i);
            BlockPos second = (BlockPos)nodes.get(i + 1);
            NetworkEdge edge = (NetworkEdge)((Object)graph.getEdge((Object)first, (Object)second));
            Consumer<Integer> add = j -> {
                BlockPos pos = edge.pipes.get((int)j);
                if (!ret.contains(pos)) {
                    ret.add(pos);
                }
            };
            if (!((BlockPos)graph.getEdgeSource((Object)edge)).equals((Object)first)) {
                for (j2 = edge.pipes.size() - 1; j2 >= 0; --j2) {
                    add.accept(j2);
                }
                continue;
            }
            for (j2 = 0; j2 < edge.pipes.size(); ++j2) {
                add.accept(j2);
            }
        }
        return ret;
    }
}

