/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.packets;

import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.misc.DirectionSelector;
import de.ellpeck.prettypipes.misc.ItemFilter;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import de.ellpeck.prettypipes.pipe.containers.AbstractPipeContainer;
import de.ellpeck.prettypipes.pipe.modules.craft.CraftingModuleContainer;
import de.ellpeck.prettypipes.pipe.modules.craft.CraftingModuleItem;
import de.ellpeck.prettypipes.pipe.modules.modifier.FilterModifierModuleContainer;
import de.ellpeck.prettypipes.pipe.modules.modifier.FilterModifierModuleItem;
import de.ellpeck.prettypipes.pipe.modules.stacksize.StackSizeModuleItem;
import de.ellpeck.prettypipes.terminal.CraftingTerminalBlockEntity;
import de.ellpeck.prettypipes.terminal.ItemTerminalBlockEntity;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.apache.logging.log4j.util.TriConsumer;

public record PacketButton(BlockPos pos, int result, List<Integer> data) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketButton> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"prettypipes", (String)"button"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketButton> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketButton::pos, (StreamCodec)ByteBufCodecs.INT, PacketButton::result, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ByteBufCodecs.INT), PacketButton::data, PacketButton::new);

    public PacketButton(BlockPos pos, ButtonResult result, List<Integer> data) {
        this(pos, result.ordinal(), data);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void onMessage(PacketButton message, IPayloadContext ctx) {
        Player player = ctx.player();
        ButtonResult.values()[message.result].action.accept((Object)message.pos, message.data, (Object)player);
    }

    public static void sendAndExecute(BlockPos pos, ButtonResult result, List<Integer> data) {
        PacketDistributor.sendToServer((CustomPacketPayload)new PacketButton(pos, result, data), (CustomPacketPayload[])new CustomPacketPayload[0]);
        result.action.accept((Object)pos, data, (Object)Minecraft.getInstance().player);
    }

    public static enum ButtonResult {
        PIPE_TAB((TriConsumer<BlockPos, List<Integer>, Player>)((TriConsumer)(pos, data, player) -> {
            final PipeBlockEntity tile = Utility.getBlockEntity(PipeBlockEntity.class, (BlockGetter)player.level(), pos);
            if ((Integer)data.getFirst() < 0) {
                player.openMenu((MenuProvider)tile, pos);
            } else {
                final ItemStack stack = tile.modules.getStackInSlot(((Integer)data.getFirst()).intValue());
                player.openMenu(new MenuProvider(){
                    final /* synthetic */ List val$data;
                    {
                        this.val$data = list;
                    }

                    public Component getDisplayName() {
                        return stack.getHoverName();
                    }

                    @Nullable
                    public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
                        return ((IModule)stack.getItem()).getContainer(stack, tile, windowId, inv, player, (Integer)this.val$data.getFirst());
                    }

                    public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                        return false;
                    }
                }, buf -> {
                    buf.writeBlockPos(pos);
                    buf.writeInt(((Integer)data.getFirst()).intValue());
                });
            }
        })),
        FILTER_CHANGE((TriConsumer<BlockPos, List<Integer>, Player>)((TriConsumer)(pos, data, player) -> {
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof ItemFilter.IFilteredContainer) {
                ItemFilter.IFilteredContainer filtered = (ItemFilter.IFilteredContainer)patt0$temp;
                filtered.getFilter().onButtonPacket(filtered, (Integer)data.getFirst());
            }
        })),
        INSERTION_TYPE_BUTTON((TriConsumer<BlockPos, List<Integer>, Player>)((TriConsumer)(pos, data, player) -> {
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof CraftingModuleContainer) {
                CraftingModuleContainer container = (CraftingModuleContainer)patt0$temp;
                container.insertionType = CraftingModuleItem.InsertionType.values()[(container.insertionType.ordinal() + 1) % CraftingModuleItem.InsertionType.values().length];
                container.modified = true;
            }
        })),
        INSERT_UNSTACKED_BUTTON((TriConsumer<BlockPos, List<Integer>, Player>)((TriConsumer)(pos, data, player) -> {
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof CraftingModuleContainer) {
                CraftingModuleContainer container = (CraftingModuleContainer)patt0$temp;
                container.insertUnstacked = !container.insertUnstacked;
                container.modified = true;
            }
        })),
        EMIT_REDSTONE_BUTTON((TriConsumer<BlockPos, List<Integer>, Player>)((TriConsumer)(pos, data, player) -> {
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof CraftingModuleContainer) {
                CraftingModuleContainer container = (CraftingModuleContainer)patt0$temp;
                container.emitRedstone = !container.emitRedstone;
                container.modified = true;
            }
        })),
        STACK_SIZE_MODULE_BUTTON((TriConsumer<BlockPos, List<Integer>, Player>)((TriConsumer)(pos, data, player) -> {
            AbstractPipeContainer container = (AbstractPipeContainer)player.containerMenu;
            StackSizeModuleItem.Data moduleData = (StackSizeModuleItem.Data)container.moduleStack.getOrDefault(StackSizeModuleItem.Data.TYPE, (Object)StackSizeModuleItem.Data.DEFAULT);
            container.moduleStack.set(StackSizeModuleItem.Data.TYPE, (Object)new StackSizeModuleItem.Data(moduleData.maxStackSize(), !moduleData.limitToMaxStackSize()));
        })),
        STACK_SIZE_AMOUNT((TriConsumer<BlockPos, List<Integer>, Player>)((TriConsumer)(pos, data, player) -> {
            AbstractPipeContainer container = (AbstractPipeContainer)player.containerMenu;
            StackSizeModuleItem.Data moduleData = (StackSizeModuleItem.Data)container.moduleStack.getOrDefault(StackSizeModuleItem.Data.TYPE, (Object)StackSizeModuleItem.Data.DEFAULT);
            container.moduleStack.set(StackSizeModuleItem.Data.TYPE, (Object)new StackSizeModuleItem.Data((Integer)data.getFirst(), moduleData.limitToMaxStackSize()));
        })),
        CRAFT_TERMINAL_REQUEST((TriConsumer<BlockPos, List<Integer>, Player>)((TriConsumer)(pos, data, player) -> {
            CraftingTerminalBlockEntity tile = Utility.getBlockEntity(CraftingTerminalBlockEntity.class, (BlockGetter)player.level(), pos);
            tile.requestCraftingItems((Player)player, (Integer)data.getFirst(), (Integer)data.get(1) > 0);
        })),
        CRAFT_TERMINAL_SEND_BACK((TriConsumer<BlockPos, List<Integer>, Player>)((TriConsumer)(pos, data, player) -> {
            CraftingTerminalBlockEntity tile = Utility.getBlockEntity(CraftingTerminalBlockEntity.class, (BlockGetter)player.level(), pos);
            tile.sendItemsBack();
        })),
        CANCEL_CRAFTING((TriConsumer<BlockPos, List<Integer>, Player>)((TriConsumer)(pos, data, player) -> {
            ItemTerminalBlockEntity tile = Utility.getBlockEntity(ItemTerminalBlockEntity.class, (BlockGetter)player.level(), pos);
            tile.cancelCrafting((Integer)data.getFirst() == 1);
        })),
        TAG_FILTER((TriConsumer<BlockPos, List<Integer>, Player>)((TriConsumer)(pos, data, player) -> {
            FilterModifierModuleContainer container = (FilterModifierModuleContainer)player.containerMenu;
            FilterModifierModuleItem.setFilterTag(container.moduleStack, container.getTags().get((Integer)data.getFirst()));
        })),
        DIRECTION_SELECTOR((TriConsumer<BlockPos, List<Integer>, Player>)((TriConsumer)(pos, data, player) -> {
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof DirectionSelector.IDirectionContainer) {
                DirectionSelector.IDirectionContainer filtered = (DirectionSelector.IDirectionContainer)patt0$temp;
                filtered.getSelector().onButtonPacket();
            }
        }));

        public final TriConsumer<BlockPos, List<Integer>, Player> action;

        private ButtonResult(TriConsumer<BlockPos, List<Integer>, Player> action) {
            this.action = action;
        }
    }
}

