/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.packets;

import de.ellpeck.prettypipes.pipe.modules.craft.CraftingModuleContainer;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketCraftingModuleTransfer(List<ItemStack> inputs, List<ItemStack> outputs) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketCraftingModuleTransfer> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"prettypipes", (String)"crafting_module_transfer"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketCraftingModuleTransfer> CODEC = StreamCodec.composite((StreamCodec)ItemStack.LIST_STREAM_CODEC, PacketCraftingModuleTransfer::inputs, (StreamCodec)ItemStack.LIST_STREAM_CODEC, PacketCraftingModuleTransfer::outputs, PacketCraftingModuleTransfer::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void onMessage(PacketCraftingModuleTransfer message, IPayloadContext ctx) {
        Player player = ctx.player();
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof CraftingModuleContainer) {
            CraftingModuleContainer container = (CraftingModuleContainer)abstractContainerMenu;
            PacketCraftingModuleTransfer.copy(container.input, message.inputs);
            PacketCraftingModuleTransfer.copy(container.output, message.outputs);
            container.modified = true;
            container.broadcastChanges();
        }
    }

    private static void copy(ItemStackHandler container, List<ItemStack> contents) {
        for (int i = 0; i < container.getSlots(); ++i) {
            container.setStackInSlot(i, i < contents.size() ? contents.get(i) : ItemStack.EMPTY);
        }
    }
}

