/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.packets;

import de.ellpeck.prettypipes.terminal.containers.ItemTerminalGui;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketNetworkItems(List<ItemStack> items, List<ItemStack> craftables, List<ItemStack> currentlyCrafting) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketNetworkItems> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"prettypipes", (String)"network_items"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketNetworkItems> CODEC = StreamCodec.composite((StreamCodec)ItemStack.LIST_STREAM_CODEC, PacketNetworkItems::items, (StreamCodec)ItemStack.LIST_STREAM_CODEC, PacketNetworkItems::craftables, (StreamCodec)ItemStack.LIST_STREAM_CODEC, PacketNetworkItems::currentlyCrafting, PacketNetworkItems::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void onMessage(PacketNetworkItems message, IPayloadContext ctx) {
        Minecraft mc = Minecraft.getInstance();
        Screen screen = mc.screen;
        if (screen instanceof ItemTerminalGui) {
            ItemTerminalGui terminal = (ItemTerminalGui)screen;
            terminal.updateItemList(message.items, message.craftables, message.currentlyCrafting);
        }
    }
}

