/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pipe;

import com.mojang.blaze3d.vertex.PoseStack;
import de.ellpeck.prettypipes.pipe.IPipeItem;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.model.data.ModelData;

public class PipeRenderer
implements BlockEntityRenderer<PipeBlockEntity> {
    private final Random random = new Random();

    public PipeRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(PipeBlockEntity tile, float partialTicks, PoseStack matrixStack, MultiBufferSource source, int light, int overlay) {
        if (!tile.getItems().isEmpty()) {
            matrixStack.pushPose();
            BlockPos tilePos = tile.getBlockPos();
            matrixStack.translate((float)(-tilePos.getX()), (float)(-tilePos.getY()), (float)(-tilePos.getZ()));
            for (IPipeItem item : tile.getItems()) {
                matrixStack.pushPose();
                item.render(tile, matrixStack, this.random, partialTicks, light, overlay, source);
                matrixStack.popPose();
            }
            matrixStack.popPose();
        }
        if (tile.cover != null) {
            matrixStack.pushPose();
            BlockRenderDispatcher renderer = Minecraft.getInstance().getBlockRenderer();
            BakedModel model = renderer.getBlockModel(tile.cover);
            for (RenderType layer : model.getRenderTypes(tile.cover, RandomSource.create((long)tile.cover.getSeed(tile.getBlockPos())), ModelData.EMPTY)) {
                renderer.getModelRenderer().tesselateBlock((BlockAndTintGetter)tile.getLevel(), model, tile.cover, tile.getBlockPos(), matrixStack, source.getBuffer(layer), true, RandomSource.create(), tile.cover.getSeed(tile.getBlockPos()), overlay, ModelData.EMPTY, layer);
            }
            matrixStack.popPose();
        }
    }

    public AABB getRenderBoundingBox(PipeBlockEntity blockEntity) {
        return new AABB(blockEntity.getBlockPos());
    }
}

