/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pipe.modules;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.items.ModuleItem;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SortingModuleItem
extends ModuleItem {
    private final Type type;

    public SortingModuleItem(String name, Type type) {
        super(name, new Item.Properties());
        this.type = type;
    }

    @Override
    public boolean isCompatible(ItemStack module, PipeBlockEntity tile, IModule other) {
        return !(other instanceof SortingModuleItem);
    }

    @Override
    public boolean hasContainer(ItemStack module, PipeBlockEntity tile) {
        return false;
    }

    @Override
    public Integer getCustomNextNode(ItemStack module, PipeBlockEntity tile, List<BlockPos> nodes, int index) {
        switch (this.type.ordinal()) {
            case 0: {
                Data prevData = (Data)module.get(Data.TYPE);
                int next = prevData != null ? prevData.last + 1 : 0;
                module.set(Data.TYPE, (Object)new Data(next));
                return next % nodes.size();
            }
            case 1: {
                return tile.getLevel().random.nextInt(nodes.size());
            }
        }
        return null;
    }

    public static enum Type {
        ROUND_ROBIN,
        RANDOM;

    }

    public record Data(int last) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.fieldOf("last").forGetter(f -> f.last)).apply((Applicative)i, Data::new));
        public static final DataComponentType<Data> TYPE = DataComponentType.builder().persistent(CODEC).cacheEncoding().build();
    }
}

