/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pipe.modules.craft;

import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.misc.FilterSlot;
import de.ellpeck.prettypipes.pipe.containers.AbstractPipeContainer;
import de.ellpeck.prettypipes.pipe.modules.craft.CraftingModuleItem;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class CraftingModuleContainer
extends AbstractPipeContainer<CraftingModuleItem> {
    public ItemStackHandler input;
    public ItemStackHandler output;
    public boolean emitRedstone;
    public CraftingModuleItem.InsertionType insertionType;
    public boolean insertUnstacked;
    public boolean modified;

    public CraftingModuleContainer(MenuType<?> type, int id, Player player, BlockPos pos, int moduleIndex) {
        super(type, id, player, pos, moduleIndex);
    }

    @Override
    protected void addSlots() {
        int i;
        CraftingModuleItem.Contents contents = (CraftingModuleItem.Contents)this.moduleStack.get(CraftingModuleItem.Contents.TYPE);
        this.emitRedstone = contents.emitRedstone();
        this.insertionType = contents.insertionType();
        this.insertUnstacked = contents.insertUnstacked();
        this.input = Utility.copy(contents.input());
        for (i = 0; i < this.input.getSlots(); ++i) {
            this.addSlot((Slot)new FilterSlot((IItemHandler)this.input, i, (176 - this.input.getSlots() * 18) / 2 + 1 + i % 9 * 18, 49 + i / 9 * 18, false){

                public void setChanged() {
                    super.setChanged();
                    CraftingModuleContainer.this.modified = true;
                }
            });
        }
        this.output = Utility.copy(contents.output());
        for (i = 0; i < this.output.getSlots(); ++i) {
            this.addSlot((Slot)new FilterSlot((IItemHandler)this.output, i, (176 - this.output.getSlots() * 18) / 2 + 1 + i % 9 * 18, 85 + i / 9 * 18, false){

                public void setChanged() {
                    super.setChanged();
                    CraftingModuleContainer.this.modified = true;
                }
            });
        }
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        if (this.modified) {
            this.moduleStack.set(CraftingModuleItem.Contents.TYPE, (Object)new CraftingModuleItem.Contents(this.input, this.output, this.emitRedstone, this.insertionType, this.insertUnstacked));
            this.tile.setChanged();
        }
    }
}

