/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pipe.modules.stacksize;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.items.ModuleItem;
import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.misc.ItemFilter;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import de.ellpeck.prettypipes.pipe.containers.AbstractPipeContainer;
import de.ellpeck.prettypipes.pipe.modules.stacksize.StackSizeModuleContainer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class StackSizeModuleItem
extends ModuleItem {
    public StackSizeModuleItem() {
        super("stack_size_module", new Item.Properties());
    }

    @Override
    public int getMaxInsertionAmount(ItemStack module, PipeBlockEntity tile, ItemStack stack, IItemHandler destination) {
        ItemEquality[] types = ItemFilter.getEqualityTypes(tile);
        Data data = (Data)module.getOrDefault(Data.TYPE, (Object)Data.DEFAULT);
        int max = data.maxStackSize;
        if (data.limitToMaxStackSize) {
            max = Math.min(max, stack.getMaxStackSize());
        }
        int amount = 0;
        for (int i = 0; i < destination.getSlots(); ++i) {
            ItemStack stored = destination.getStackInSlot(i);
            if (stored.isEmpty() || !ItemEquality.compareItems(stored, stack, types) || (amount += stored.getCount()) < max) continue;
            return 0;
        }
        return max - amount;
    }

    @Override
    public boolean isCompatible(ItemStack module, PipeBlockEntity tile, IModule other) {
        return !(other instanceof StackSizeModuleItem);
    }

    @Override
    public boolean hasContainer(ItemStack module, PipeBlockEntity tile) {
        return true;
    }

    @Override
    public AbstractPipeContainer<?> getContainer(ItemStack module, PipeBlockEntity tile, int windowId, Inventory inv, Player player, int moduleIndex) {
        return new StackSizeModuleContainer(Registry.stackSizeModuleContainer, windowId, player, tile.getBlockPos(), moduleIndex);
    }

    public record Data(int maxStackSize, boolean limitToMaxStackSize) {
        public static final Data DEFAULT = new Data(64, false);
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.fieldOf("max_stack_size").forGetter(f -> f.maxStackSize), (App)Codec.BOOL.fieldOf("limit_to_max_stack_size").forGetter(f -> f.limitToMaxStackSize)).apply((Applicative)i, Data::new));
        public static final DataComponentType<Data> TYPE = DataComponentType.builder().persistent(CODEC).cacheEncoding().build();
    }
}

