/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.terminal.containers;

import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.terminal.CraftingTerminalBlockEntity;
import de.ellpeck.prettypipes.terminal.containers.ItemTerminalContainer;
import de.ellpeck.prettypipes.terminal.containers.WrappedCraftingInventory;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class CraftingTerminalContainer
extends ItemTerminalContainer {
    public CraftingContainer craftInventory;
    public ResultContainer craftResult;
    private final Player player;

    public CraftingTerminalContainer(@Nullable MenuType<?> type, int id, Player player, BlockPos pos) {
        super(type, id, player, pos);
        this.player = player;
        this.slotsChanged((Container)this.craftInventory);
    }

    @Override
    protected void addOwnSlots(Player player) {
        this.craftInventory = new WrappedCraftingInventory(this.getTile().craftItems, this);
        this.craftResult = new ResultContainer(){

            public void setChanged() {
                for (Player player : CraftingTerminalContainer.this.getTile().getLookingPlayers()) {
                    player.containerMenu.slotsChanged((Container)this);
                }
            }
        };
        this.addSlot((Slot)new ResultSlot(player, this.craftInventory, (Container)this.craftResult, 0, 25, 77));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.addSlot(new Slot((Container)this.craftInventory, j + i * 3, 7 + j * 18, 18 + i * 18));
            }
        }
        super.addOwnSlots(player);
    }

    public void slotsChanged(Container inventoryIn) {
        super.slotsChanged(inventoryIn);
        CraftingTerminalContainer.slotChangedCraftingGrid(this, this.player.level(), this.player, this.craftInventory, this.craftResult, null);
    }

    @Override
    public ItemStack quickMoveStack(Player player, int slotIndex) {
        return Utility.transferStackInSlot(this, (x$0, x$1, x$2, x$3) -> this.moveItemStackTo(x$0, x$1, x$2, x$3), player, slotIndex, stack -> Pair.of((Object)16, (Object)22));
    }

    @Override
    protected int getSlotXOffset() {
        return 65;
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId > 0) {
            Slot slot = (Slot)this.slots.get(slotId);
            ItemStackHandler ghostItems = this.getTile().ghostItems;
            if (slot.container == this.craftInventory && !slot.hasItem()) {
                if (clickTypeIn == ClickType.PICKUP) {
                    ghostItems.setStackInSlot(slot.getSlotIndex(), ItemStack.EMPTY);
                } else if (clickTypeIn == ClickType.QUICK_MOVE) {
                    for (int i = 0; i < ghostItems.getSlots(); ++i) {
                        ghostItems.setStackInSlot(i, ItemStack.EMPTY);
                    }
                }
            }
        }
        super.clicked(slotId, dragType, clickTypeIn, player);
    }

    public CraftingTerminalBlockEntity getTile() {
        return (CraftingTerminalBlockEntity)this.tile;
    }

    protected static void slotChangedCraftingGrid(AbstractContainerMenu menu, Level level, Player player, CraftingContainer craftSlots, ResultContainer resultSlots, @Nullable RecipeHolder<CraftingRecipe> recipe) {
        if (!level.isClientSide) {
            CraftingInput craftinginput = craftSlots.asCraftInput();
            ServerPlayer serverplayer = (ServerPlayer)player;
            ItemStack itemstack = ItemStack.EMPTY;
            Optional optional = level.getServer().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)craftinginput, level, recipe);
            if (optional.isPresent()) {
                ItemStack itemstack1;
                RecipeHolder recipeholder = (RecipeHolder)optional.get();
                CraftingRecipe craftingrecipe = (CraftingRecipe)recipeholder.value();
                if (resultSlots.setRecipeUsed(level, serverplayer, recipeholder) && (itemstack1 = craftingrecipe.assemble((RecipeInput)craftinginput, (HolderLookup.Provider)level.registryAccess())).isItemEnabled(level.enabledFeatures())) {
                    itemstack = itemstack1;
                }
            }
            resultSlots.setItem(0, itemstack);
            menu.setRemoteSlot(0, itemstack);
            serverplayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(menu.containerId, menu.incrementStateId(), 0, itemstack));
        }
    }
}

