/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.peek.tooltips;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.peek.tooltips.ContainerTooltip;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5684;

public class ClientContainerTooltip
implements class_5684 {
    public static final class_2960 TEXTURE_LOCATION = class_2960.method_60655((String)"peek", (String)"textures/gui/container/slot.png");
    private static final int MARGIN_Y = 4;
    private static final int BORDER_WIDTH = 1;
    private static final int TEXTURE_SIZE = 32;
    private static final int SLOT_SIZE_X = 18;
    private static final int SLOT_SIZE_Y = 18;
    private final int gridWidth;
    private final int gridHeight;
    private final class_2371<class_1799> items;

    public ClientContainerTooltip(ContainerTooltip tooltip) {
        this.gridWidth = tooltip.getWidth();
        this.gridHeight = tooltip.getHeight();
        this.items = tooltip.getItems();
    }

    public int method_32661() {
        return this.gridHeight * 18 + 2 + 4;
    }

    public int method_32664(class_327 font) {
        return this.gridWidth * 18 + 2;
    }

    public void method_32666(class_327 font, int tooltipX, int tooltipY, class_332 guiGraphics) {
        int slotId = 0;
        for (int y = 0; y < this.gridHeight; ++y) {
            for (int x = 0; x < this.gridWidth; ++x) {
                int posX = tooltipX + x * 18 + 1;
                int posY = tooltipY + y * 18 + 1;
                this.renderSlot(posX, posY, slotId++, font, guiGraphics);
            }
        }
        this.drawBorder(tooltipX, tooltipY, guiGraphics);
    }

    private void renderSlot(int posX, int posY, int slotId, class_327 font, class_332 guiGraphics) {
        class_1799 itemStack = class_1799.field_8037;
        if (slotId < this.items.size()) {
            itemStack = (class_1799)this.items.get(slotId);
        }
        this.blit(guiGraphics, posX, posY, Texture.SLOT);
        guiGraphics.method_51428(itemStack, posX + 1, posY + 1, slotId);
        guiGraphics.method_51431(font, itemStack, posX + 1, posY + 1);
    }

    private void drawBorder(int x, int y, class_332 guiGraphics) {
        int i;
        this.blit(guiGraphics, x, y, Texture.BORDER_CORNER);
        this.blit(guiGraphics, x + this.gridWidth * 18 + 1, y, Texture.BORDER_CORNER);
        for (i = 0; i < this.gridWidth; ++i) {
            this.blit(guiGraphics, x + 1 + i * 18, y, Texture.BORDER_HORIZONTAL);
            this.blit(guiGraphics, x + 1 + i * 18, y + this.gridHeight * 18 + 1, Texture.BORDER_HORIZONTAL);
        }
        for (i = 0; i < this.gridHeight; ++i) {
            this.blit(guiGraphics, x, y + i * 18 + 1, Texture.BORDER_VERTICAL);
            this.blit(guiGraphics, x + this.gridWidth * 18 + 1, y + i * 18 + 1, Texture.BORDER_VERTICAL);
        }
        this.blit(guiGraphics, x, y + this.gridHeight * 18 + 1, Texture.BORDER_CORNER);
        this.blit(guiGraphics, x + this.gridWidth * 18 + 1, y + this.gridHeight * 18 + 1, Texture.BORDER_CORNER);
    }

    private void blit(class_332 guiGraphics, int i, int j, Texture texture) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.method_25291(TEXTURE_LOCATION, i, j, 0, (float)texture.x, (float)texture.y, texture.w, texture.h, 32, 32);
    }

    static enum Texture {
        SLOT(0, 0, 18, 18),
        BORDER_HORIZONTAL(0, 18, 18, 1),
        BORDER_VERTICAL(18, 0, 1, 18),
        BORDER_CORNER(18, 18, 1, 1);

        public final int x;
        public final int y;
        public final int w;
        public final int h;

        private Texture(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }
    }
}

