/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.peek.utils;

import de.maxhenkel.peek.Peek;
import de.maxhenkel.peek.config.PeekConfig;
import de.maxhenkel.peek.utils.ItemNameCache;
import de.maxhenkel.peek.utils.ShulkerBoxUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2561;

public class ShulkerHintData {
    public static final Pattern DATA_PATTERN = Pattern.compile("\\{([^{}]+)}");
    @Nullable
    private class_2561 label;
    @Nullable
    private class_1799 displayItem;

    public ShulkerHintData(@Nullable class_2561 label, @Nullable class_1799 displayItem) {
        this.label = label;
        this.displayItem = displayItem;
    }

    public ShulkerHintData() {
    }

    @Nullable
    public class_2561 getLabel() {
        return this.label;
    }

    @Nullable
    public class_1799 getDisplayItem() {
        return this.displayItem;
    }

    public void setLabel(@Nullable class_2561 label) {
        this.label = label;
    }

    public void setDisplayItem(@Nullable class_1799 displayItem) {
        this.displayItem = displayItem;
    }

    public static ShulkerHintData fromShulkerBox(class_2371<class_1799> contents, @Nullable class_2561 name) {
        ShulkerHintData data;
        if (Peek.CONFIG.useShulkerBoxDataStrings.get().booleanValue() && (data = ShulkerHintData.fromDataString(ShulkerBoxUtils.getStringFromComponent(name))) != null) {
            return data;
        }
        if (name != null && Peek.CONFIG.useShulkerBoxItemNames.get().booleanValue() && (data = ShulkerHintData.fromItemName(name)) != null) {
            return data;
        }
        return ShulkerHintData.fromContents(contents, name);
    }

    public static ShulkerHintData fromContents(class_2371<class_1799> contents, @Nullable class_2561 name) {
        ShulkerHintData data = new ShulkerHintData();
        data.setDisplayItem(ShulkerHintData.determineDisplayItem(contents));
        if (Peek.CONFIG.showShulkerBoxLabels.get().booleanValue()) {
            data.setLabel(name);
        }
        return data;
    }

    @Nullable
    private static class_1799 determineDisplayItem(class_2371<class_1799> contents) {
        return switch (Peek.CONFIG.shulkerBoxItemDisplayType.get()) {
            default -> throw new IncompatibleClassChangeError();
            case PeekConfig.ShulkerItemDisplayType.NONE -> null;
            case PeekConfig.ShulkerItemDisplayType.SINGLE_TYPE -> ShulkerBoxUtils.getSingleTypeItem(contents);
            case PeekConfig.ShulkerItemDisplayType.BULK -> ShulkerBoxUtils.getBulkItem(contents);
            case PeekConfig.ShulkerItemDisplayType.FIRST_ITEM -> contents.stream().filter(stack -> !stack.method_7960()).findFirst().orElse(null);
        };
    }

    @Nullable
    public static ShulkerHintData fromDataString(@Nullable String s) {
        class_1792 item;
        String itemId;
        if (s == null) {
            return null;
        }
        Matcher matcher = DATA_PATTERN.matcher(s);
        if (!matcher.find()) {
            return null;
        }
        ShulkerHintData data = new ShulkerHintData();
        String str = matcher.group(1);
        Map<String, String> map = ShulkerHintData.parseData(str);
        String label = ShulkerHintData.getFromMap(map, "label", "l");
        if (label != null) {
            data.setLabel((class_2561)class_2561.method_43470((String)label));
        }
        if ((itemId = ShulkerHintData.getFromMap(map, "item", "i")) != null && (item = ShulkerBoxUtils.byId(itemId)) != null) {
            data.setDisplayItem(new class_1799((class_1935)item));
        }
        return data;
    }

    @Nullable
    public static ShulkerHintData fromItemName(class_2561 label) {
        class_1792 item = ItemNameCache.byIdName(label.getString());
        if (item != null) {
            return new ShulkerHintData(null, new class_1799((class_1935)item));
        }
        item = ItemNameCache.byName(label.getString());
        if (item != null) {
            return new ShulkerHintData(null, new class_1799((class_1935)item));
        }
        return null;
    }

    @Nullable
    private static String getFromMap(Map<String, String> map, String ... keys) {
        for (String key : keys) {
            if (!map.containsKey(key)) continue;
            return map.get(key);
        }
        return null;
    }

    private static Map<String, String> parseData(String s) {
        String[] split;
        HashMap<String, String> data = new HashMap<String, String>();
        for (String str : split = s.split(";")) {
            String[] split2 = str.split("=", 2);
            if (split2.length != 2) continue;
            data.put(split2[0], split2[1]);
        }
        return data;
    }
}

