/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.mojang.serialization.Codec;
import com.pepper.faunify.particle.FaunifyParticleTypes;
import com.pepper.faunify.registry.FaunifyEntities;
import com.pepper.faunify.registry.FaunifyItems;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class HedgehogEntity
extends TamableAnimal
implements GeoEntity {
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(HedgehogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.m_135353_(HedgehogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CURLED = SynchedEntityData.m_135353_(HedgehogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private boolean orderedToSit;
    private boolean hurt;
    private int hurtCooldown = 100;
    private int quillDropTime = 0;
    private int quillDropInterval;
    public static final float DEFAULT_HEALTH = 5.0f;
    public static final float TAMED_HEALTH = 15.0f;
    private static final long DAMAGE_COOLDOWN = 20L;
    private Map<LivingEntity, Long> lastDamageTime = new HashMap<LivingEntity, Long>();
    private static final Random RANDOM = new Random();

    public HedgehogEntity(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
        this.resetQuillDropInterval();
        if (this.m_21824_()) {
            this.m_21051_(Attributes.f_22276_).m_22100_(15.0);
            this.m_21153_(15.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(5.0);
            this.m_21153_(5.0f);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.setVariant((Variant)((Object)Util.m_214670_((Object[])Variant.values(), (RandomSource)world.m_213780_())));
        super.m_6518_(world, difficulty, spawnReason, spawnData, dataTag);
        if (spawnData == null) {
            spawnData = new AgeableMob.AgeableMobGroupData(false);
        }
        return spawnData;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22281_, 1.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SLEEPING, (Object)false);
        this.f_19804_.m_135372_(CURLED, (Object)false);
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant().id);
        tag.m_128379_("Sleeping", this.m_5803_());
        tag.m_128379_("Curled", this.isCurledUp());
        tag.m_128379_("Sitting", this.orderedToSit);
        tag.m_128347_("PosX", this.m_20185_());
        tag.m_128347_("PosY", this.m_20186_());
        tag.m_128347_("PosZ", this.m_20189_());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(Variant.byId(tag.m_128451_("Variant")));
        this.orderedToSit = tag.m_128471_("Sitting");
        this.setSleeping(tag.m_128471_("Sleeping"));
        this.setCurled(tag.m_128471_("Curled"));
        this.m_21837_(this.orderedToSit);
        if (tag.m_128441_("PosX") && tag.m_128441_("PosY") && tag.m_128441_("PosZ")) {
            double posX = tag.m_128459_("PosX");
            double posY = tag.m_128459_("PosY");
            double posZ = tag.m_128459_("PosZ");
            this.m_6034_(posX, posY, posZ);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.5));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.5, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42577_}), false));
        this.f_21345_.m_25352_(4, (Goal)new SleepGoal(200));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal(this, 1.3, 10.0f, 2.0f, false){

            public boolean m_8036_() {
                return super.m_8036_() && !HedgehogEntity.this.m_21825_();
            }
        });
        this.f_21345_.m_25352_(7, (Goal)new BreedGoal((Animal)this, 1.5));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.isCurledUp()) {
            this.m_21573_().m_26573_();
            return;
        }
        if (this.m_21825_()) {
            this.m_21573_().m_26573_();
            this.m_20242_(false);
        } else {
            this.m_20242_(false);
            this.m_21573_().m_26569_();
        }
    }

    public boolean m_5803_() {
        return (Boolean)this.f_19804_.m_135370_(SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.f_19804_.m_135381_(SLEEPING, (Object)sleeping);
    }

    public boolean m_21827_() {
        return this.orderedToSit;
    }

    public void m_21839_(boolean isSitting) {
        this.orderedToSit = isSitting;
    }

    public boolean m_21825_() {
        return ((Byte)this.f_19804_.m_135370_(f_21798_) & 1) != 0;
    }

    public void m_21837_(boolean sitting) {
        super.m_21837_(sitting);
        this.orderedToSit = sitting;
        if (sitting) {
            this.m_21573_().m_26573_();
        }
    }

    public static boolean canSpawn(EntityType<HedgehogEntity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        return Animal.m_218104_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<HedgehogEntity> event) {
        LivingEntity target = this.m_5448_();
        if (target != null && !target.m_6084_()) {
            this.m_6710_(null);
            target = null;
        }
        if (this.m_5803_()) {
            event.getController().setAnimation(RawAnimation.begin().then("sleep", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.m_21825_()) {
            event.getController().setAnimation(RawAnimation.begin().then("sit", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isCurledUp()) {
            event.getController().setAnimation(RawAnimation.begin().then("curl", Animation.LoopType.HOLD_ON_LAST_FRAME));
            return PlayState.CONTINUE;
        }
        if (this.isFollowingPlayerWithFood()) {
            if (event.isMoving()) {
                event.getController().setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private boolean isFollowingPlayerWithFood() {
        Player player = this.m_9236_().m_45930_((Entity)this, 10.0);
        if (player != null) {
            ItemStack heldItem = player.m_21205_();
            return heldItem.m_41720_() == Items.f_42577_;
        }
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.hurt) {
            --this.hurtCooldown;
            if (this.hurtCooldown <= 0) {
                this.hurt = false;
                this.f_19804_.m_135381_(CURLED, (Object)false);
            }
        }
        ++this.quillDropTime;
        if (this.quillDropTime >= this.quillDropInterval) {
            this.quillDropTime = 0;
            this.resetQuillDropInterval();
            if (this.m_9236_().m_213780_().m_188501_() < 1.0f) {
                this.m_19998_((ItemLike)FaunifyItems.QUILL.get());
            }
        }
    }

    private void resetQuillDropInterval() {
        this.quillDropInterval = 6000 + RANDOM.nextInt(6001);
    }

    public HedgehogEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob otherParent) {
        HedgehogEntity babyHedgehog = (HedgehogEntity)((EntityType)FaunifyEntities.HEDGEHOG.get()).m_20615_((Level)serverLevel);
        if (babyHedgehog != null && otherParent instanceof HedgehogEntity) {
            HedgehogEntity parent = (HedgehogEntity)otherParent;
            Variant selectedVariant = this.f_19796_.m_188499_() ? this.getVariant() : parent.getVariant();
            babyHedgehog.setVariant(selectedVariant);
        }
        return babyHedgehog;
    }

    protected SoundEvent m_7515_() {
        int soundIndex = this.f_19796_.m_188503_(3);
        switch (soundIndex) {
            case 0: {
                return (SoundEvent)FaunifySounds.HEDGEHOG_IDLE_1.get();
            }
            case 1: {
                return (SoundEvent)FaunifySounds.HEDGEHOG_IDLE_2.get();
            }
            case 2: {
                return (SoundEvent)FaunifySounds.HEDGEHOG_IDLE_3.get();
            }
        }
        return (SoundEvent)FaunifySounds.HEDGEHOG_IDLE_1.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)FaunifySounds.HEDGEHOG_HURT.get();
    }

    public boolean isCurledUp() {
        return (Boolean)this.f_19804_.m_135370_(CURLED);
    }

    public void setCurled(boolean curled) {
        this.f_19804_.m_135381_(CURLED, (Object)curled);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean result = super.m_6469_(source, amount);
        if (this.m_5803_()) {
            this.setSleeping(false);
        }
        if (this.m_21825_()) {
            this.m_21837_(false);
            this.m_21839_(false);
        }
        if (result) {
            LivingEntity pushingEntity;
            Entity entity;
            this.hurt = true;
            this.hurtCooldown = 100;
            if (!(source.m_7639_() instanceof HedgehogEntity)) {
                this.f_21345_.m_25352_(1, (Goal)new HedgehogCurlUpGoal(this));
            }
            if ((entity = source.m_7639_()) instanceof LivingEntity && (pushingEntity = (LivingEntity)entity) != this) {
                Player player;
                if (pushingEntity instanceof Player && (player = (Player)pushingEntity).m_7500_()) {
                    return result;
                }
                long currentTime = this.m_9236_().m_46467_();
                if (!this.lastDamageTime.containsKey(pushingEntity) || currentTime - this.lastDamageTime.get(pushingEntity) >= 20L) {
                    float damage = 1.0f;
                    pushingEntity.m_21153_(pushingEntity.m_21223_() - damage);
                    this.m_5496_(SoundEvents.f_11915_, 0.5f, 1.0f);
                    this.lastDamageTime.put(pushingEntity, currentTime);
                }
            }
        }
        return result;
    }

    public void m_7334_(Entity entity) {
        LivingEntity pushingEntity;
        super.m_7334_(entity);
        if (entity instanceof LivingEntity && (pushingEntity = (LivingEntity)entity) != this) {
            Player player;
            if (pushingEntity instanceof Player && (player = (Player)pushingEntity).m_7500_()) {
                return;
            }
            if (pushingEntity instanceof HedgehogEntity) {
                return;
            }
            long currentTime = this.m_9236_().m_46467_();
            if (!this.lastDamageTime.containsKey(pushingEntity) || currentTime - this.lastDamageTime.get(pushingEntity) >= 20L) {
                float damage = 1.0f;
                pushingEntity.m_21153_(pushingEntity.m_21223_() - damage);
                this.m_5496_(SoundEvents.f_11915_, 0.5f, 1.0f);
                this.lastDamageTime.put(pushingEntity, currentTime);
            }
        }
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)variant.id);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (this.m_21824_() && this.m_21830_((LivingEntity)player)) {
            if (item == Items.f_42780_) {
                if (this.m_21223_() < this.m_21233_()) {
                    int particleCount = 5;
                    this.m_5634_(3.0f);
                    if (!player.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    for (int i = 0; i < particleCount; ++i) {
                        double offsetX = (this.f_19796_.m_188500_() - 0.5) * 1.0;
                        double offsetY = (this.f_19796_.m_188500_() - 0.5) * 1.0;
                        double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 1.0;
                        this.m_9236_().m_7106_((ParticleOptions)FaunifyParticleTypes.HEALTH.get(), this.m_20185_() + offsetX, this.m_20186_() + (double)this.m_20192_() + offsetY, this.m_20189_() + offsetZ, 0.0, 0.0, 0.0);
                    }
                } else {
                    this.toggleSittingState();
                }
                return InteractionResult.SUCCESS;
            }
            if (item == Items.f_42577_) {
                if (!this.m_27593_() && this.m_146764_() == 0) {
                    if (!this.m_9236_().f_46443_) {
                        this.m_27595_(player);
                        if (!player.m_150110_().f_35937_) {
                            itemstack.m_41774_(1);
                        }
                    }
                } else {
                    this.toggleSittingState();
                }
                return InteractionResult.SUCCESS;
            }
            if (itemstack.m_41619_() || item != Items.f_42577_ && item != Items.f_42780_) {
                this.toggleSittingState();
                return InteractionResult.SUCCESS;
            }
        }
        if (item == Items.f_42780_ && !this.m_21824_()) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (!this.m_9236_().f_46443_) {
                if (this.f_19796_.m_188503_(3) == 0) {
                    this.m_21828_(player);
                    this.m_21816_(player.m_20148_());
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    private void toggleSittingState() {
        boolean currentSittingState = this.m_21825_();
        this.m_21837_(!currentSittingState);
        if (!this.m_9236_().f_46443_) {
            if (!currentSittingState) {
                this.m_21573_().m_26573_();
            } else {
                this.m_21839_(false);
                this.m_21573_().m_26569_();
            }
        }
    }

    public void m_6710_(@Nullable LivingEntity target) {
        if (this.m_21824_() && this.m_269323_() != null && target == this.m_269323_()) {
            return;
        }
        super.m_6710_(target);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == Items.f_42577_;
    }

    public static enum Variant implements StringRepresentable
    {
        LIGHT(0, "light"),
        DARK(1, "dark"),
        ALBINO(2, "albino");

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int p_262571_, String p_262693_) {
            this.id = p_262571_;
            this.name = p_262693_;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int p_262643_) {
            return BY_ID.apply(p_262643_);
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Variant::values);
            BY_ID = ByIdMap.m_262839_(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }

    public class SleepGoal
    extends Goal {
        private final int countdownTime;
        private int countdown;

        public SleepGoal(int countdownTime) {
            this.countdownTime = countdownTime;
            this.countdown = HedgehogEntity.this.f_19796_.m_188503_(SleepGoal.m_186073_((int)countdownTime));
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            if (HedgehogEntity.this.isCurledUp()) {
                return false;
            }
            if (HedgehogEntity.this.m_21824_() && !HedgehogEntity.this.m_21825_()) {
                return false;
            }
            if (HedgehogEntity.this.f_20900_ == 0.0f && HedgehogEntity.this.f_20901_ == 0.0f && HedgehogEntity.this.f_20902_ == 0.0f) {
                return this.canSleep() || HedgehogEntity.this.m_5803_();
            }
            return false;
        }

        public boolean m_8045_() {
            if (HedgehogEntity.this.isCurledUp()) {
                return false;
            }
            if (HedgehogEntity.this.m_21824_() && !HedgehogEntity.this.m_21825_()) {
                return false;
            }
            return this.canSleep();
        }

        private boolean canSleep() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return HedgehogEntity.this.m_9236_().m_46462_();
        }

        public void m_8041_() {
            HedgehogEntity.this.setSleeping(false);
            this.countdown = HedgehogEntity.this.f_19796_.m_188503_(this.countdownTime);
        }

        public void m_8056_() {
            HedgehogEntity.this.m_6862_(false);
            HedgehogEntity.this.setSleeping(true);
            HedgehogEntity.this.m_21573_().m_26573_();
        }

        public void m_8037_() {
            if (HedgehogEntity.this.m_5803_()) {
                HedgehogEntity.this.m_21573_().m_26573_();
            }
        }
    }

    public class HedgehogCurlUpGoal
    extends Goal {
        private final HedgehogEntity hedgehog;
        private int timer;

        public HedgehogCurlUpGoal(HedgehogEntity hedgehog) {
            this.hedgehog = hedgehog;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.hedgehog.hurt && !this.hedgehog.isCurledUp();
        }

        public void m_8056_() {
            if (this.hedgehog.m_5803_()) {
                return;
            }
            this.hedgehog.setCurled(true);
            this.timer = 0;
            this.hedgehog.m_21573_().m_26573_();
            this.hedgehog.m_21563_().m_24946_(this.hedgehog.m_20185_(), this.hedgehog.m_20186_(), this.hedgehog.m_20189_());
        }

        public void m_8037_() {
            ++this.timer;
            if (this.timer >= 40) {
                this.uncurlHedgehog();
                this.m_8041_();
            }
        }

        private void uncurlHedgehog() {
            if (this.hedgehog.isCurledUp()) {
                this.hedgehog.setCurled(false);
            }
        }
    }
}

