/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.mojang.serialization.Codec;
import com.pepper.faunify.entity.MouseEntity;
import com.pepper.faunify.particle.FaunifyParticleTypes;
import com.pepper.faunify.registry.FaunifyEntities;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockDestructionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class RingtailCatEntity
extends TamableAnimal
implements GeoEntity {
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(RingtailCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.m_135353_(RingtailCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> STALKING = SynchedEntityData.m_135353_(RingtailCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DIGGING = SynchedEntityData.m_135353_(RingtailCatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private boolean orderedToSit;
    public static final float DEFAULT_HEALTH = 15.0f;
    public static final float TAMED_HEALTH = 25.0f;

    public RingtailCatEntity(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
        if (this.m_21824_()) {
            this.m_21051_(Attributes.f_22276_).m_22100_(25.0);
            this.m_21153_(25.0f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(15.0);
            this.m_21153_(15.0f);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.setVariant((Variant)((Object)Util.m_214670_((Object[])Variant.values(), (RandomSource)world.m_213780_())));
        super.m_6518_(world, difficulty, spawnReason, spawnData, dataTag);
        if (spawnData == null) {
            spawnData = new AgeableMob.AgeableMobGroupData(false);
        }
        return spawnData;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 1.8);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SLEEPING, (Object)false);
        this.f_19804_.m_135372_(STALKING, (Object)false);
        this.f_19804_.m_135372_(DIGGING, (Object)false);
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant().id);
        tag.m_128379_("Sleeping", this.m_5803_());
        tag.m_128379_("Sitting", this.orderedToSit);
        tag.m_128379_("Digging", this.isDigging());
        tag.m_128347_("PosX", this.m_20185_());
        tag.m_128347_("PosY", this.m_20186_());
        tag.m_128347_("PosZ", this.m_20189_());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(Variant.byId(tag.m_128451_("Variant")));
        this.orderedToSit = tag.m_128471_("Sitting");
        this.setSleeping(tag.m_128471_("Sleeping"));
        this.setDigging(tag.m_128471_("Digging"));
        this.m_21837_(this.orderedToSit);
        if (tag.m_128441_("PosX") && tag.m_128441_("PosY") && tag.m_128441_("PosZ")) {
            double posX = tag.m_128459_("PosX");
            double posY = tag.m_128459_("PosY");
            double posZ = tag.m_128459_("PosZ");
            this.m_6034_(posX, posY, posZ);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SleepGoal(200));
        this.f_21345_.m_25352_(2, (Goal)new FollowOwnerGoal(this, 1.2, 10.0f, 2.0f, false){

            public boolean m_8036_() {
                return super.m_8036_() && !RingtailCatEntity.this.m_21825_();
            }

            public boolean m_8045_() {
                return super.m_8045_() && !RingtailCatEntity.this.m_21825_();
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.35, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42526_, Items.f_42527_}), false){

            public boolean m_8036_() {
                return super.m_8036_() && !RingtailCatEntity.this.m_21825_();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new RingtailStalkAndPounceGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new MiningGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean m_8036_() {
                return super.m_8036_() && !RingtailCatEntity.this.m_21825_();
            }
        });
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Rabbit.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, MouseEntity.class, true));
    }

    protected void m_8024_() {
        LivingEntity livingEntity;
        super.m_8024_();
        if (this.m_21825_()) {
            this.m_21573_().m_26573_();
            this.m_20242_(false);
        } else {
            this.m_20242_(false);
            this.m_21573_().m_26569_();
        }
        if (this.m_21824_() && !this.m_21825_() && (livingEntity = this.m_269323_()) instanceof Player) {
            Player player = (Player)livingEntity;
            MobEffectInstance current = player.m_21124_(MobEffects.f_19598_);
            if (current == null || current.m_19557_() < 10) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 40, 0, true, false, true));
            }
        } else {
            Player player;
            LivingEntity livingEntity2 = this.m_269323_();
            if (livingEntity2 instanceof Player && (player = (Player)livingEntity2).m_21023_(MobEffects.f_19598_)) {
                player.m_21195_(MobEffects.f_19598_);
            }
        }
    }

    public boolean m_5803_() {
        return (Boolean)this.f_19804_.m_135370_(SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.f_19804_.m_135381_(SLEEPING, (Object)sleeping);
    }

    public boolean m_21827_() {
        return this.orderedToSit;
    }

    public void m_21839_(boolean isSitting) {
        this.orderedToSit = isSitting;
    }

    public boolean m_21825_() {
        return ((Byte)this.f_19804_.m_135370_(f_21798_) & 1) != 0;
    }

    public void m_21837_(boolean sitting) {
        super.m_21837_(sitting);
        this.orderedToSit = sitting;
        if (sitting) {
            this.m_21573_().m_26573_();
        }
    }

    public static boolean canSpawn(EntityType<RingtailCatEntity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        return Animal.m_218104_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<RingtailCatEntity> event) {
        LivingEntity target = this.m_5448_();
        Vec3 velocity = this.m_20184_();
        double horizontalSpeedSq = velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_;
        double movingThreshold = 0.001;
        if (target != null && !target.m_6084_()) {
            this.m_6710_(null);
            target = null;
        }
        if (this.isDigging()) {
            event.getController().setAnimation(RawAnimation.begin().then("dig", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.m_5803_()) {
            event.getController().setAnimation(RawAnimation.begin().then("sleep", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isStalking()) {
            event.getController().setAnimation(RawAnimation.begin().then("stalk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.m_21825_()) {
            event.getController().setAnimation(RawAnimation.begin().then("sit", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (target instanceof Rabbit || target instanceof MouseEntity) {
            if (horizontalSpeedSq > movingThreshold) {
                event.getController().setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isFollowingPlayerWithFood()) {
            if (horizontalSpeedSq > movingThreshold) {
                event.getController().setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (!this.m_20096_() && velocity.f_82480_ > 0.1) {
            event.getController().setAnimation(RawAnimation.begin().then("leap", Animation.LoopType.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        if (horizontalSpeedSq > movingThreshold) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private boolean isFollowingPlayerWithFood() {
        Player player = this.m_9236_().m_45930_((Entity)this, 10.0);
        if (player != null) {
            ItemStack heldItem = player.m_21205_();
            return heldItem.m_41720_() == Items.f_42526_ || heldItem.m_41720_() == Items.f_42527_;
        }
        return false;
    }

    public RingtailCatEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob otherParent) {
        RingtailCatEntity babyRingtailCat = (RingtailCatEntity)((EntityType)FaunifyEntities.RINGTAIL.get()).m_20615_((Level)serverLevel);
        if (babyRingtailCat != null && otherParent instanceof RingtailCatEntity) {
            RingtailCatEntity parent = (RingtailCatEntity)otherParent;
            Variant selectedVariant = this.f_19796_.m_188499_() ? this.getVariant() : parent.getVariant();
            babyRingtailCat.setVariant(selectedVariant);
        }
        return babyRingtailCat;
    }

    protected SoundEvent m_7515_() {
        int soundIndex = this.f_19796_.m_188503_(2);
        switch (soundIndex) {
            case 0: {
                return (SoundEvent)FaunifySounds.RINGTAILCAT_IDLE_1.get();
            }
            case 1: {
                return (SoundEvent)FaunifySounds.RINGTAILCAT_IDLE_2.get();
            }
        }
        return (SoundEvent)FaunifySounds.RINGTAILCAT_IDLE_1.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)FaunifySounds.RINGTAILCAT_HURT.get();
    }

    public void m_8119_() {
        super.m_8119_();
    }

    public boolean m_7327_(Entity target) {
        boolean flag = target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (target instanceof MouseEntity || target instanceof Rabbit) {
            return super.m_7327_(target);
        }
        return flag;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean result = super.m_6469_(source, amount);
        if (this.m_5803_()) {
            this.setSleeping(false);
        }
        if (this.m_21825_()) {
            this.m_21837_(false);
            this.m_21839_(false);
        }
        return result;
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)variant.id);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (this.m_21824_() && this.m_21830_((LivingEntity)player)) {
            if (item == Items.f_42697_) {
                if (this.m_21223_() < this.m_21233_()) {
                    int particleCount = 5;
                    this.m_5634_(3.0f);
                    if (!player.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    for (int i = 0; i < particleCount; ++i) {
                        double offsetX = (this.f_19796_.m_188500_() - 0.5) * 1.0;
                        double offsetY = (this.f_19796_.m_188500_() - 0.5) * 1.0;
                        double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 1.0;
                        this.m_9236_().m_7106_((ParticleOptions)FaunifyParticleTypes.HEALTH.get(), this.m_20185_() + offsetX, this.m_20186_() + (double)this.m_20192_() + offsetY, this.m_20189_() + offsetZ, 0.0, 0.0, 0.0);
                    }
                } else {
                    this.toggleSittingState();
                }
                return InteractionResult.SUCCESS;
            }
            if (item == Items.f_42526_ || item == Items.f_42527_) {
                if (!this.m_27593_() && this.m_146764_() == 0) {
                    if (!this.m_9236_().f_46443_) {
                        this.m_27595_(player);
                        if (!player.m_150110_().f_35937_) {
                            itemstack.m_41774_(1);
                        }
                    }
                } else {
                    this.toggleSittingState();
                }
                return InteractionResult.SUCCESS;
            }
            if (itemstack.m_41619_() || item != Items.f_42526_ && item != Items.f_42527_ && item != Items.f_42697_) {
                this.toggleSittingState();
                return InteractionResult.SUCCESS;
            }
        }
        if (item == Items.f_42697_ && !this.m_21824_()) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (!this.m_9236_().f_46443_) {
                if (this.f_19796_.m_188503_(3) == 0) {
                    this.m_21828_(player);
                    this.m_21816_(player.m_20148_());
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    private void toggleSittingState() {
        boolean currentSittingState = this.m_21825_();
        this.m_21837_(!currentSittingState);
        if (!this.m_9236_().f_46443_) {
            if (!currentSittingState) {
                this.m_21573_().m_26573_();
            } else {
                this.m_21839_(false);
                this.m_21573_().m_26569_();
            }
        }
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == Items.f_42526_ || stack.m_41720_() == Items.f_42527_;
    }

    public boolean isStalking() {
        return (Boolean)this.f_19804_.m_135370_(STALKING);
    }

    public void setStalking(boolean stalking) {
        this.f_19804_.m_135381_(STALKING, (Object)stalking);
    }

    public boolean isDigging() {
        return (Boolean)this.f_19804_.m_135370_(DIGGING);
    }

    public void setDigging(boolean digging) {
        this.f_19804_.m_135381_(DIGGING, (Object)digging);
    }

    public static enum Variant implements StringRepresentable
    {
        REGULAR(0, "light"),
        BROWN(1, "brown"),
        GREY(2, "grey");

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int p_262571_, String p_262693_) {
            this.id = p_262571_;
            this.name = p_262693_;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int p_262643_) {
            return BY_ID.apply(p_262643_);
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Variant::values);
            BY_ID = ByIdMap.m_262839_(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }

    public class SleepGoal
    extends Goal {
        private final int countdownTime;
        private int countdown;

        public SleepGoal(int countdownTime) {
            this.countdownTime = countdownTime;
            this.countdown = RingtailCatEntity.this.f_19796_.m_188503_(SleepGoal.m_186073_((int)countdownTime));
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            if (RingtailCatEntity.this.isDigging()) {
                return false;
            }
            if (RingtailCatEntity.this.m_21824_() && !RingtailCatEntity.this.m_21825_()) {
                return false;
            }
            if (RingtailCatEntity.this.f_20900_ == 0.0f && RingtailCatEntity.this.f_20901_ == 0.0f && RingtailCatEntity.this.f_20902_ == 0.0f) {
                return this.canSleep() || RingtailCatEntity.this.m_5803_();
            }
            return false;
        }

        public boolean m_8045_() {
            if (RingtailCatEntity.this.isDigging()) {
                return false;
            }
            if (RingtailCatEntity.this.m_21824_() && !RingtailCatEntity.this.m_21825_()) {
                return false;
            }
            return this.canSleep();
        }

        private boolean canSleep() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return RingtailCatEntity.this.m_9236_().m_46462_();
        }

        public void m_8041_() {
            RingtailCatEntity.this.setSleeping(false);
            this.countdown = RingtailCatEntity.this.f_19796_.m_188503_(this.countdownTime);
        }

        public void m_8056_() {
            RingtailCatEntity.this.m_6862_(false);
            RingtailCatEntity.this.setSleeping(true);
            RingtailCatEntity.this.m_21573_().m_26573_();
        }

        public void m_8037_() {
            if (RingtailCatEntity.this.m_5803_()) {
                RingtailCatEntity.this.m_21573_().m_26573_();
            }
        }
    }

    public class RingtailStalkAndPounceGoal
    extends Goal {
        private final RingtailCatEntity ringtail;
        private int cooldown = 0;
        private static final double STALK_SPEED = 0.5;
        private static final double POUNCE_RANGE_SQ = 9.0;
        private static final double START_RANGE_SQ = 64.0;
        private static final int COOLDOWN_TICKS = 60;

        public RingtailStalkAndPounceGoal(RingtailCatEntity ringtail) {
            this.ringtail = ringtail;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            LivingEntity potentialTarget = this.ringtail.m_5448_();
            if (potentialTarget == null || !potentialTarget.m_6084_()) {
                return false;
            }
            if (!(potentialTarget instanceof Rabbit) && !(potentialTarget instanceof MouseEntity)) {
                return false;
            }
            return this.ringtail.m_20280_((Entity)potentialTarget) < 64.0;
        }

        public boolean m_8045_() {
            LivingEntity currentTarget = this.ringtail.m_5448_();
            if (currentTarget == null || !currentTarget.m_6084_()) {
                return false;
            }
            return this.ringtail.m_20280_((Entity)currentTarget) < 256.0;
        }

        public void m_8056_() {
            this.cooldown = 0;
            this.ringtail.setStalking(true);
        }

        public void m_8041_() {
            this.ringtail.m_21573_().m_26573_();
            this.ringtail.m_5496_((SoundEvent)FaunifySounds.RINGTAILCAT_ANGRY.get(), 0.5f, 1.0f);
            this.ringtail.setStalking(false);
        }

        public void m_8037_() {
            LivingEntity currentTarget = this.ringtail.m_5448_();
            if (currentTarget == null) {
                return;
            }
            this.ringtail.m_21563_().m_24960_((Entity)currentTarget, 30.0f, 30.0f);
            double distSq = this.ringtail.m_20280_((Entity)currentTarget);
            if (distSq > 9.0) {
                this.ringtail.m_21573_().m_5624_((Entity)currentTarget, 0.5);
            } else {
                this.ringtail.m_21573_().m_26573_();
                if (this.cooldown <= 0 && this.ringtail.m_20096_()) {
                    Vec3 dir = new Vec3(currentTarget.m_20185_() - this.ringtail.m_20185_(), currentTarget.m_20186_() - this.ringtail.m_20186_(), currentTarget.m_20189_() - this.ringtail.m_20189_()).m_82541_();
                    this.ringtail.m_20334_(dir.f_82479_ * 0.5, 0.6, dir.f_82481_ * 0.5);
                    this.ringtail.m_5496_((SoundEvent)FaunifySounds.RINGTAILCAT_GROWL.get(), 0.5f, 1.0f);
                    this.cooldown = 60;
                } else {
                    --this.cooldown;
                }
                if (this.cooldown <= 0) {
                    this.m_8041_();
                    return;
                }
                if (this.ringtail.m_20096_() && this.ringtail.m_20280_((Entity)currentTarget) < 2.0 && currentTarget.m_6084_()) {
                    currentTarget.m_6469_(this.ringtail.m_269291_().m_269333_((LivingEntity)this.ringtail), 5.0f);
                    this.ringtail.m_5496_(SoundEvents.f_12316_, 1.0f, 1.0f);
                }
            }
        }
    }

    public class MiningGoal
    extends Goal {
        private final RingtailCatEntity ringtail;
        private static final int SEARCH_RADIUS = 5;
        private static final long COOLDOWN_MILLIS = TimeUnit.MINUTES.toMillis(20L);
        private long lastShriekTime = 0L;
        private BlockPos targetOrePos;
        private int standStillTicks = 0;
        private static final int STAND_STILL_DURATION = 60;
        private static final int MAX_LOCK_ON_TICKS = 100;
        private int lockOnTicks = 0;
        private BlockPos diggingBlockPos = null;
        private int breakProgress = 0;
        private int totalBreakTicks = 0;

        public MiningGoal(RingtailCatEntity ringtail) {
            this.ringtail = ringtail;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            long now = System.currentTimeMillis();
            if (now - this.lastShriekTime < COOLDOWN_MILLIS) {
                return false;
            }
            Level level = this.ringtail.m_9236_();
            BlockPos origin = this.ringtail.m_20183_();
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)origin.m_7918_(-5, -5, -5), (BlockPos)origin.m_7918_(5, 5, 5))) {
                BlockState state = level.m_8055_(pos);
                if (!this.isRareOre(state)) continue;
                this.targetOrePos = pos.m_7949_();
                return true;
            }
            return false;
        }

        private boolean isRareOre(BlockState state) {
            return state.m_60713_(Blocks.f_50059_) || state.m_60713_(Blocks.f_152472_) || state.m_60713_(Blocks.f_49995_) || state.m_60713_(Blocks.f_152467_) || state.m_60713_(Blocks.f_50264_) || state.m_60713_(Blocks.f_152479_);
        }

        private boolean isSoftBlock(BlockState state) {
            return state.m_204336_(BlockTags.f_144274_) || state.m_204336_(BlockTags.f_13029_) || state.m_60713_(Blocks.f_50125_) || state.m_60713_(Blocks.f_49994_) || state.m_60713_(Blocks.f_50129_);
        }

        public void m_8056_() {
            if (this.targetOrePos != null) {
                this.ringtail.m_5496_((SoundEvent)FaunifySounds.RINGTAILCAT_ALERT.get(), 1.5f, 1.0f);
                this.lastShriekTime = System.currentTimeMillis();
                this.standStillTicks = 0;
                this.lockOnTicks = 0;
                this.updatePathToOre();
            }
        }

        private void updatePathToOre() {
            PathNavigation pathNavigation = this.ringtail.m_21573_();
            if (pathNavigation instanceof GroundPathNavigation) {
                GroundPathNavigation nav = (GroundPathNavigation)pathNavigation;
                nav.m_26519_((double)this.targetOrePos.m_123341_(), (double)this.targetOrePos.m_123342_(), (double)this.targetOrePos.m_123343_(), 1.0);
            }
        }

        public boolean m_8045_() {
            return this.targetOrePos != null && this.lockOnTicks < 100;
        }

        public void m_8041_() {
            this.targetOrePos = null;
            this.standStillTicks = 0;
            this.lockOnTicks = 0;
            this.clearDiggingAnimation();
            this.ringtail.setDigging(false);
            this.ringtail.m_21573_().m_26573_();
        }

        private void clearDiggingAnimation() {
            if (this.diggingBlockPos != null) {
                this.sendBlockBreakProgress(-1);
            }
            this.diggingBlockPos = null;
            this.breakProgress = 0;
            this.totalBreakTicks = 0;
        }

        public void m_8037_() {
            if (this.targetOrePos == null) {
                return;
            }
            Level level = this.ringtail.m_9236_();
            BlockPos ringtailPos = this.ringtail.m_20183_();
            if (this.isOreExposed(level, this.targetOrePos)) {
                this.m_8041_();
                return;
            }
            ++this.lockOnTicks;
            if (this.lockOnTicks >= 100) {
                this.m_8041_();
                return;
            }
            if (ringtailPos.m_123314_((Vec3i)this.targetOrePos, 2.0)) {
                ++this.standStillTicks;
                this.ringtail.m_21573_().m_26573_();
                if (this.diggingBlockPos != null) {
                    this.clearDiggingAnimation();
                    this.ringtail.setDigging(false);
                }
                if (this.standStillTicks >= 60) {
                    this.m_8041_();
                }
                return;
            }
            BlockPos blockInFront = this.getBlockInFront(ringtailPos, this.ringtail.m_146908_());
            BlockState blockAhead = level.m_8055_(blockInFront);
            if (this.isSoftBlock(blockAhead)) {
                this.ringtail.setDigging(true);
                if (this.diggingBlockPos == null || !this.diggingBlockPos.equals((Object)blockInFront)) {
                    if (this.diggingBlockPos != null && !this.diggingBlockPos.equals((Object)blockInFront)) {
                        this.sendBlockBreakProgress(-1);
                    }
                    this.diggingBlockPos = blockInFront.m_7949_();
                    this.breakProgress = 0;
                    this.totalBreakTicks = (int)(blockAhead.m_60800_((BlockGetter)level, blockInFront) * 20.0f);
                    this.sendBlockBreakProgress(0);
                }
                if (this.breakProgress < this.totalBreakTicks) {
                    ++this.breakProgress;
                    this.sendBlockBreakProgress((int)((float)this.breakProgress / (float)this.totalBreakTicks * 10.0f));
                } else {
                    level.m_46953_(this.diggingBlockPos, true, (Entity)this.ringtail);
                    this.sendBlockBreakProgress(-1);
                    this.diggingBlockPos = null;
                    this.breakProgress = 0;
                    this.totalBreakTicks = 0;
                }
                this.ringtail.m_21573_().m_26573_();
            } else {
                if (this.diggingBlockPos != null) {
                    this.clearDiggingAnimation();
                }
                this.ringtail.setDigging(false);
                this.ringtail.m_21566_().m_6849_((double)this.targetOrePos.m_123341_() + 0.5, (double)this.targetOrePos.m_123342_(), (double)this.targetOrePos.m_123343_() + 0.5, 1.0);
            }
        }

        private void sendBlockBreakProgress(int stage) {
            if (this.diggingBlockPos == null) {
                return;
            }
            for (ServerPlayer player : ((ServerLevel)this.ringtail.m_9236_()).m_6907_()) {
                player.f_8906_.m_9829_((Packet)new ClientboundBlockDestructionPacket(this.ringtail.m_19879_(), this.diggingBlockPos, stage));
            }
        }

        private BlockPos getBlockInFront(BlockPos currentPos, float yaw) {
            double rad = Math.toRadians(yaw);
            int offsetX = (int)Math.round(-Math.sin(rad));
            int offsetZ = (int)Math.round(Math.cos(rad));
            return currentPos.m_7918_(offsetX, 0, offsetZ);
        }

        private boolean isOreExposed(Level level, BlockPos pos) {
            for (Direction dir : Direction.values()) {
                if (!level.m_8055_(pos.m_121945_(dir)).m_60795_()) continue;
                return true;
            }
            return false;
        }
    }
}

