/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pepper.faunify.entity.ChinchillaEntity;
import com.pepper.faunify.entity.client.model.ChinchillaModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class ChinchillaRenderer
extends GeoEntityRenderer<ChinchillaEntity> {
    private static final ResourceLocation GREY = new ResourceLocation("faunify", "textures/entity/chinchilla1.png");
    private static final ResourceLocation BROWN = new ResourceLocation("faunify", "textures/entity/chinchilla2.png");
    private static final ResourceLocation BLACK = new ResourceLocation("faunify", "textures/entity/chinchilla3.png");
    private static final ResourceLocation WHITE = new ResourceLocation("faunify", "textures/entity/chinchilla4.png");
    private static final ResourceLocation GREY_SLEEPING = new ResourceLocation("faunify", "textures/entity/sleep/chinchilla1.png");
    private static final ResourceLocation BROWN_SLEEPING = new ResourceLocation("faunify", "textures/entity/sleep/chinchilla2.png");
    private static final ResourceLocation BLACK_SLEEPING = new ResourceLocation("faunify", "textures/entity/sleep/chinchilla3.png");
    private static final ResourceLocation WHITE_SLEEPING = new ResourceLocation("faunify", "textures/entity/sleep/chinchilla4.png");

    public ChinchillaRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new ChinchillaModel());
        this.f_114477_ = 0.5f;
    }

    public ResourceLocation getTextureLocation(ChinchillaEntity entity) {
        return ChinchillaRenderer.getVariantTexture(entity.getVariant(), entity.m_5803_());
    }

    public static ResourceLocation getVariantTexture(ChinchillaEntity.Variant variant, boolean isSleeping) {
        return switch (variant) {
            case ChinchillaEntity.Variant.GREY -> isSleeping ? GREY_SLEEPING : GREY;
            case ChinchillaEntity.Variant.BROWN -> isSleeping ? BROWN_SLEEPING : BROWN;
            case ChinchillaEntity.Variant.BLACK -> isSleeping ? BLACK_SLEEPING : BLACK;
            case ChinchillaEntity.Variant.WHITE -> isSleeping ? WHITE_SLEEPING : WHITE;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public static ResourceLocation getVariantTexture(ChinchillaEntity.Variant variant) {
        return ChinchillaRenderer.getVariantTexture(variant, false);
    }

    public void preRender(PoseStack stack, ChinchillaEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(stack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (animatable.m_6162_()) {
            float babyScale = 0.5f;
            stack.m_85841_(babyScale, babyScale, babyScale);
        } else {
            float adultScale = 0.8f;
            stack.m_85841_(adultScale, adultScale, adultScale);
        }
    }
}

