/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.goal;

import com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.SandSnapperEntity;
import com.yungnickyoung.minecraft.yungscavebiomes.module.ItemModule;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class SnapperTemptGoal
extends Goal {
    private final TargetingConditions targetingConditions;
    private final SandSnapperEntity sandSnapper;
    private final double speedModifier;
    private final float minPlayerDistance;
    @Nullable
    private Player player;
    private int cooldownTimer;
    private static final int COOLDOWN = 100;
    private final Ingredient items;

    public SnapperTemptGoal(SandSnapperEntity sandSnapper, double speedModifier, float minPlayerDistance, float maxPlayerDistance) {
        this.sandSnapper = sandSnapper;
        this.speedModifier = speedModifier;
        this.items = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemModule.PRICKLY_PEACH_ITEM.get()});
        this.minPlayerDistance = minPlayerDistance;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        this.targetingConditions = TargetingConditions.forNonCombat().ignoreLineOfSight().selector(this::isHoldingTemptingItem).range((double)maxPlayerDistance);
    }

    public boolean canUse() {
        if (this.sandSnapper.recentlyFedTimer > 0) {
            return false;
        }
        if (this.cooldownTimer > 0) {
            --this.cooldownTimer;
            return false;
        }
        this.player = this.sandSnapper.level().getNearestPlayer(this.targetingConditions, (LivingEntity)this.sandSnapper);
        return this.player != null;
    }

    public void start() {
        this.sandSnapper.setSubmerged(false);
        this.sandSnapper.setSubmergeLocked(true);
    }

    public void tick() {
        this.sandSnapper.getLookControl().setLookAt((Entity)this.player, (float)(this.sandSnapper.getMaxHeadYRot() + 20), (float)this.sandSnapper.getMaxHeadXRot());
        double sqrDist = this.sandSnapper.distanceToSqr((Entity)this.player);
        if (sqrDist < (double)(this.minPlayerDistance * this.minPlayerDistance)) {
            this.sandSnapper.getNavigation().stop();
        } else {
            this.sandSnapper.getNavigation().moveTo((Entity)this.player, this.speedModifier);
        }
    }

    public boolean canContinueToUse() {
        return this.canUse();
    }

    public void stop() {
        this.sandSnapper.setEating(false);
        this.sandSnapper.setSubmergeLocked(false);
        this.player = null;
        this.sandSnapper.getNavigation().stop();
        this.cooldownTimer = SnapperTemptGoal.reducedTickDelay((int)100);
    }

    private boolean isHoldingTemptingItem(LivingEntity livingEntity) {
        return this.items.test(livingEntity.getMainHandItem()) || this.items.test(livingEntity.getOffhandItem());
    }
}

