/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.mixin.frosted_caves;

import com.yungnickyoung.minecraft.yungscavebiomes.module.BiomeModule;
import com.yungnickyoung.minecraft.yungscavebiomes.world.NoiseSamplerBiomeHolder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.NoiseChunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Aquifer.NoiseBasedAquifer.class})
public abstract class AquiferMixin
implements Aquifer {
    @Shadow
    @Final
    private NoiseChunk noiseChunk;

    @Inject(method={"computeFluid"}, at={@At(value="RETURN")}, cancellable=true)
    private void yungscavebiomes_noLavaAquifersInFrostedCaves(int x, int y, int z, CallbackInfoReturnable<Aquifer.FluidStatus> cir) {
        Holder biome;
        Optional biomeKey;
        Aquifer.FluidStatus original = (Aquifer.FluidStatus)cir.getReturnValue();
        NoiseSamplerBiomeHolder holder = (NoiseSamplerBiomeHolder)this.noiseChunk;
        BiomeSource source = holder.getBiomeSource();
        Registry<Biome> biomes = holder.getBiomeRegistry();
        Climate.Sampler sampler = holder.getClimateSampler();
        if (biomes != null && (biomeKey = biomes.getResourceKey((Object)((Biome)(biome = source.getNoiseBiome(QuartPos.fromBlock((int)x), QuartPos.fromBlock((int)y), QuartPos.fromBlock((int)z), sampler)).value()))).isPresent() && biomeKey.get() == BiomeModule.FROSTED_CAVES) {
            int originalLevel = original.fluidLevel;
            cir.setReturnValue((Object)new Aquifer.FluidStatus(originalLevel, Blocks.WATER.defaultBlockState()));
        }
    }
}

