/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.world.feature.util;

import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;

public class DripstoneIceUtils {
    public static double getDripstoneHeight(double radialDistance, double radius, double scale, double bluntness) {
        if (radialDistance < bluntness) {
            radialDistance = bluntness;
        }
        double h = 0.384;
        double i = radialDistance / radius * h;
        double j = 0.75 * Math.pow(i, 1.3333333333333333);
        double k = Math.pow(i, 0.6666666666666666);
        double l = 0.3333333333333333 * Math.log(i);
        double m = scale * (j - k - l);
        m = Math.max(m, 0.0);
        return m / h * radius;
    }

    public static boolean isCircleMostlyEmbeddedInStone(WorldGenLevel worldGenLevel, BlockPos blockPos, int radius) {
        if (DripstoneIceUtils.isEmptyOrWaterOrLava((LevelAccessor)worldGenLevel, blockPos)) {
            return false;
        }
        float f = 6.0f;
        float increment = 6.0f / (float)radius;
        for (float theta = 0.0f; theta < (float)Math.PI * 2; theta += increment) {
            int dz;
            int dx = (int)(Mth.cos((float)theta) * (float)radius);
            if (!DripstoneIceUtils.isEmptyOrWaterOrLava((LevelAccessor)worldGenLevel, blockPos.offset(dx, 0, dz = (int)(Mth.sin((float)theta) * (float)radius)))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(LevelAccessor levelAccessor, BlockPos blockPos) {
        return levelAccessor.isStateAtPosition(blockPos, BlockBehaviour.BlockStateBase::isAir);
    }

    public static boolean isEmptyOrWater(LevelAccessor levelAccessor, BlockPos blockPos) {
        return levelAccessor.isStateAtPosition(blockPos, DripstoneIceUtils::isEmptyOrWater);
    }

    public static boolean isEmptyOrWaterOrLava(LevelAccessor levelAccessor, BlockPos blockPos) {
        return levelAccessor.isStateAtPosition(blockPos, DripstoneIceUtils::isEmptyOrWaterOrLava);
    }

    public static void buildBaseToTipColumn(Direction direction, int i, boolean bl, Consumer<BlockState> consumer) {
        if (i >= 3) {
            consumer.accept(DripstoneIceUtils.createIcicle(direction, DripstoneThickness.BASE));
            for (int j = 0; j < i - 3; ++j) {
                consumer.accept(DripstoneIceUtils.createIcicle(direction, DripstoneThickness.MIDDLE));
            }
        }
        if (i >= 2) {
            consumer.accept(DripstoneIceUtils.createIcicle(direction, DripstoneThickness.FRUSTUM));
        }
        if (i >= 1) {
            consumer.accept(DripstoneIceUtils.createIcicle(direction, bl ? DripstoneThickness.TIP_MERGE : DripstoneThickness.TIP));
        }
    }

    public static void growIcicle(LevelAccessor levelAccessor, BlockPos blockPos, Direction direction, int i, boolean bl) {
        if (DripstoneIceUtils.isIcicleBase(levelAccessor.getBlockState(blockPos.relative(direction.getOpposite())))) {
            BlockPos.MutableBlockPos mutable = blockPos.mutable();
            DripstoneIceUtils.buildBaseToTipColumn(direction, i, bl, blockState -> {
                levelAccessor.setBlock((BlockPos)mutable, blockState, 2);
                mutable.move(direction);
            });
        }
    }

    public static boolean placePackedIceIfPossible(LevelAccessor levelAccessor, BlockPos blockPos) {
        BlockState blockState = levelAccessor.getBlockState(blockPos);
        if (blockState.is(BlockTags.DRIPSTONE_REPLACEABLE)) {
            levelAccessor.setBlock(blockPos, Blocks.PACKED_ICE.defaultBlockState(), 2);
            return true;
        }
        return false;
    }

    private static BlockState createIcicle(Direction direction, DripstoneThickness dripstoneThickness) {
        return (BlockState)((Block)BlockModule.ICICLE.get()).defaultBlockState().setValue((Property)PointedDripstoneBlock.THICKNESS, (Comparable)dripstoneThickness);
    }

    public static boolean isDripstoneBaseOrLava(BlockState blockState) {
        return DripstoneIceUtils.isIcicleBase(blockState) || blockState.is(Blocks.LAVA);
    }

    public static boolean isIcicleBase(BlockState blockState) {
        return blockState.is(Blocks.PACKED_ICE) || blockState.is(BlockTags.DRIPSTONE_REPLACEABLE);
    }

    public static boolean isEmptyOrWater(BlockState blockState) {
        return blockState.isAir() || blockState.is(Blocks.WATER);
    }

    public static boolean isEmptyOrWaterOrLava(BlockState blockState) {
        return blockState.isAir() || blockState.is(Blocks.WATER) || blockState.is(Blocks.LAVA);
    }
}

