/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.block;

import com.yungnickyoung.minecraft.yungscavebiomes.module.CriteriaModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.EntityTypeModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.ItemModule;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_9062;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class PricklyPeachCactusBlock
extends class_2248
implements class_2256 {
    public static final class_2746 FRUIT = class_2741.field_28716;
    public static final class_2758 AGE = class_2741.field_12517;
    protected static final class_265 COLLISION_SHAPE = class_2248.method_9541((double)4.0, (double)0.0, (double)3.0, (double)12.0, (double)8.0, (double)11.0);
    protected static final class_265 OUTLINE_SHAPE = class_2248.method_9541((double)4.0, (double)0.0, (double)3.0, (double)12.0, (double)7.0, (double)11.0);
    private static final float AGE_CHANCE = 0.5f;
    private static final float BERRY_CHANCE = 0.1f;
    private static final int MAX_AGE = 25;

    public PricklyPeachCactusBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0))).method_11657((class_2769)FRUIT, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected class_9062 method_55765(class_1799 itemStack, class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        if (!PricklyPeachCactusBlock.isMaxAge(blockState) && itemStack.method_31574(class_1802.field_8324)) {
            return class_9062.field_47732;
        }
        return class_9062.field_47731;
    }

    @NotNull
    protected class_1269 method_55766(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_3965 hitResult) {
        if (((Boolean)blockState.method_11654((class_2769)FRUIT)).booleanValue()) {
            PricklyPeachCactusBlock.popFruit(level, blockPos);
            float volume = class_3532.method_32750((class_5819)level.field_9229, (float)0.8f, (float)1.2f);
            level.method_8396(null, blockPos, class_3417.field_28575, class_3419.field_15245, 1.0f, volume);
            level.method_8652(blockPos, (class_2680)((class_2680)blockState.method_11657((class_2769)FRUIT, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0)), 2);
        } else if (player.method_6047().method_7960()) {
            player.method_5643(level.method_48963().method_48826(), 1.0f);
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                CriteriaModule.INTERACT_EMPTY_PRICKLY_CACTUS.trigger(serverPlayer);
            }
        }
        return class_1269.method_29236((boolean)level.field_9236);
    }

    public void method_9588(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 random) {
        if (!blockState.method_26184((class_4538)serverLevel, blockPos)) {
            serverLevel.method_22352(blockPos, true);
        }
    }

    public void method_9514(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_5819 random) {
        if (PricklyPeachCactusBlock.isMaxAge(blockState) || PricklyPeachCactusBlock.hasFruit(blockState)) {
            return;
        }
        if (random.method_43058() < 0.5) {
            int newAge = (Integer)blockState.method_11654((class_2769)AGE) + 1;
            class_2680 newBlockState = (class_2680)blockState.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(newAge));
            if (random.method_43058() < (double)0.1f || newAge == 25) {
                newBlockState = (class_2680)newBlockState.method_11657((class_2769)FRUIT, (Comparable)Boolean.valueOf(true));
            }
            serverLevel.method_8501(blockPos, newBlockState);
        }
    }

    public void method_9565(class_2680 blockState, class_3218 serverLevel, class_2338 blockPos, class_1799 itemStack, boolean bl) {
        super.method_9565(blockState, serverLevel, blockPos, itemStack, bl);
        if (blockState.method_28498((class_2769)FRUIT) && ((Boolean)blockState.method_11654((class_2769)FRUIT)).booleanValue()) {
            class_2248.method_9577((class_1937)serverLevel, (class_2338)blockPos, (class_1799)new class_1799((class_1935)ItemModule.PRICKLY_PEACH_ITEM.get(), 1));
        }
    }

    public boolean method_9651(class_4538 levelReader, class_2338 blockPos, class_2680 blockState) {
        return blockState.method_28498((class_2769)FRUIT) && (Boolean)blockState.method_11654((class_2769)FRUIT) == false;
    }

    public boolean method_9650(class_1937 level, class_5819 random, class_2338 blockPos, class_2680 blockState) {
        return true;
    }

    public void method_9652(class_3218 serverLevel, class_5819 random, class_2338 blockPos, class_2680 blockState) {
        serverLevel.method_8652(blockPos, (class_2680)((class_2680)blockState.method_11657((class_2769)FRUIT, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)AGE, (Comparable)Integer.valueOf(25)), 2);
    }

    @NotNull
    public class_265 method_9549(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
        return COLLISION_SHAPE;
    }

    @NotNull
    public class_265 method_9530(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
        return OUTLINE_SHAPE;
    }

    public boolean method_9558(class_2680 blockState, class_4538 levelReader, class_2338 blockPos) {
        class_2680 blockStateBelow = levelReader.method_8320(blockPos.method_10074());
        return blockStateBelow.method_26164(class_3481.field_15466);
    }

    @NotNull
    public class_2680 method_9559(class_2680 currState, class_2350 neighborDirection, class_2680 neighborBlockState, class_1936 levelAccessor, class_2338 currPos, class_2338 neighborPos) {
        if (!currState.method_26184((class_4538)levelAccessor, currPos)) {
            levelAccessor.method_39279(currPos, (class_2248)this, 1);
        }
        return super.method_9559(currState, neighborDirection, neighborBlockState, levelAccessor, currPos, neighborPos);
    }

    public void method_9548(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1297 entity) {
        if (entity.method_5864() == EntityTypeModule.SAND_SNAPPER.get()) {
            return;
        }
        entity.method_5643(level.method_48963().method_48826(), 1.0f);
    }

    public boolean method_9516(class_2680 blockState, class_10 pathComputationType) {
        return false;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{AGE, FRUIT});
    }

    private static boolean isMaxAge(class_2680 blockState) {
        return blockState.method_28498((class_2769)AGE) && (Integer)blockState.method_11654((class_2769)AGE) == 25;
    }

    private static boolean hasFruit(class_2680 blockState) {
        return blockState.method_28498((class_2769)FRUIT) && (Boolean)blockState.method_11654((class_2769)FRUIT) != false;
    }

    private static void popFruit(class_1937 level, class_2338 $$1) {
        if (!level.field_9236 && level.method_8450().method_8355(class_1928.field_19392)) {
            double x = (double)$$1.method_10263() + 0.5;
            double y = (double)$$1.method_10264() + 0.5 - (double)(class_1299.field_6052.method_17686() / 2.0f);
            double z = (double)$$1.method_10260() + 0.5;
            double xOffset = class_3532.method_15366((class_5819)level.field_9229, (double)0.2, (double)0.25);
            double yOffset = 0.25;
            double zOffset = class_3532.method_15366((class_5819)level.field_9229, (double)0.2, (double)0.25);
            double dx = class_3532.method_15366((class_5819)level.field_9229, (double)0.075, (double)0.1);
            double dy = 0.2;
            double dz = class_3532.method_15366((class_5819)level.field_9229, (double)0.075, (double)0.1);
            if (level.field_9229.method_43056()) {
                xOffset *= -1.0;
                dx *= -1.0;
            }
            if (level.field_9229.method_43056()) {
                zOffset *= -1.0;
                dz *= -1.0;
            }
            class_1799 fruitItemStack = new class_1799((class_1935)ItemModule.PRICKLY_PEACH_ITEM.get(), 1);
            class_1542 itemEntity = new class_1542(level, x += xOffset, y += yOffset, z += zOffset, fruitItemStack, dx, dy, dz);
            itemEntity.method_6988();
            level.method_8649((class_1297)itemEntity);
        }
    }
}

