/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.goal;

import com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.SandSnapperEntity;
import com.yungnickyoung.minecraft.yungscavebiomes.mixin.accessor.BrushableBlockEntityAccessor;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.EntityTypeModule;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1352;
import net.minecraft.class_1408;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public class BuryLootGoal
extends class_1352 {
    private static final double MAX_ALLOWED_SQR_DISTANCE_TO_TARGET = 100.0;
    private final SandSnapperEntity sandSnapper;
    @Nullable
    private final class_1408 pathNav;
    private class_243 targetPos;
    private final int buryingDuration;
    private int buryingTimer;
    private final int xzRange;
    private final int yRange;
    private boolean isDone;

    public BuryLootGoal(SandSnapperEntity sandSnapper, int xzRange, int yRange, int buryingDuration) {
        this.sandSnapper = sandSnapper;
        this.pathNav = sandSnapper.method_5942();
        this.buryingDuration = buryingDuration;
        this.xzRange = xzRange;
        this.yRange = yRange;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
        if (this.sandSnapper.carryingItem.method_7960() || this.isDone) {
            return false;
        }
        this.targetPos = this.findTargetPos();
        return this.targetPos != null;
    }

    public boolean method_6266() {
        if (this.isDone) {
            return false;
        }
        if (!this.isBlockAValidTarget(class_2338.method_49638((class_2374)this.targetPos).method_10074())) {
            this.popItem();
            this.isDone = true;
            return false;
        }
        return this.buryingTimer > 0 || this.sandSnapper.method_5707(this.targetPos) < 100.0;
    }

    public void method_6269() {
        this.isDone = false;
    }

    public void method_6270() {
        this.sandSnapper.setForceSpawnDigParticles(false);
        this.buryingTimer = 0;
        this.isDone = false;
    }

    public void method_6268() {
        if (this.isDone) {
            return;
        }
        if (this.buryingTimer > 0) {
            --this.buryingTimer;
            if (this.buryingTimer == 0) {
                class_2680 blockStateOn = this.sandSnapper.method_25936();
                if (blockStateOn.method_27852(class_2246.field_10102)) {
                    this.sandSnapper.method_37908().method_8421((class_1297)this.sandSnapper, (byte)8);
                    this.sandSnapper.method_37908().method_8652(this.sandSnapper.method_23312(), class_2246.field_42728.method_9564(), 3);
                    this.sandSnapper.method_37908().method_35230(this.sandSnapper.method_23312(), class_2591.field_42780).ifPresentOrElse(blockEntity -> {
                        ((BrushableBlockEntityAccessor)blockEntity).setItem(this.sandSnapper.carryingItem);
                        this.sandSnapper.carryingItem = class_1799.field_8037;
                    }, this::popItem);
                } else if (blockStateOn.method_27852((class_2248)BlockModule.ANCIENT_SAND.get())) {
                    this.sandSnapper.method_37908().method_8421((class_1297)this.sandSnapper, (byte)9);
                    this.sandSnapper.method_37908().method_8652(this.sandSnapper.method_23312(), ((class_2248)BlockModule.SUSPICIOUS_ANCIENT_SAND.get()).method_9564(), 3);
                    this.sandSnapper.method_37908().method_35230(this.sandSnapper.method_23312(), (class_2591)EntityTypeModule.SUSPICIOUS_ANCIENT_SAND.get()).ifPresentOrElse(blockEntity -> {
                        blockEntity.setItem(this.sandSnapper.carryingItem);
                        this.sandSnapper.carryingItem = class_1799.field_8037;
                    }, this::popItem);
                } else if (blockStateOn.method_27852(class_2246.field_10255)) {
                    this.sandSnapper.method_37908().method_8421((class_1297)this.sandSnapper, (byte)10);
                    this.sandSnapper.method_37908().method_8652(this.sandSnapper.method_23312(), class_2246.field_43227.method_9564(), 3);
                    this.sandSnapper.method_37908().method_35230(this.sandSnapper.method_23312(), class_2591.field_42780).ifPresentOrElse(blockEntity -> {
                        ((BrushableBlockEntityAccessor)blockEntity).setItem(this.sandSnapper.carryingItem);
                        this.sandSnapper.carryingItem = class_1799.field_8037;
                    }, this::popItem);
                } else {
                    this.popItem();
                }
                this.isDone = true;
            } else if (this.buryingTimer == this.buryingDuration / 2) {
                this.sandSnapper.setForceSpawnDigParticles(true);
            }
        } else if (!this.sandSnapper.method_24515().equals((Object)class_2338.method_49638((class_2374)this.targetPos))) {
            double sqrDist = this.sandSnapper.method_19538().method_1025(this.targetPos);
            if (sqrDist > 4.0 && this.pathNav != null) {
                this.pathNav.method_6337(this.targetPos.method_10216(), this.targetPos.method_10214(), this.targetPos.method_10215(), 1.0);
            } else {
                this.sandSnapper.method_5962().method_6239(this.targetPos.method_10216(), this.targetPos.method_10214(), this.targetPos.method_10215(), 1.0);
            }
        } else {
            this.buryingTimer = this.buryingDuration;
            if (this.pathNav != null) {
                this.pathNav.method_6340();
            }
            if (!this.sandSnapper.isSubmerged() && !this.sandSnapper.isDiggingDown() && !this.sandSnapper.isDiving() && this.sandSnapper.canSubmerge(true)) {
                this.sandSnapper.setSubmerged(true);
            }
        }
    }

    public boolean method_38846() {
        return true;
    }

    public boolean method_6267() {
        return false;
    }

    @Nullable
    private class_243 findTargetPos() {
        return class_2338.method_25997((class_2338)this.sandSnapper.method_23312(), (int)this.xzRange, (int)this.yRange, this::isBlockAValidTarget).map(class_2338::method_10084).map(pos -> new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5)).orElse(null);
    }

    private boolean isBlockAValidTarget(class_2338 blockPos) {
        class_2248 block = this.sandSnapper.method_37908().method_8320(blockPos).method_26204();
        return (block == class_2246.field_10102 || block == BlockModule.ANCIENT_SAND.get() || block == class_2246.field_10255) && this.sandSnapper.method_37908().method_8320(blockPos.method_10084()).method_26215();
    }

    private void popItem() {
        if (!this.sandSnapper.carryingItem.method_7960()) {
            class_2338 spawnPos = this.sandSnapper.method_24515();
            double x = (double)spawnPos.method_10263() + 0.5;
            double y = (double)spawnPos.method_10264() + 0.5 - (double)(class_1299.field_6052.method_17686() / 2.0f);
            double z = (double)spawnPos.method_10260() + 0.5;
            class_5819 random = this.sandSnapper.method_59922();
            double xOffset = class_3532.method_15366((class_5819)random, (double)0.0, (double)0.2);
            double yOffset = 0.2;
            double zOffset = class_3532.method_15366((class_5819)random, (double)0.0, (double)0.2);
            double dx = class_3532.method_15366((class_5819)random, (double)0.0, (double)0.05);
            double dy = 0.2;
            double dz = class_3532.method_15366((class_5819)random, (double)0.0, (double)0.05);
            if (random.method_43056()) {
                xOffset *= -1.0;
                dx *= -1.0;
            }
            if (random.method_43056()) {
                zOffset *= -1.0;
                dz *= -1.0;
            }
            class_1542 itemEntity = new class_1542(this.sandSnapper.method_37908(), x += xOffset, y += yOffset, z += zOffset, this.sandSnapper.carryingItem, dx, dy, dz);
            itemEntity.method_6988();
            this.sandSnapper.method_37908().method_8649((class_1297)itemEntity);
            this.sandSnapper.carryingItem = class_1799.field_8037;
        }
    }
}

