/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.goal;

import com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.SandSnapperEntity;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import com.yungnickyoung.minecraft.yungscavebiomes.sandstorm.ISandstormServerDataProvider;
import com.yungnickyoung.minecraft.yungscavebiomes.sandstorm.SandstormServerData;
import java.util.EnumSet;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1408;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_4051;
import net.minecraft.class_5535;
import net.minecraft.class_5819;

public class RunFromPlayerGoal
extends class_1352 {
    private static final double UPDATE_TARGET_POS_DISTANCE_SQUARED = 9.0;
    private static final int REFRESH_PATH_INTERVAL = 20;
    private final SandSnapperEntity sandSnapper;
    private final double speedModifier;
    private final double submergedSpeedModifier;
    @Nullable
    protected class_1657 playerToAvoid;
    protected final float maxDist;
    @Nullable
    protected class_11 path;
    protected final class_1408 pathNav;
    private final class_4051 avoidEntityTargeting;
    private int refreshPathTimer;

    public RunFromPlayerGoal(SandSnapperEntity sandSnapper, float dist, double speedModifier, double submergedSpeedModifier) {
        this(sandSnapper, dist, speedModifier, submergedSpeedModifier, class_1301.field_6156::test);
    }

    private RunFromPlayerGoal(SandSnapperEntity sandSnapper, float maxDist, double speedModifier, double submergedSpeedModifier, Predicate<class_1309> avoidEntityPredicate) {
        this.sandSnapper = sandSnapper;
        this.maxDist = maxDist;
        this.speedModifier = speedModifier;
        this.submergedSpeedModifier = submergedSpeedModifier;
        this.pathNav = sandSnapper.method_5942();
        this.avoidEntityTargeting = class_4051.method_36625().method_18418((double)maxDist).method_18420(avoidEntityPredicate);
        this.refreshPathTimer = this.method_38847(20);
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public void method_6269() {
        this.pathNav.method_6334(this.path, this.speedModifier);
        if (!this.sandSnapper.isSubmerged() && this.sandSnapper.canSubmerge(true)) {
            this.sandSnapper.setSubmerged(true);
        }
    }

    public void method_6270() {
        this.playerToAvoid = null;
        this.refreshPathTimer = this.method_38847(20);
    }

    public void method_6268() {
        if (!this.sandSnapper.isSubmerged() && this.sandSnapper.canSubmerge(true)) {
            this.sandSnapper.setSubmerged(true);
            this.sandSnapper.tryPlayPanicSound();
        }
        double multiplier = this.sandSnapper.isSubmerged() ? this.submergedSpeedModifier : 1.0;
        this.sandSnapper.method_5942().method_6344(this.speedModifier * multiplier);
        --this.refreshPathTimer;
        if (this.playerToAvoid != null && this.refreshPathTimer <= 0 && this.playerToAvoid.method_5858((class_1297)this.sandSnapper) < 9.0) {
            this.refreshPathTimer = this.method_38847(20);
            class_243 newTargetPos = this.findTargetPos();
            if (newTargetPos != null && this.sandSnapper.canMove()) {
                this.path = this.pathNav.method_6352(newTargetPos.field_1352, newTargetPos.field_1351, newTargetPos.field_1350, 0);
                this.pathNav.method_6334(this.path, this.speedModifier);
            }
        }
    }

    public boolean method_6264() {
        if (this.sandSnapper.friendlyTimer > 0 || !this.sandSnapper.canMove() || this.sandSnapper.method_16914()) {
            return false;
        }
        this.playerToAvoid = (class_1657)this.sandSnapper.method_37908().method_18468(this.sandSnapper.method_37908().method_8390(class_1657.class, this.sandSnapper.method_5829().method_1009((double)this.maxDist, 3.0, (double)this.maxDist), p -> true), this.avoidEntityTargeting, (class_1309)this.sandSnapper, this.sandSnapper.method_23317(), this.sandSnapper.method_23318(), this.sandSnapper.method_23321());
        class_243 targetPos = this.findTargetPos();
        if (targetPos == null) {
            return false;
        }
        this.path = this.pathNav.method_6352(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350, 0);
        return this.path != null && !this.isInActiveSandstorm();
    }

    public boolean method_6266() {
        return this.sandSnapper.friendlyTimer <= 0 && !this.pathNav.method_6357() && !this.isInActiveSandstorm() && !this.sandSnapper.method_16914();
    }

    public boolean method_6267() {
        return false;
    }

    @Nullable
    private class_243 findTargetPos() {
        if (this.playerToAvoid == null) {
            return null;
        }
        int minHorizontalDist = 4;
        int maxHorizontalDist = 16;
        int maxVerticalDist = 7;
        Function<class_2338, Boolean> isValidSandPos = pos -> this.sandSnapper.method_37908().method_8320(pos).method_26164(BlockModule.SAND_SNAPPER_BLOCKS) && this.sandSnapper.method_37908().method_8320(pos.method_10084()).method_26215();
        class_243 targetPos = this.getPosAway(minHorizontalDist, maxHorizontalDist, maxVerticalDist, 1.5707963267948966, this.playerToAvoid.method_19538(), isValidSandPos);
        if (targetPos == null) {
            targetPos = this.getPosAway(minHorizontalDist, maxHorizontalDist, maxVerticalDist, 4.71238898038469, this.playerToAvoid.method_19538(), isValidSandPos);
        }
        if (targetPos == null) {
            targetPos = this.getPosAway(minHorizontalDist, maxHorizontalDist, maxVerticalDist, 1.5707963267948966, this.playerToAvoid.method_19538(), null);
        }
        if (targetPos == null) {
            targetPos = this.getPosAway(0, maxHorizontalDist, maxVerticalDist, 1.5707963267948966, this.playerToAvoid.method_19538(), null);
        }
        return targetPos;
    }

    @Nullable
    private class_243 getPosAway(int minHorizontalDist, int maxHorizontalDist, int maxVerticalDist, double searchAngle, class_243 avoidPos, @Nullable Function<class_2338, Boolean> blockFilter) {
        class_243 awayDirection = this.sandSnapper.method_19538().method_1020(avoidPos);
        return class_5535.method_31538((class_1314)this.sandSnapper, () -> {
            class_2338 randomlyOffsetPos = RunFromPlayerGoal.generateRandomOffsetInDirection(this.sandSnapper.method_59922(), minHorizontalDist, maxHorizontalDist, maxVerticalDist, awayDirection.field_1352, awayDirection.field_1350, searchAngle);
            class_2338 pos = class_2338.method_49637((double)(this.sandSnapper.method_23317() + (double)randomlyOffsetPos.method_10263()), (double)(this.sandSnapper.method_23318() + (double)randomlyOffsetPos.method_10264()), (double)(this.sandSnapper.method_23321() + (double)randomlyOffsetPos.method_10260()));
            return blockFilter == null || (Boolean)blockFilter.apply(pos) != false ? pos : null;
        });
    }

    private static class_2338 generateRandomOffsetInDirection(class_5819 random, int minHorizontalDist, int maxHorizontalDistance, int maxVerticalDistance, double dirX, double dirZ, double searchAngle) {
        double theta = Math.atan2(dirZ, dirX);
        double randomAngleOffset = random.method_43058() * searchAngle - searchAngle / 2.0;
        double randomAngle = theta + randomAngleOffset;
        double amplitude = Math.sqrt(random.method_43058()) * (double)(maxHorizontalDistance - minHorizontalDist) + (double)minHorizontalDist;
        double randomX = amplitude * Math.cos(randomAngle);
        double randomZ = amplitude * Math.sin(randomAngle);
        int randomY = random.method_43048(2 * maxVerticalDistance + 1) - maxVerticalDistance;
        return class_2338.method_49637((double)randomX, (double)randomY, (double)randomZ);
    }

    private boolean isInActiveSandstorm() {
        SandstormServerData sandstormServerData = ((ISandstormServerDataProvider)this.sandSnapper.method_37908()).getSandstormServerData();
        return sandstormServerData.isSandstormActive();
    }
}

