/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.world.feature;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.yungscavebiomes.block.IceSheetBlock;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import com.yungnickyoung.minecraft.yungscavebiomes.world.feature.IceSheetConfiguration;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_5281;
import net.minecraft.class_5821;

public class IceSheetFeature
extends class_3031<IceSheetConfiguration> {
    public IceSheetFeature(Codec<IceSheetConfiguration> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<IceSheetConfiguration> featurePlaceContext) {
        class_5281 worldGenLevel = featurePlaceContext.method_33652();
        class_2338 originPos = featurePlaceContext.method_33655();
        IceSheetConfiguration config = (IceSheetConfiguration)featurePlaceContext.method_33656();
        int radius = config.searchRange;
        class_2338.class_2339 blockPos = originPos.method_25503();
        class_2338.class_2339 neighborPos = blockPos.method_25503();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    double dx = (double)x / (double)radius;
                    double dy = (double)y / (double)radius;
                    double dz = (double)z / (double)radius;
                    if (dx * dx + dy * dy + dz * dz > 1.0) continue;
                    blockPos.method_25504((class_2382)originPos, x, y, z);
                    class_2680 blockState = worldGenLevel.method_8320((class_2338)blockPos);
                    if (!IceSheetFeature.isAirOrWater(blockState)) continue;
                    for (class_2350 direction : config.validDirections) {
                        IceSheetBlock iceSheetBlock;
                        class_2680 updatedBlockState;
                        neighborPos.method_25505((class_2382)blockPos, direction);
                        class_2680 neighborBlockState = worldGenLevel.method_8320((class_2338)neighborPos);
                        if (neighborBlockState.method_26164(BlockModule.ICE_SHEET_FEATURE_AVOID) || (updatedBlockState = (iceSheetBlock = (IceSheetBlock)((Object)BlockModule.ICE_SHEET.get())).method_33362(blockState, (class_1922)worldGenLevel, (class_2338)blockPos, direction)) == null) continue;
                        blockState = updatedBlockState;
                    }
                    if (!blockState.method_27852((class_2248)BlockModule.ICE_SHEET.get())) continue;
                    blockState = (class_2680)blockState.method_11657((class_2769)IceSheetBlock.GROWTH_DISTANCE, (Comparable)Integer.valueOf(3));
                    worldGenLevel.method_8652((class_2338)blockPos, blockState, 3);
                    worldGenLevel.method_22350((class_2338)blockPos).method_12039((class_2338)blockPos);
                }
            }
        }
        return true;
    }

    private static boolean isAirOrWater(class_2680 blockState) {
        return blockState.method_26215() || blockState.method_27852(class_2246.field_10382);
    }
}

