/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.world.feature;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.yungscavebiomes.world.noise.CellularNoise;
import com.yungnickyoung.minecraft.yungscavebiomes.world.noise.OpenSimplex2S;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_5281;
import net.minecraft.class_5821;
import org.joml.Vector3f;

public class WaterSurfaceIceFragmentFeature
extends class_3031<class_3111> {
    private static final int MIN_MAX_FLOOD_RADIUS = 8;
    private static final int MAX_MAX_FLOOD_RADIUS = 12;
    private static final int EFFECTIVE_MAX_FLOOD_RADIUS = 11;
    private static final int EFFECTIVE_MAX_FLOOD_DIAMETER = 23;
    private static final int MAX_FLOOD_RADIUS_RANGE = 4;
    private static final float FLOOD_BOUNDARY_NOISE_FREQUENCY = 0.1f;
    private static final long FLOOD_BOUNDARY_NOISE_SEED_FLIP = -3496757360140900525L;
    private static final float ICE_FRAGMENT_SEPARATION = 0.15f;
    private static final float ICE_FRAGMENT_NOISE_FREQUENCY = 0.083333336f;
    private static final float DOMAIN_WARP_FREQUENCY = 0.083333336f;
    private static final float DOMAIN_WARP_AMPLITUDE = 4.0f;
    private static final long WARP_NOISE_SEED_FLIP = 3811143571666535007L;
    private static final long CELL_NOISE_SEED_FLIP = 6534415494888897672L;
    private static final ThreadLocal<IceFragmentFiller> iceFragmentFillerThreadLocal = ThreadLocal.withInitial(IceFragmentFiller::new);

    public WaterSurfaceIceFragmentFeature(Codec<class_3111> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<class_3111> context) {
        class_5281 level = context.method_33652();
        class_2338 origin = context.method_33655();
        iceFragmentFillerThreadLocal.get().execute(origin, level);
        return false;
    }

    private static class IceFragmentFiller {
        private final Queue<class_2338> floodQueue = new ArrayDeque<class_2338>(529);
        private final boolean[] visited = new boolean[529];
        private final Vector3f domainWarpVector = new Vector3f();

        public void execute(class_2338 origin, class_5281 level) {
            long seed = level.method_8412();
            long noiseSeedWarp = seed ^ 0x34E3E6E2D932825FL;
            long noiseSeedCell = seed ^ 0x5AAEE84593A93C88L;
            long noiseSeedFlood = seed ^ 0xCF7905B52311A753L;
            this.floodQueue.clear();
            Arrays.fill(this.visited, false);
            this.floodQueue.add(origin);
            while (!this.floodQueue.isEmpty()) {
                class_2338 currentPos = this.floodQueue.poll();
                class_2680 currentState = level.method_8320(currentPos);
                if (!currentState.method_27852(class_2246.field_10382) && !currentState.method_27852(class_2246.field_10295)) continue;
                OpenSimplex2S.vec3Noise3_ImproveXZ(noiseSeedWarp, (float)currentPos.method_10263() * 0.083333336f, (float)currentPos.method_10264() * 0.083333336f, (float)currentPos.method_10260() * 0.083333336f, this.domainWarpVector);
                float iceShardNoiseValue = CellularNoise.sampleDistance2Sub_ImproveXZ(noiseSeedCell, (float)currentPos.method_10263() * 0.083333336f + this.domainWarpVector.x() * 0.33333334f, (float)currentPos.method_10264() * 0.083333336f + this.domainWarpVector.y() * 0.33333334f, (float)currentPos.method_10260() * 0.083333336f + this.domainWarpVector.z() * 0.33333334f);
                if (iceShardNoiseValue <= 0.15f) continue;
                level.method_8652(currentPos, class_2246.field_10295.method_9564(), 2);
                this.considerNeighbor(noiseSeedFlood, origin, currentPos.method_10078());
                this.considerNeighbor(noiseSeedFlood, origin, currentPos.method_10067());
                this.considerNeighbor(noiseSeedFlood, origin, currentPos.method_10072());
                this.considerNeighbor(noiseSeedFlood, origin, currentPos.method_10095());
            }
        }

        private void considerNeighbor(long noiseSeedFlood, class_2338 origin, class_2338 neighborPos) {
            float noiseValue;
            float noisyRadius;
            int dx = neighborPos.method_10263() - origin.method_10263();
            int dz = neighborPos.method_10260() - origin.method_10260();
            if (dx < -11 || dx > 11 || dz < -11 || dz > 11) {
                return;
            }
            int visitedIndex = (dz + 11) * 23 + (dx + 11);
            if (this.visited[visitedIndex]) {
                return;
            }
            this.visited[visitedIndex] = true;
            float distSq = dx * dx + dz * dz;
            if (distSq > 121.0f) {
                return;
            }
            if (distSq > 64.0f && distSq > (noisyRadius = (noiseValue = OpenSimplex2S.noise3_ImproveXZ(noiseSeedFlood, (float)(origin.method_10263() + dx) * 0.1f, (float)origin.method_10264() * 0.1f, (float)(origin.method_10260() + dz) * 0.1f)) * 2.0f + 10.0f) * noisyRadius) {
                return;
            }
            this.floodQueue.add(neighborPos);
        }
    }
}

